/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.znts.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.smart.znts.entity.CloudQueryItem;
import com.geoway.ns.smart.znts.entity.CloudQueryPlanItem;
import com.geoway.ns.smart.znts.entity.CloudQueryPlanUser;
import com.geoway.ns.smart.znts.mapper.CloudQueryItemMapper;
import com.geoway.ns.smart.znts.service.CloudQueryItemService;
import com.geoway.ns.smart.znts.service.CloudQueryPlanItemService;
import com.geoway.ns.smart.znts.service.CloudQueryPlanUserService;
import com.geoway.ns.sys.dto.SimpleRole;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.enums.SysPowerEnum;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.service.SysPowerService;
import com.geoway.ns.sys.support.ServletUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CloudQueryItemServiceImpl
extends ServiceImpl<CloudQueryItemMapper, CloudQueryItem>
implements CloudQueryItemService {
    @Resource
    private CloudQueryPlanUserService cloudQueryPlanUserService;
    @Resource
    private CloudQueryPlanItemService cloudQueryPlanItemService;
    @Resource
    private ITokenService tokenService;
    @Autowired
    private SysPowerService sysPowerService;

    @Override
    public List<CloudQueryItem> queryDefault(Integer displaySet) {
        return this.queryByTagOrAll("\u57fa\u7840\u67e5\u8be2", displaySet);
    }

    @Override
    public List<CloudQueryItem> queryByTagOrAll(String tag, Integer displaySet) {
        LambdaQueryChainWrapper lambdaQuery = this.lambdaQuery();
        if (StringUtils.isNotBlank((CharSequence)tag)) {
            lambdaQuery = (LambdaQueryChainWrapper)lambdaQuery.eq(CloudQueryItem::getTag, (Object)tag);
        }
        if (displaySet != null) {
            lambdaQuery = (LambdaQueryChainWrapper)lambdaQuery.eq(CloudQueryItem::getDisplaySet, (Object)displaySet);
        }
        return ((LambdaQueryChainWrapper)lambdaQuery.orderByAsc(CloudQueryItem::getOrder)).list();
    }

    @Override
    public String getPlanIdByToken() {
        String token = ServletUtils.getHeaderValues((String)"access_token");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            SysUserDTO sysUser = null;
            try {
                sysUser = this.tokenService.querySysUserByToken(token);
                List lshs = this.sysPowerService.selectByToken(SysPowerEnum.ZNTS.value, sysUser.getRoles().stream().map(SimpleRole::getId).map(String::valueOf).collect(Collectors.toList()), sysUser.getId());
                List lhsIds = lshs.stream().map(sysPower -> sysPower.getMandateId()).collect(Collectors.toList());
                if (lhsIds.size() > 0) {
                    return (String)lhsIds.get(0);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public List<CloudQueryItem> getUserCloudQueryItems(String userId, String wkt, String group, String layers, Integer displaySet) {
        String planId;
        CloudQueryPlanUser cloudQueryPlanUser = this.cloudQueryPlanUserService.getByUserId(userId);
        String string = planId = cloudQueryPlanUser == null ? this.getPlanIdByToken() : cloudQueryPlanUser.getPlanId();
        if (StringUtils.isBlank((CharSequence)planId)) {
            return this.queryDefault(displaySet);
        }
        List<String> layerlist = null;
        if (StringUtils.isNotEmpty((CharSequence)layers)) {
            layerlist = Arrays.asList(layers.split(","));
        }
        List<CloudQueryItem> cloudQueryItems = ((CloudQueryItemMapper)this.baseMapper).queryItemByNameTime2Tag(layerlist, group, displaySet);
        List<CloudQueryPlanItem> cloudQueryPlanItems = this.cloudQueryPlanItemService.queryByPlanId(planId);
        if (!CollectionUtils.isEmpty(cloudQueryPlanItems)) {
            cloudQueryItems = cloudQueryItems.stream().filter(cloudQueryItem -> cloudQueryPlanItems.stream().noneMatch(cloudQueryPlanItem -> cloudQueryPlanItem.getItemId().equals(cloudQueryItem.getId()))).collect(Collectors.toList());
        }
        return cloudQueryItems;
    }
}

