/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.zntsnew.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.ns.onemap.encrypttool.entity.EncryptType;
import com.geoway.ns.onemap.encrypttool.service.BizEncryptRecordsService;
import com.geoway.ns.smart.znts.entity.CloudQueryPlan;
import com.geoway.ns.smart.znts.entity.CloudQueryPlanUser;
import com.geoway.ns.smart.znts.service.CloudQueryPlanService;
import com.geoway.ns.smart.znts.service.CloudQueryPlanUserService;
import com.geoway.ns.smart.znts.service.NationalCloudQueryService;
import com.geoway.ns.smart.znts.service.ProvincialCloudQueryService;
import com.geoway.ns.smart.zntsnew.dto.CentroidInfo;
import com.geoway.ns.smart.zntsnew.dto.CloudAnalaysParamDTO;
import com.geoway.ns.smart.zntsnew.entity.CloudQueryRecordNew;
import com.geoway.ns.smart.zntsnew.entity.CloudQueryTask;
import com.geoway.ns.smart.zntsnew.enums.CloudQueryGroup;
import com.geoway.ns.smart.zntsnew.service.CloudQueryGJService;
import com.geoway.ns.smart.zntsnew.service.CloudQueryManageService;
import com.geoway.ns.smart.zntsnew.service.CloudQueryRecordNewService;
import com.geoway.ns.smart.zntsnew.service.CloudQuerySJService;
import com.geoway.ns.smart.zntsnew.service.CloudQueryTaskService;
import com.geoway.ns.smart.zntsnew.util.TaskGeoCentroidTools;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class CloudQueryManageServiceImpl
implements CloudQueryManageService {
    @Autowired
    private ProvincialCloudQueryService provincialCloudQueryService;
    @Autowired
    private NationalCloudQueryService nationalCloudQueryService;
    @Autowired
    private CloudQuerySJService cloudQuerySJService;
    @Autowired
    private CloudQueryGJService cloudQueryGJService;
    @Autowired
    private CloudQueryTaskService cloudQueryTaskService;
    @Autowired
    private CloudQueryRecordNewService cloudQueryRecordNewService;
    @Autowired
    private CloudQueryPlanService cloudQueryPlanService;
    @Autowired
    private CloudQueryPlanUserService cloudQueryPlanUserService;
    @Autowired
    private BizEncryptRecordsService bizEncryptRecordsService;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private TaskGeoCentroidTools taskGeoCentroidTools;

    @Override
    public Map<String, Object> queryCloudConfig(String planId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sj", this.provincialCloudQueryService.getCloudQueryConfig(planId));
        map.put("gj", this.nationalCloudQueryService.getCloudList(planId));
        return map;
    }

    @Override
    public JSONArray queryCloudRule(String planId, String userId) {
        CloudQueryPlan plan = StringUtils.isBlank((CharSequence)planId) ? this.cloudQueryPlanService.getByUserId(userId) : (CloudQueryPlan)this.cloudQueryPlanService.getById((Serializable)((Object)planId));
        return this.cloudQuerySJService.queryRule(plan.getServiceName());
    }

    @Override
    public String addCloudQuery(CloudAnalaysParamDTO param, String userId) throws Exception {
        return this.addCloudQuery(param, userId, null, null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String addCloudQuery(CloudAnalaysParamDTO param, String userId, String planId, JSONObject xmInfo) throws Exception {
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty(param.getWkts()), (String)"wkts\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CloudQueryTask task = CloudQueryTask.builder().id(UUID.randomUUID().toString()).userId(userId).createTime(new Date()).status(0).param(JSON.toJSONString((Object)param)).name(param.getName()).tag(param.getTag()).build();
        if (param.isEncrypt()) {
            this.wktEncypt(param);
        }
        CentroidInfo info = this.taskGeoCentroidTools.getInfo(param.getWkts());
        task.setLat(info.getLat());
        task.setLon(info.getLon());
        task.setAddress(info.getXzqmc());
        task.setArea(info.getArea());
        CloudQueryPlan plan = StringUtils.isNotBlank((CharSequence)planId) ? (CloudQueryPlan)this.cloudQueryPlanService.getById((Serializable)((Object)planId)) : this.cloudQueryPlanService.getByUserId(userId);
        this.checkUse(plan, userId, info.getArea());
        if (ObjectUtils.isNotEmpty(param.getCountry())) {
            this.cloudQueryGJService.sendCloudQuery(userId, task.getId(), param, info);
        }
        if (ObjectUtils.isNotEmpty(param.getProvince())) {
            this.cloudQuerySJService.sendCloudQuery(plan, task.getId(), param, task.getAddress(), xmInfo);
        }
        this.cloudQueryTaskService.saveInfo(task);
        return task.getId();
    }

    @Override
    public IPage<CloudQueryTask> queryTaskPage(String userId, Integer page, Integer size, String tag) {
        return this.cloudQueryTaskService.queryPage(userId, page, size, tag);
    }

    @Override
    public CloudQueryTask queryTaskInfo(String taskId) {
        return this.cloudQueryTaskService.queryInfoById(taskId);
    }

    @Override
    public JSONObject queryRuleResult(String rid) {
        return this.cloudQuerySJService.queryRuleResult(rid);
    }

    @Override
    public JSONArray queryAnalysResult(String rid, String serviceIds) {
        if (StringUtils.isBlank((CharSequence)serviceIds)) {
            return this.cloudQuerySJService.queryAnalysResult(rid, serviceIds);
        }
        String[] split = serviceIds.split(",");
        if (split.length > 1) {
            JSONArray jsonArray = this.cloudQuerySJService.queryAnalysResult(rid, serviceIds);
            this.cacheRes(jsonArray, rid);
            return jsonArray;
        }
        BoundValueOperations boundValueOps = this.redisTemplate.boundValueOps((Object)("cloudQueryRes:" + rid + "-" + serviceIds));
        Object res = boundValueOps.get();
        if (res == null) {
            JSONArray array = this.cloudQuerySJService.queryAnalysResult(rid, serviceIds);
            this.cacheRes(array, rid);
            return array;
        }
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(res);
        return jsonArray;
    }

    @Override
    public JSONObject queryAnalysResultCountry(String rid, String group) {
        return this.cloudQueryGJService.queryAnalysResult(rid, group);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteTaskById(String id) {
        this.cloudQueryTaskService.removeById((Serializable)((Object)id));
        this.cloudQueryRecordNewService.remove((Wrapper)Wrappers.lambdaQuery(CloudQueryRecordNew.class).eq(CloudQueryRecordNew::getTaskId, (Object)id));
    }

    @Override
    public Map<String, Object> queryTaskInfoWithConfig(String taskId, String planId) throws Exception {
        CloudQueryTask cloudQueryTask = this.cloudQueryTaskService.queryInfoById(taskId);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("result", cloudQueryTask);
        data.put("config", this.queryCloudConfig(planId));
        return data;
    }

    @Override
    public List<JSONObject> queryAnalysStatus(String rid) {
        CloudQueryRecordNew one = (CloudQueryRecordNew)this.cloudQueryRecordNewService.getOne((Wrapper)Wrappers.lambdaQuery(CloudQueryRecordNew.class).eq(CloudQueryRecordNew::getRid, (Object)rid));
        JSONArray objects = this.cloudQuerySJService.queryAnalysStatus(rid);
        List<JSONObject> javaList = objects.toJavaList(JSONObject.class);
        List<String> cids = Arrays.asList(one.getCid().split(","));
        javaList = javaList.stream().map(m -> {
            Integer status = m.getInteger("status");
            String serviceId = m.getString("serviceId");
            m = new JSONObject();
            m.put("serviceId", (Object)serviceId);
            m.put("status", (Object)status);
            return m;
        }).filter(f -> {
            String serviceId = f.getString("serviceId");
            return cids.contains(serviceId);
        }).collect(Collectors.toList());
        return javaList;
    }

    @Override
    public void exportReport(HttpServletResponse response, String taskId) {
        CloudQueryRecordNew record = this.cloudQueryRecordNewService.getSjTask(taskId);
        String rid = record.getRid();
        this.cloudQuerySJService.exportReport(response, rid);
    }

    @Override
    public JSONObject findReport(String planId, String userId) {
        CloudQueryPlan plan = StringUtils.isNotBlank((CharSequence)planId) ? (CloudQueryPlan)this.cloudQueryPlanService.getById((Serializable)((Object)planId)) : this.cloudQueryPlanService.getByUserId(userId);
        return this.cloudQuerySJService.findReport(plan.getDtspId());
    }

    @Override
    public JSONObject findTaskParam(String rid) {
        return this.cloudQuerySJService.findTaskParam(rid);
    }

    @Override
    public List findRuleRes(String taskId, String planId, String limitType, Boolean result, Integer verify) {
        CloudQueryRecordNew sjTask = this.cloudQueryRecordNewService.getSjTask(taskId);
        CloudQueryPlan plan = (CloudQueryPlan)this.cloudQueryPlanService.getById((Serializable)((Object)planId));
        return this.cloudQuerySJService.findRuleResult(plan.getServiceName(), sjTask.getRid(), limitType, result, verify);
    }

    private void checkUse(CloudQueryPlan plan, String userId, Double area) {
        if (CloudQueryGroup.TY.type.equals(plan.getGroup())) {
            if (plan.getLimitTimes() != null) {
                LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(CloudQueryPlanUser.class);
                ((LambdaQueryWrapper)wrapper.eq(CloudQueryPlanUser::getUserId, (Object)userId)).eq(CloudQueryPlanUser::getPlanId, (Object)plan.getId());
                CloudQueryPlanUser planUser = (CloudQueryPlanUser)this.cloudQueryPlanUserService.getOne((Wrapper)wrapper);
                if (planUser != null) {
                    Integer index = planUser.getQueryTime() + 1;
                    if (plan.getLimitTimes() != null && index > plan.getLimitTimes()) {
                        throw new RuntimeException("\u5f53\u524d\u7d2f\u8ba1\u67e5\u8be2\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650\u3010" + plan.getLimitTimes() + "\u3011\uff01");
                    }
                    planUser.setQueryTime(index);
                    this.cloudQueryPlanUserService.updateById(planUser);
                }
            }
            if (plan.getLimitAreas() != null && plan.getLimitAreas() != 0.0 && plan.getLimitAreas() < area) {
                throw new RuntimeException("\u5f53\u524d\u5206\u6790\u9762\u79ef\u4e3a\u3010" + BigDecimal.valueOf(area).toString() + "\u3011\u5e73\u65b9\u7c73\uff0c\u5df2\u8d85\u8fc7\u5355\u6b21\u5206\u6790\u4e0a\u9650\u3010" + plan.getLimitAreas() + "\u3011\u5e73\u65b9\u7c73\uff01");
            }
        }
    }

    private void cacheRes(JSONArray jsonArray, String rid) {
        for (Object o : jsonArray) {
            JSONObject jsonObject = (JSONObject)o;
            Integer status = jsonObject.getInteger("status");
            if (status == 0) continue;
            String serviceId = jsonObject.getString("serviceId");
            this.redisTemplate.boundValueOps((Object)("cloudQueryRes:" + rid + "-" + serviceId)).setIfAbsent((Object)jsonObject, 5L, TimeUnit.MINUTES);
        }
    }

    private void wktEncypt(CloudAnalaysParamDTO param) {
        if (CollectionUtil.isNotEmpty(param.getBlocks())) {
            ArrayList<String> wkts = new ArrayList<String>();
            param.getBlocks().forEach(f -> {
                try {
                    String wkt = this.bizEncryptRecordsService.wktEncrypt(f.getWkt(), EncryptType.Decrypt);
                    f.setWkt(wkt);
                    wkts.add(wkt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            param.setWkts(wkts);
        } else {
            ArrayList<String> wkts = new ArrayList<String>();
            param.getWkts().forEach(p -> {
                try {
                    wkts.add(this.bizEncryptRecordsService.wktEncrypt(p, EncryptType.Decrypt));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            param.setWkts(wkts);
        }
    }
}

