/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.znts.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.base.enums.ShapeType;
import com.geoway.ns.base.util.GeometryUtils;
import com.geoway.ns.smart.znts.dto.CloudQueryDTO;
import com.geoway.ns.smart.znts.dto.CloudQueryRecordDTO;
import com.geoway.ns.smart.znts.dto.CloudQueryRecordPojoDTO;
import com.geoway.ns.smart.znts.entity.CloudQueryRecord;
import com.geoway.ns.smart.znts.enums.BizEnum;
import com.geoway.ns.smart.znts.mapper.CloudQueryRecordMapper;
import com.geoway.ns.smart.znts.service.CloudQueryRecordService;
import com.geoway.ns.smart.znts.service.CloudQueryService;
import com.geoway.ns.smart.znts.util.Page;
import com.geoway.ns.sys.constants.Constants;
import com.geoway.ns.sys.service.ITokenService;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class CloudQueryRecordServiceImpl
extends ServiceImpl<CloudQueryRecordMapper, CloudQueryRecord>
implements CloudQueryRecordService {
    @Resource
    private CloudQueryService cloudQueryService;
    @Resource
    private ITokenService tokenService;
    @Resource
    private CloudQueryRecordMapper cloudQueryRecordMapper;
    @Resource
    JdbcTemplate jdbcTemplate;

    @Override
    public void saveRecord(CloudQueryRecord cloudQueryRecord) {
        if (StringUtils.isBlank((CharSequence)cloudQueryRecord.getId())) {
            String name = "No.";
            if (StringUtils.isBlank((CharSequence)cloudQueryRecord.getUserId())) {
                throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u7528\u6237\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u767b\u5f55!");
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.select(new String[]{"max(f_sort) as sort"}).eq((Object)"f_user_id", (Object)cloudQueryRecord.getUserId());
            CloudQueryRecord one = (CloudQueryRecord)this.getOne((Wrapper)wrapper);
            Long sort = one == null ? 1L : one.getSort() + 1L;
            cloudQueryRecord.setSort(sort);
            cloudQueryRecord.setName(name + sort);
            cloudQueryRecord.setUpdateTime(new Date());
            cloudQueryRecord.setCollect(Constants.ZERO);
            this.save(cloudQueryRecord);
        } else {
            this.updateById(cloudQueryRecord);
        }
    }

    @Override
    public IPage<CloudQueryRecord> queryPageRecord(CloudQueryRecordDTO cqd) throws Exception {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page pages = new com.baomidou.mybatisplus.extension.plugins.pagination.Page((long)cqd.getPage().intValue(), (long)cqd.getSize().intValue());
        LambdaUpdateWrapper wrapper = this.queryWrapperManage(cqd);
        wrapper.eq(CloudQueryRecord::getUserId, (Object)cqd.getUserId());
        return this.page((IPage)pages, (Wrapper)wrapper);
    }

    @Override
    public CloudQueryRecord selectByRequestId(String requestId) {
        return (CloudQueryRecord)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CloudQueryRecord::getRequestId, (Object)requestId)).one();
    }

    @Override
    public List<CloudQueryRecord> selectALLCloudQueryByRequestId(String requestId) {
        return this.cloudQueryRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CloudQueryRecord::getRequestId, (Object)requestId)).orderByDesc(CloudQueryRecord::getTag));
    }

    @Override
    public List<CloudQueryRecord> selectSJCloudQueryByRequestId(String requestId) {
        return this.cloudQueryRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CloudQueryRecord::getRequestId, (Object)requestId)).eq(CloudQueryRecord::getType, (Object)BizEnum.SJ.value)).orderByDesc(CloudQueryRecord::getTag));
    }

    @Override
    public List<CloudQueryRecord> selectGJCloudQueryByRequestId(String requestId) {
        return this.cloudQueryRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CloudQueryRecord::getRequestId, (Object)requestId)).eq(CloudQueryRecord::getType, (Object)BizEnum.GJ.value)).orderByDesc(CloudQueryRecord::getTag));
    }

    @Override
    public void updateRecordResultByCloudId(String cloudId, int status, String result) {
        ((CloudQueryRecordMapper)this.baseMapper).updateRecordResultByCloudId(cloudId, status, result);
    }

    @Override
    public void deleteRecord(String id) {
        this.removeById((Serializable)((Object)id));
    }

    @Override
    public void updateRecord(CloudQueryRecord cloudQueryRecord) {
        this.updateById(cloudQueryRecord);
    }

    private LambdaUpdateWrapper queryWrapperManage(CloudQueryRecordDTO cqd) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate(CloudQueryRecord.class);
        if (StringUtils.isNotBlank((CharSequence)cqd.getKey())) {
            wrapper.and(w -> {
                LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)w.like(CloudQueryRecord::getName, (Object)cqd.getKey())).or()).like(CloudQueryRecord::getAddress, (Object)cqd.getKey());
            });
        }
        if (cqd.getSortByTime() != null) {
            wrapper.orderBy(true, Constants.ZERO.equals(cqd.getSortByTime()), CloudQueryRecord::getUpdateTime);
        }
        if (cqd.getCollect() != null) {
            wrapper.eq(CloudQueryRecord::getCollect, (Object)cqd.getCollect());
        }
        return wrapper;
    }

    @Override
    public Page<CloudQueryRecordPojoDTO> findCloudQueryRecord(Integer pageSize, Integer currentPage) throws Exception {
        String userId = this.tokenService.queryCurrentSysUserId();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        if (ObjectUtils.isEmpty((Object)pageSize) || ObjectUtils.isEmpty((Object)currentPage)) {
            return null;
        }
        int startLocation = (currentPage - 1) * pageSize;
        ArrayList<CloudQueryRecordPojoDTO> cloudQueryRecordPojoDTOList = new ArrayList<CloudQueryRecordPojoDTO>();
        List<CloudQueryRecord> cloudQueryRecordList = this.cloudQueryRecordMapper.findCloudQueryRecord(pageSize, startLocation, userId);
        Integer totalCount = this.cloudQueryRecordMapper.findCloudQueryRecordAllCount(userId);
        if (ObjectUtils.isNotEmpty(cloudQueryRecordList)) {
            int size = cloudQueryRecordList.size();
            for (int i = 0; i < size; ++i) {
                CloudQueryRecord cloudQueryRecord = cloudQueryRecordList.get(i);
                CloudQueryRecordPojoDTO cloudQueryRecordPojoDTO = new CloudQueryRecordPojoDTO();
                cloudQueryRecordPojoDTO.setName(StringUtils.isBlank((CharSequence)cloudQueryRecord.getName()) ? "\u67d0poi\u540d\u79f0" : cloudQueryRecord.getName());
                cloudQueryRecordPojoDTO.setAddress(StringUtils.isBlank((CharSequence)cloudQueryRecord.getAddress()) ? "\u67d0poi\u5730\u5740" : cloudQueryRecord.getAddress());
                cloudQueryRecordPojoDTO.setRequestId(cloudQueryRecord.getRequestId());
                cloudQueryRecordPojoDTO.setUserId(cloudQueryRecord.getUserId());
                cloudQueryRecordPojoDTO.setQueryTime(cloudQueryRecord.getQueryTime());
                Integer type = cloudQueryRecord.getType();
                cloudQueryRecordPojoDTO.setType(type);
                String area = this.getKeepTwoDescimal(cloudQueryRecord.getArea());
                cloudQueryRecordPojoDTO.setArea(area);
                if (StringUtils.isNotBlank((CharSequence)cloudQueryRecord.getRequestId())) {
                    List<CloudQueryRecord> statusList = ((CloudQueryRecordMapper)this.baseMapper).findStatusByRequstId(cloudQueryRecord.getRequestId());
                    long endTime = System.currentTimeMillis();
                    if (ObjectUtils.isNotEmpty(statusList)) {
                        int statusSize = statusList.size();
                        int exeSize = 0;
                        int finalTimeInt = 0;
                        for (int j = 0; j < statusSize; ++j) {
                            Date date;
                            CloudQueryRecord statusRecord = statusList.get(j);
                            int statusValue = statusRecord.getStatus();
                            if (statusValue == 1) {
                                ++exeSize;
                            }
                            if (!ObjectUtils.isNotEmpty((Object)(date = statusRecord.getUpdateTime())) || finalTimeInt > 3600 || statusValue == 1) continue;
                            long startTime = date.getTime();
                            long finalTime = endTime - startTime;
                            finalTimeInt = (int)(finalTime / 1000L);
                        }
                        if (finalTimeInt >= 900) {
                            cloudQueryRecordPojoDTO.setFail("0");
                        }
                        cloudQueryRecordPojoDTO.setStatus(exeSize + "/" + statusSize);
                    }
                }
                cloudQueryRecordPojoDTOList.add(cloudQueryRecordPojoDTO);
            }
        }
        Page<CloudQueryRecordPojoDTO> page = new Page<CloudQueryRecordPojoDTO>(currentPage, pageSize, totalCount.intValue(), cloudQueryRecordPojoDTOList);
        return page;
    }

    @Override
    public Boolean deleteByRequstId(String requestId) throws Exception {
        String userId = this.tokenService.queryCurrentSysUserId();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        Boolean flag = false;
        if (StringUtils.isNotBlank((CharSequence)requestId)) {
            try {
                ((CloudQueryRecordMapper)this.baseMapper).deleteByRequstId(requestId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            flag = true;
        }
        return flag;
    }

    @Override
    public List<CloudQueryDTO> getCloudQueryTaskByRequestId(String requestId) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(CloudQueryDTO.class);
        String unionstates = "0,2";
        String sql = "SELECT * FROM(SELECT\n\tUnionNames ( f_id ) as f_id,\n\tUnionNames ( f_name ),\n\tUnionStates ( f_status ),\n\tcast(UnionNames (f_area::text)  as numeric) as mj,\n\t UnionTimes ( f_querytime ) as querytime,\n\t cast(UnionNames (f_lon|| '') as numeric) as lon,\n\t cast(UnionNames (f_lat|| '') as numeric) as lat,\n\t UnionNames (f_wkt) as wkt,\n\t f_request_id as f_requestid ,\n\t max(f_cloudrule_id) as f_cloudruleid\nFROM\n\ttb_cloud_query_record \nWHERE\n f_request_id = '" + requestId + "' GROUP BY\n\tf_request_id \n) g  WHERE g.unionstates in (" + unionstates + ") ";
        return this.jdbcTemplate.query(sql, (RowMapper)rowMapper);
    }

    private String getAreaByWkt(String wkt) {
        Double area;
        Geometry geometry = null;
        try {
            geometry = GeometryUtils.wktToGeometry((String)wkt, (Integer)GeometryUtils.GEOMETRY_SRID);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        ShapeType shapeType = GeometryUtils.getShapeTypeByWkt((String)wkt);
        if (shapeType == ShapeType.POINT) {
            area = this.cloudQueryService.calculateArea(GeometryUtils.geometryToWkt((Geometry)geometry));
            if (area != null) {
                area = area / 666.7;
            }
        } else if (shapeType == ShapeType.LINE_STRING || shapeType == ShapeType.MULTI_LINE_STRING) {
            geometry = geometry.buffer(GeometryUtils.DEFAULT_BUFFER.doubleValue());
            area = geometry.getArea() / 666.7;
        } else {
            Geometry newGeometry = null;
            try {
                newGeometry = GeometryUtils.transform((Geometry)geometry);
            }
            catch (FactoryException e) {
                throw new RuntimeException(e);
            }
            catch (TransformException e) {
                throw new RuntimeException(e);
            }
            area = newGeometry.getArea() / 666.7;
        }
        String areaStr = "";
        if (ObjectUtils.isNotEmpty((Object)area)) {
            areaStr = String.format("%.2f", area);
        }
        return areaStr;
    }

    private String getKeepTwoDescimal(Double area) {
        String areaStr = "";
        if (ObjectUtils.isNotEmpty((Object)area)) {
            areaStr = String.format("%.2f", area);
        }
        return areaStr;
    }
}

