/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.codequery.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.catalog.dto.CatalogDataNodeFieldsDTO;
import com.geoway.adf.dms.catalog.dto.query.QueryByObjectIdDTO;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogNodeDTO;
import com.geoway.adf.dms.catalog.service.impl.ResCatalogNodeServiceImpl;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.adf.dms.config.service.DictionaryService;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatasetDTO;
import com.geoway.adf.dms.datasource.dto.model.ModelDatasetDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.ReturnField;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.ns.geoserver3.dto.GLFXResult;
import com.geoway.ns.geoserver3.service.IGLFXService;
import com.geoway.ns.geoserver3.service.IIRONTOWERService;
import com.geoway.ns.geoserver3.service.IJZCXService;
import com.geoway.ns.geoserver3.service.IYZFXService;
import com.geoway.ns.smart.codequery.dto.CodequeryGraphAndFields;
import com.geoway.ns.smart.codequery.dto.CodequeryRequestData;
import com.geoway.ns.smart.codequery.dto.CodequeryResultDetail;
import com.geoway.ns.smart.codequery.dto.VersionTableMapping;
import com.geoway.ns.smart.codequery.entity.CodequeryCatalog;
import com.geoway.ns.smart.codequery.entity.CodequeryScheme;
import com.geoway.ns.smart.codequery.entity.CodequeryTask;
import com.geoway.ns.smart.codequery.mapper.CodequeryTaskMapper;
import com.geoway.ns.smart.codequery.service.CodequeryCatalogService;
import com.geoway.ns.smart.codequery.service.CodequerySchemeService;
import com.geoway.ns.smart.codequery.service.CodequeryTaskService;
import com.geoway.ns.smart.codequery.util.JsonUtils;
import com.geoway.ns.smart.zntsnew.dto.CentroidInfo;
import com.geoway.ns.smart.zntsnew.util.TaskGeoCentroidTools;
import com.geoway.ns.sys.service.ITokenService;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class CodequeryTaskServiceImpl
extends ServiceImpl<CodequeryTaskMapper, CodequeryTask>
implements CodequeryTaskService {
    @Autowired
    private ResCatalogNodeServiceImpl resCatalogService;
    @Autowired
    protected ITokenService tokenService;
    @Autowired
    private CodequerySchemeService codequerySchemeService;
    @Autowired
    private CodequeryCatalogService codequeryCatalogService;
    @Autowired
    private IGLFXService glfxService;
    @Autowired
    private TaskGeoCentroidTools taskGeoCentroidTools;
    @Autowired
    private IYZFXService yzfxService;
    @Resource
    private DictionaryService dictionaryService;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Autowired
    IJZCXService jzcxService;
    @Autowired
    IIRONTOWERService iirontowerService;
    private static final String jzcxServiceName = "jzcxServiceName";
    private static final String irontowerServiceName = "irontowerServiceName";

    @Override
    public String startAnalysis(CodequeryRequestData requestData) throws Exception {
        CodequeryScheme codequeryScheme;
        String userId = this.tokenService.queryCurrentSysUserId();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty(requestData.getBlocks()), (String)"blocks\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<CodequeryCatalog> codequeryCatalogs = null;
        String currnentSchemeId = null;
        if (StringUtils.isNotBlank((CharSequence)requestData.getSchemeId())) {
            codequeryCatalogs = this.codequeryCatalogService.queryList(requestData.getSchemeId(), null, null);
            Assert.isTrue((boolean)ObjectUtils.isNotEmpty(codequeryCatalogs), (String)"\u4f20\u5165\u7684schemeId\u6709\u8bef\uff0c\u627e\u4e0d\u5230\u8be5\u65b9\u6848\uff01");
            currnentSchemeId = requestData.getSchemeId();
        } else if (StringUtils.isNotBlank((CharSequence)requestData.getNodeId())) {
            codequeryScheme = this.codequerySchemeService.queryByResNodeId(requestData.getNodeId());
            if (codequeryScheme == null) {
                codequeryScheme = this.codequerySchemeService.queryDefault();
            }
            Assert.isTrue((boolean)ObjectUtils.isNotEmpty((Object)codequeryScheme), (String)"\u8d44\u6e90id\u6ca1\u6709\u5173\u8054\u65b9\u6848\u4e14\u6ca1\u6709\u8bbe\u7f6e\u9ed8\u8ba4\u65b9\u6848\uff01");
            codequeryCatalogs = this.codequeryCatalogService.queryList(codequeryScheme.getId(), null, null);
            Assert.isTrue((boolean)ObjectUtils.isNotEmpty(codequeryCatalogs), (String)"\u5bf9\u5e94\u7684\u65b9\u6848\u6ca1\u6709\u914d\u7f6e\u5206\u6790\u76ee\u5f55\uff01");
            currnentSchemeId = codequeryScheme.getId();
        } else {
            codequeryScheme = this.codequerySchemeService.queryDefault();
            Assert.isTrue((boolean)ObjectUtils.isNotEmpty((Object)codequeryScheme), (String)"\u8d44\u6e90id\u6ca1\u6709\u5173\u8054\u65b9\u6848\u4e14\u6ca1\u6709\u8bbe\u7f6e\u9ed8\u8ba4\u65b9\u6848\uff01");
            codequeryCatalogs = this.codequeryCatalogService.queryList(codequeryScheme.getId(), null, null);
            Assert.isTrue((boolean)ObjectUtils.isNotEmpty(codequeryCatalogs), (String)"\u5bf9\u5e94\u7684\u65b9\u6848\u6ca1\u6709\u914d\u7f6e\u5206\u6790\u76ee\u5f55\uff01");
            currnentSchemeId = codequeryScheme.getId();
        }
        HashMap requestTaskInfos = new HashMap();
        ArrayList<CodequeryResultDetail> requestTasks = new ArrayList<CodequeryResultDetail>();
        for (CodequeryCatalog codequeryCatalog : codequeryCatalogs) {
            if (codequeryCatalog.getType() == 1 || StringUtils.isEmpty((CharSequence)codequeryCatalog.getVersionTableMapping())) continue;
            if (codequeryCatalog.getType() == 2) {
                codequeryCatalog.setVersionTableMappings(VersionTableMapping.listFromJSON(codequeryCatalog.getVersionTableMapping()));
            }
            String fxType = null;
            Object geoserverRequestParams = null;
            if (codequeryCatalog.getVersionTableMappings().size() == 0) {
                System.out.println("\u6ca1\u6709\u914d\u7f6e\u6570\u636e\u4fe1\u606f\uff0c\u8df3\u8fc7\u8be5\u5206\u6790\u9879");
                continue;
            }
            if (codequeryCatalog.getVersionTableMappings().size() == 1) {
                fxType = "yzfx";
                geoserverRequestParams = this.buildYZFXQueryParams(requestData, codequeryCatalog);
            } else if (codequeryCatalog.getVersionTableMappings().size() > 1) {
                fxType = "glfx";
                geoserverRequestParams = this.buildGXFXQueryParams(requestData, codequeryCatalog);
            }
            if (geoserverRequestParams == null) continue;
            requestTaskInfos.put(codequeryCatalog.getId(), geoserverRequestParams);
            CodequeryResultDetail requestTask = new CodequeryResultDetail();
            requestTask.setFxType(fxType);
            requestTask.setCatalogId(codequeryCatalog.getId());
            requestTask.setCatalogName(codequeryCatalog.getName());
            requestTask.setUniqueTaskId(null);
            requestTask.setStatus(0);
            requestTasks.add(requestTask);
        }
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty(requestTasks), (String)"\u65b9\u6848\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        requestData.setSchemeId(currnentSchemeId);
        requestTaskInfos.put("baseInfo", JSONObject.parseObject((String)JSONObject.toJSONString((Object)requestData)));
        List<String> wkts = requestData.getBlocks().stream().map(block -> (String)block.get("WKT")).collect(Collectors.toList());
        CentroidInfo info = this.taskGeoCentroidTools.getInfo(wkts);
        CodequeryTask task = CodequeryTask.builder().id(UUID.randomUUID().toString()).userId(userId).createTime(new Date()).status(0).param(JSON.toJSONString(requestTaskInfos)).name(requestData.getName()).tag(requestData.getTag()).lat(info.getLat()).lon(info.getLon()).address(info.getXzqmc()).area(info.getArea()).build();
        for (CodequeryResultDetail requestTask : requestTasks) {
            String catalogId = requestTask.getCatalogId();
            Map geoserverRequestParams = (Map)requestTaskInfos.get(catalogId);
            if ("yzfx".equalsIgnoreCase(requestTask.getFxType())) {
                JSONObject yzfxResponse = this.yzfxService.analysis(geoserverRequestParams, "custom-datasource");
                requestTask.setUniqueTaskId(yzfxResponse.getString("UniqueTaskID"));
                requestTask.setStatus(0);
                JSONArray resultData = yzfxResponse.getJSONArray("Results");
                if (resultData == null || resultData.size() <= 0) continue;
                requestTask.setStatus(1);
                CodequeryGraphAndFields ztfxGraphAndFields = this.codequeryCatalogService.queryDisplayConfig(catalogId);
                requestTask.setGraph(ztfxGraphAndFields.getGraph());
                requestTask.setFields(ztfxGraphAndFields.getFields());
                CodequeryCatalog codequeryCatalog = this.codequeryCatalogService.queryDetail(catalogId, false);
                CodequeryResultDetail.YearResult yearResult = new CodequeryResultDetail.YearResult();
                for (VersionTableMapping curVersion : codequeryCatalog.getVersionTableMappings()) {
                    try {
                        DatasetRenderDTO renderDTO = this.resCatalogService.getNodeRender(curVersion.getNodeId());
                        yearResult.setRender(renderDTO);
                    }
                    catch (Exception ex) {
                        System.out.println(curVersion.getNodeId() + "\u8bf7\u6c42\u6e32\u67d3\u4fe1\u606f\u5f02\u5e38:" + JSONObject.toJSONString((Object)codequeryCatalog));
                        ex.printStackTrace();
                    }
                    yearResult.setResNodeId(curVersion.getNodeId());
                    yearResult.setResults(resultData);
                    requestTask.getResults().add(yearResult);
                }
                continue;
            }
            if (!"glfx".equalsIgnoreCase(requestTask.getFxType())) continue;
            List results = this.glfxService.analysis(geoserverRequestParams, "custom-datasource");
            CodequeryCatalog codequeryCatalog = this.codequeryCatalogService.queryDetail(requestTask.getCatalogId(), false);
            codequeryCatalog.setVersionTableMappings(VersionTableMapping.listFromJSON(codequeryCatalog.getVersionTableMapping()));
            requestTask.setStatus(1);
            CodequeryGraphAndFields graphAndFields = this.codequeryCatalogService.queryDisplayConfig(catalogId);
            requestTask.setGraph(graphAndFields.getGraph());
            requestTask.setFields(graphAndFields.getFields());
            CodequeryResultDetail.YearResult yearResult = new CodequeryResultDetail.YearResult();
            for (VersionTableMapping curVersion : codequeryCatalog.getVersionTableMappings()) {
                String finalYzfxServiceName = curVersion.getNodeId();
                Optional<GLFXResult> glhsResultOptinal = results.stream().filter(p -> finalYzfxServiceName.equals(p.getServiceType())).findFirst();
                if (glhsResultOptinal == null || !glhsResultOptinal.isPresent()) {
                    System.out.println("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\u7684\u5206\u6790\u7ed3\u679c");
                    continue;
                }
                GLFXResult glhsResult = glhsResultOptinal.get();
                DatasetRenderDTO renderDTO = this.resCatalogService.getNodeRender(curVersion.getNodeId());
                yearResult.setResNodeId(curVersion.getNodeId());
                yearResult.setRender(renderDTO);
                yearResult.setResults(glhsResult.getResults());
                yearResult.setYear(curVersion.getYear());
                requestTask.getResults().add(yearResult);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)requestData.getNodeId())) {
            QueryByObjectIdDTO queryByObjectIdDTO = new QueryByObjectIdDTO();
            queryByObjectIdDTO.setNodeId(requestData.getNodeId());
            queryByObjectIdDTO.setObjectId((Object)requestData.getObjectId());
            ResCatalogNodeDTO resCatalogNodeDTO = this.resCatalogService.getNodeDetail(requestData.getNodeId());
            DataQueryResult dataQueryResults = this.queryData(queryByObjectIdDTO, resCatalogNodeDTO);
            CodequeryResultDetail requestTask = new CodequeryResultDetail();
            requestTask.setFxType("identify");
            requestTask.setCatalogId("baseInfo");
            requestTask.setCatalogName("\u57fa\u672c\u4fe1\u606f");
            requestTask.setUniqueTaskId(null);
            requestTask.getResults().add(dataQueryResults);
            requestTask.setStatus(1);
            requestTasks.add(requestTask);
        }
        task.setResult(JSON.toJSONString(requestTasks));
        CodequeryTask one = (CodequeryTask)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CodequeryTask.class).orderByDesc(CodequeryTask::getSort)).last("limit 1"));
        task.setSort(one == null ? 1 : one.getSort() + 1);
        if (StringUtils.isBlank((CharSequence)task.getName())) {
            task.setName("No." + task.getSort());
        }
        this.saveOrUpdate(task);
        return task.getId();
    }

    private DataQueryResult queryData(QueryByObjectIdDTO queryByObjectIdDTO, ResCatalogNodeDTO resCatalogNodeDTO) {
        ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)resCatalogNodeDTO;
        if (resCatalogDataNodeDTO == null) {
            throw new RuntimeException("\u6570\u636e\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        DatasetDTO dataset = resCatalogDataNodeDTO.getDataset();
        Assert.notNull((Object)dataset, (String)"\u5b9e\u4f53\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        Assert.isTrue((boolean)dataset.getValid(), (String)dataset.getInvalidMessage());
        List nodeFields = resCatalogDataNodeDTO.getFields();
        ArrayList<CatalogDataNodeFieldsDTO> queryFields = new ArrayList<CatalogDataNodeFieldsDTO>();
        String fieldNames = null;
        if (nodeFields != null && nodeFields.size() > 0) {
            ArrayList<String> fieldNameList = new ArrayList<String>();
            Iterator var8 = nodeFields.iterator();
            while (true) {
                if (!var8.hasNext()) {
                    DataQueryResult result;
                    fieldNames = String.join((CharSequence)",", fieldNameList);
                    DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue((Integer)dataset.getType());
                    switch (datasetType.getValue()) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            result = this.geoDatabaseService.queryByObjectId(dataset.getId(), queryByObjectIdDTO.getObjectId(), fieldNames, Boolean.valueOf(true));
                            break;
                        }
                        case 5: {
                            result = this.geoDatabaseService.queryByObjectId(((DatumDatasetDTO)dataset).getGeoDatasetId(), queryByObjectIdDTO.getObjectId(), fieldNames, Boolean.valueOf(true));
                            break;
                        }
                        case 6: {
                            result = this.geoDatabaseService.queryByObjectId(((ModelDatasetDTO)dataset).getGeoDatasetId(), queryByObjectIdDTO.getObjectId(), fieldNames, Boolean.valueOf(true));
                            break;
                        }
                        default: {
                            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u67e5\u8be2\u7c7b\u578b\uff1a" + datasetType);
                        }
                    }
                    Assert.notNull((Object)result, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01");
                    this.queryResultFieldConvert(result, queryFields);
                    return result;
                }
                CatalogDataNodeFieldsDTO fld = (CatalogDataNodeFieldsDTO)var8.next();
                if (!Boolean.TRUE.equals(fld.getDisplay()) && !Boolean.TRUE.equals(fld.getDataName())) continue;
                queryFields.add(fld);
                fieldNameList.add(fld.getName());
            }
        }
        throw new RuntimeException("[" + resCatalogNodeDTO.getNodeName() + "]\u8282\u70b9\u5b57\u6bb5\u4e3a\u7a7a");
    }

    private void queryResultFieldConvert(DataQueryResult result, List<CatalogDataNodeFieldsDTO> nodeFields) {
        if (nodeFields != null && nodeFields.size() > 0) {
            HashMap<String, Map<String, String>> fieldValueMap = new HashMap<String, Map<String, String>>(0);
            ArrayList<ReturnField> returnFields = new ArrayList<ReturnField>();
            for (CatalogDataNodeFieldsDTO field : nodeFields) {
                ReturnField returnField;
                fieldValueMap.put(field.getName(), this.getFieldValueMap(field));
                if (!field.getDisplay().booleanValue() || (returnField = (ReturnField)ListUtil.find((List)result.getFields(), f -> f.getName().equals(field.getName()))) == null) continue;
                returnFields.add(returnField);
            }
            result.setFields(returnFields);
            for (FeatureResult featureResult : result.getData()) {
                for (CatalogDataNodeFieldsDTO field : nodeFields) {
                    if (StringUtil.isNotEmpty((String)field.getDictionaryKey()) && featureResult.getAttributes().containsKey(field.getName())) {
                        Object fieldValue = featureResult.getAttributes().get(field.getName());
                        String fieldValueString = fieldValue == null ? "NULL" : fieldValue.toString();
                        Map valueMap = (Map)fieldValueMap.get(field.getName());
                        if (valueMap.containsKey(fieldValueString)) {
                            featureResult.getAttributes().put(field.getName(), valueMap.get(fieldValueString));
                        }
                    }
                    if (Boolean.TRUE.equals(field.getDataName())) {
                        featureResult.setName(featureResult.getAttributes().get(field.getName()));
                    }
                    if (field.getDisplay().booleanValue()) continue;
                    featureResult.getAttributes().remove(field.getName());
                }
            }
        }
    }

    private Map<String, String> getFieldValueMap(CatalogDataNodeFieldsDTO field) {
        Map<String, String> keyValue = new HashMap<String, String>(0);
        if (field != null && StringUtil.isNotEmpty((String)field.getDictionaryKey())) {
            try {
                DmDictValueDTO dictValueTree = this.dictionaryService.getDictionaryTree(field.getDictionaryKey());
                if (dictValueTree != null) {
                    keyValue = this.getFieldValueMap(dictValueTree);
                }
            }
            catch (Exception var4) {
                this.log.error(field.getDictionaryKey(), (Throwable)var4);
            }
        }
        return keyValue;
    }

    private Map<String, String> getFieldValueMap(DmDictValueDTO dictValueTree) {
        HashMap<String, String> keyValue = new HashMap<String, String>(0);
        List dicValues = dictValueTree.getChildren();
        for (DmDictValueDTO dictValue : dicValues) {
            keyValue.put(dictValue.getCode(), dictValue.getName());
            if (dictValue.getChildren() == null || dictValue.getChildren().size() <= 0) continue;
            keyValue.putAll(this.getFieldValueMap(dictValue));
        }
        return keyValue;
    }

    private Map buildYZFXQueryParams(CodequeryRequestData requestData, CodequeryCatalog codequeryCatalog) {
        if (codequeryCatalog.getType() == 1 || codequeryCatalog.getVersionTableMappings() == null) {
            return null;
        }
        HashMap<String, Object> geoserverRequestParams = new HashMap<String, Object>();
        geoserverRequestParams.put("AnalysisID", requestData.getAnalysisId());
        geoserverRequestParams.put("Blocks", requestData.getBlocks());
        geoserverRequestParams.put("saverecord", true);
        geoserverRequestParams.put("SFFHTX", true);
        geoserverRequestParams.put("unCovered", false);
        geoserverRequestParams.put("async", true);
        JSONObject customAnalysisItem = new JSONObject();
        JSONArray analysisDatas = new JSONArray();
        if (codequeryCatalog.getVersionTableMappings().size() == 1) {
            analysisDatas.add((Object)this.getAnalysisDataParm(codequeryCatalog.getVersionTableMappings().get(0)));
        } else {
            for (VersionTableMapping curVersion : codequeryCatalog.getVersionTableMappings()) {
                analysisDatas.add((Object)this.getAnalysisDataParm(curVersion));
            }
        }
        customAnalysisItem.put("analysisDatas", (Object)analysisDatas);
        customAnalysisItem.put("analysisAlgorithm", (Object)codequeryCatalog.getCustomServiceClass());
        customAnalysisItem.put("analysisItemName", null);
        geoserverRequestParams.put("customAnalysisItem", customAnalysisItem);
        return geoserverRequestParams;
    }

    private Map buildGXFXQueryParams(CodequeryRequestData requestData, CodequeryCatalog codequeryCatalog) {
        if (codequeryCatalog.getType() == 1 || codequeryCatalog.getVersionTableMappings() == null) {
            return null;
        }
        HashMap<String, Object> geoserverRequestParams = new HashMap<String, Object>();
        geoserverRequestParams.put("AnalysisID", requestData.getAnalysisId());
        geoserverRequestParams.put("Blocks", requestData.getBlocks());
        geoserverRequestParams.put("saverecord", true);
        geoserverRequestParams.put("SFFHTX", true);
        geoserverRequestParams.put("unCovered", false);
        geoserverRequestParams.put("async", true);
        JSONArray customAnalysisItems = new JSONArray();
        for (VersionTableMapping curVersion : codequeryCatalog.getVersionTableMappings()) {
            JSONObject customAnalysisItem = new JSONObject();
            JSONArray analysisDatas = new JSONArray();
            analysisDatas.add((Object)this.getAnalysisDataParm(curVersion));
            customAnalysisItem.put("analysisDatas", (Object)analysisDatas);
            customAnalysisItem.put("analysisAlgorithm", null);
            customAnalysisItem.put("analysisItemName", (Object)curVersion.getNodeId());
            customAnalysisItems.add((Object)customAnalysisItem);
        }
        geoserverRequestParams.put("customAnalysisItems", customAnalysisItems);
        return geoserverRequestParams;
    }

    private JSONObject getAnalysisDataParm(VersionTableMapping curVersion) {
        ResCatalogNodeDTO resCatalogNodeDTO = this.resCatalogService.getNodeDetail(curVersion.getNodeId());
        ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)resCatalogNodeDTO;
        if (resCatalogDataNodeDTO == null) {
            throw new RuntimeException("\u6570\u636e\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        FeatureClassDTO featureDatasetDTO = (FeatureClassDTO)resCatalogDataNodeDTO.getDataset();
        String dataUrl = "geoserver:" + featureDatasetDTO.getDsKey() + "/" + featureDatasetDTO.getFullName().replace(".", "/");
        JSONObject analysisData = new JSONObject();
        analysisData.put("dataType", (Object)"default");
        analysisData.put("fields", null);
        analysisData.put("whereClause", null);
        analysisData.put("dataUrl", (Object)dataUrl);
        String shapeField = featureDatasetDTO.getShapeField();
        if (StringUtils.isNotEmpty((CharSequence)shapeField)) {
            analysisData.put("shapeField", (Object)shapeField);
        }
        return analysisData;
    }

    @Override
    public IPage<CodequeryTask> queryPage(String userId, Integer page, Integer size, String tag) {
        Page taskPage = new Page();
        taskPage.setRecords(((CodequeryTaskMapper)this.baseMapper).queryPage(userId, (page - 1) * size, size, tag));
        taskPage.setTotal((long)((CodequeryTaskMapper)this.baseMapper).queryPageCount(userId, tag).intValue());
        return taskPage;
    }

    @Override
    public CodequeryTask queryTaskInfo(String taskId) {
        CodequeryTask task = (CodequeryTask)this.getById((Serializable)((Object)taskId));
        Gson gson = new Gson();
        JSONObject param = JsonUtils.parseWithRefs(task.getParam());
        task.setParam(gson.toJson((Object)param));
        return task;
    }

    @Override
    public JSONObject querJzImages(String taskId, Integer page, Integer pageSize) {
        CodequeryTask task = (CodequeryTask)this.getById((Serializable)((Object)taskId));
        TableData tableData = null;
        try {
            tableData = this.checkTaskDataAndGetFeatureData(task);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        JSONObject param = JsonUtils.parseWithRefs(task.getParam());
        if (!param.containsKey((Object)"baseInfo") || ObjectUtils.isEmpty((Object)param.getJSONObject("baseInfo")) || !param.getJSONObject("baseInfo").containsKey((Object)"schemeId") || tableData.getData() == null) {
            System.out.println("\u4efb\u52a1\u7684\u57fa\u672c\u4fe1\u606f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            return null;
        }
        JSONObject baseInfoItemFeatureDataAttributes = tableData.getData().getJSONObject("attributes");
        if (baseInfoItemFeatureDataAttributes == null) {
            System.out.println("\u4efb\u52a1\u7684\u57fa\u672c\u4fe1\u606f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            return null;
        }
        String f_id = baseInfoItemFeatureDataAttributes.getString("f_id");
        if (f_id == null) {
            System.out.println("\u56fe\u6591id\u4e0d\u5b58\u5728\uff01");
            return null;
        }
        String tableName = tableData.getTableName();
        if (!tableName.toLowerCase().startsWith("tbtsk_task")) {
            System.out.println("\u4e0d\u662f\u4e3e\u8bc1\u56fe\u6591\uff01");
            return null;
        }
        Map queryParams = this.buildMediaQueryParams(null, null, f_id, null, null, page, pageSize);
        String schemeId = param.getJSONObject("baseInfo").getString("schemeId");
        String serviceName = this.getServiceName(schemeId, jzcxServiceName);
        return this.jzcxService.queryMedias(queryParams, serviceName);
    }

    @Override
    public JSONObject querJzImages(String taskId, String tbid, Integer page, Integer pageSize) {
        CodequeryTask task = (CodequeryTask)this.getById((Serializable)((Object)taskId));
        JSONObject param = JsonUtils.parseWithRefs(task.getParam());
        if (!param.containsKey((Object)"baseInfo") || ObjectUtils.isEmpty((Object)param.getJSONObject("baseInfo")) || !param.getJSONObject("baseInfo").containsKey((Object)"schemeId")) {
            System.out.println("\u4efb\u52a1\u7684\u57fa\u672c\u4fe1\u606f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            return null;
        }
        Map queryParams = this.buildMediaQueryParams(null, null, tbid, null, null, page, pageSize);
        String schemeId = param.getJSONObject("baseInfo").getString("schemeId");
        String serviceName = this.getServiceName(schemeId, jzcxServiceName);
        return this.jzcxService.queryMedias(queryParams, serviceName);
    }

    @Override
    public JSONObject queryJzHisImages(String taskId, Double buffer, Integer page, Integer pageSize) {
        CodequeryTask task = (CodequeryTask)this.getById((Serializable)((Object)taskId));
        TableData tableData = null;
        try {
            tableData = this.checkTaskDataAndGetFeatureData(task);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        JSONObject param = JsonUtils.parseWithRefs(task.getParam());
        if (!param.containsKey((Object)"baseInfo") || ObjectUtils.isEmpty((Object)param.getJSONObject("baseInfo")) || !param.getJSONObject("baseInfo").containsKey((Object)"schemeId")) {
            System.out.println("\u4efb\u52a1\u7684\u57fa\u672c\u4fe1\u606f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            return null;
        }
        String geometry = tableData.getWkt();
        if (geometry == null) {
            System.out.println("\u4efb\u52a1\u7684\u57fa\u672c\u4fe1\u606f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            return null;
        }
        ArrayList<Map> blocks = new ArrayList<Map>();
        HashMap<String, String> block = new HashMap<String, String>();
        block.put("DK_ID", "1");
        block.put("WKT", geometry);
        block.put("WKID", "4490");
        blocks.add(block);
        Map queryParams = this.buildMediaQueryParams(null, null, null, blocks, buffer, page, pageSize);
        String schemeId = param.getJSONObject("baseInfo").getString("schemeId");
        String serviceName = this.getServiceName(schemeId, jzcxServiceName);
        return this.jzcxService.queryPhotos(queryParams, serviceName);
    }

    @Override
    public JSONObject queryJzUsers(String taskId, Double buffer, Integer page, Integer pageSize) {
        CodequeryTask task = (CodequeryTask)this.getById((Serializable)((Object)taskId));
        TableData tableData = null;
        try {
            tableData = this.checkTaskDataAndGetFeatureData(task);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        JSONObject param = JsonUtils.parseWithRefs(task.getParam());
        if (!param.containsKey((Object)"baseInfo") || ObjectUtils.isEmpty((Object)param.getJSONObject("baseInfo")) || !param.getJSONObject("baseInfo").containsKey((Object)"schemeId")) {
            System.out.println("\u4efb\u52a1\u7684\u57fa\u672c\u4fe1\u606f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            return null;
        }
        String geometry = tableData.getWkt();
        if (geometry == null) {
            System.out.println("\u4efb\u52a1\u7684\u57fa\u672c\u4fe1\u606f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            return null;
        }
        ArrayList<Map> blocks = new ArrayList<Map>();
        HashMap<String, String> block = new HashMap<String, String>();
        block.put("DK_ID", "1");
        block.put("WKT", geometry);
        block.put("WKID", "4490");
        blocks.add(block);
        Map queryParams = this.buildMediaQueryParams(null, null, null, blocks, buffer, page, pageSize);
        String schemeId = param.getJSONObject("baseInfo").getString("schemeId");
        String serviceName = this.getServiceName(schemeId, jzcxServiceName);
        return this.jzcxService.queryUsers(queryParams, serviceName);
    }

    @Override
    public JSONObject queryJzDetail(String taskId, String catalogid, String tbid) {
        CodequeryTask task = (CodequeryTask)this.getById((Serializable)((Object)taskId));
        TableData tableData = null;
        try {
            tableData = this.checkTaskDataAndGetFeatureData(task);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        JSONObject param = JsonUtils.parseWithRefs(task.getParam());
        if (!param.containsKey((Object)"baseInfo") || ObjectUtils.isEmpty((Object)param.getJSONObject("baseInfo")) || !param.getJSONObject("baseInfo").containsKey((Object)"schemeId")) {
            System.out.println("\u4efb\u52a1\u7684\u57fa\u672c\u4fe1\u606f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            return null;
        }
        if (!param.containsKey((Object)catalogid) || ObjectUtils.isEmpty((Object)param.getJSONObject(catalogid)) || !param.getJSONObject(catalogid).containsKey((Object)"customAnalysisItem")) {
            System.out.println("\u4e0d\u5b58\u5728\u8be5\u56fe\u5c42\uff01");
            return null;
        }
        String schemeId = param.getJSONObject("baseInfo").getString("schemeId");
        JSONObject customAnalysisItem = param.getJSONObject(catalogid).getJSONObject("customAnalysisItem");
        if (ObjectUtils.isEmpty((Object)customAnalysisItem)) {
            System.out.println("\u4e0d\u5b58\u5728\u8be5\u56fe\u5c42\uff01");
            return null;
        }
        JSONArray analysisDatas = customAnalysisItem.getJSONArray("analysisDatas");
        JSONObject analysisData = analysisDatas.getJSONObject(0);
        String dataUrl = analysisData.getString("dataUrl");
        String[] dataUrls = dataUrl.split("/");
        String tablename = dataUrls[dataUrls.length - 1];
        Map queryParams = this.buildMediaQueryParams(null, tablename, tbid, null, null, null, null);
        String serviceName = this.getServiceName(schemeId, jzcxServiceName);
        return this.jzcxService.queryDetail(queryParams, serviceName);
    }

    @Override
    public JSONObject queryJzFields(String taskId, String catalogid) {
        CodequeryTask task = (CodequeryTask)this.getById((Serializable)((Object)taskId));
        JSONObject param = JsonUtils.parseWithRefs(task.getParam());
        if (!param.containsKey((Object)"baseInfo") || ObjectUtils.isEmpty((Object)param.getJSONObject("baseInfo")) || !param.getJSONObject("baseInfo").containsKey((Object)"schemeId")) {
            System.out.println("\u4efb\u52a1\u7684\u57fa\u672c\u4fe1\u606f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            return null;
        }
        if (!param.containsKey((Object)catalogid) || ObjectUtils.isEmpty((Object)param.getJSONObject(catalogid)) || !param.getJSONObject(catalogid).containsKey((Object)"customAnalysisItem")) {
            System.out.println("\u4e0d\u5b58\u5728\u8be5\u56fe\u5c42\uff01");
            return null;
        }
        String schemeId = param.getJSONObject("baseInfo").getString("schemeId");
        JSONObject customAnalysisItem = param.getJSONObject(catalogid).getJSONObject("customAnalysisItem");
        if (ObjectUtils.isEmpty((Object)customAnalysisItem)) {
            System.out.println("\u4e0d\u5b58\u5728\u8be5\u56fe\u5c42\uff01");
            return null;
        }
        JSONArray analysisDatas = customAnalysisItem.getJSONArray("analysisDatas");
        JSONObject analysisData = analysisDatas.getJSONObject(0);
        String dataUrl = analysisData.getString("dataUrl");
        String[] dataUrls = dataUrl.split("/");
        String tablename = dataUrls[dataUrls.length - 1];
        Map queryParams = this.buildMediaQueryParams(null, tablename, null, null, null, null, null);
        String serviceName = this.getServiceName(schemeId, jzcxServiceName);
        return this.jzcxService.queryFields(queryParams, serviceName);
    }

    @Override
    public JSONObject queryTowers(String taskId, Double buffer, Integer page, Integer pageSize) {
        CodequeryTask task = (CodequeryTask)this.getById((Serializable)((Object)taskId));
        TableData tableData = null;
        try {
            tableData = this.checkTaskDataAndGetFeatureData(task);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        JSONObject param = JsonUtils.parseWithRefs(task.getParam());
        if (!param.containsKey((Object)"baseInfo") || ObjectUtils.isEmpty((Object)param.getJSONObject("baseInfo")) || !param.getJSONObject("baseInfo").containsKey((Object)"schemeId")) {
            System.out.println("\u4efb\u52a1\u7684\u57fa\u672c\u4fe1\u606f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            return null;
        }
        String geometry = tableData.getWkt();
        if (geometry == null) {
            System.out.println("\u4efb\u52a1\u7684\u57fa\u672c\u4fe1\u606f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            return null;
        }
        ArrayList<Map> blocks = new ArrayList<Map>();
        HashMap<String, String> block = new HashMap<String, String>();
        block.put("DK_ID", "1");
        block.put("WKT", geometry);
        block.put("WKID", "4490");
        blocks.add(block);
        Map queryParams = this.buildMediaQueryParams(null, null, null, blocks, buffer, page, pageSize);
        String schemeId = param.getJSONObject("baseInfo").getString("schemeId");
        String serviceName = this.getServiceName(schemeId, irontowerServiceName);
        return this.iirontowerService.queryTowers(queryParams, serviceName);
    }

    @Override
    public void deleteTaskById(String id) {
        this.removeById((Serializable)((Object)id));
    }

    private TableData checkTaskDataAndGetFeatureData(CodequeryTask task) throws Exception {
        if (task == null) {
            throw new Exception("\u4efb\u52a1\u4e0d\u5b58\u5728\uff01");
        }
        JSONArray results = JSONArray.parseArray((String)task.getResult());
        if (results == null) {
            throw new Exception("\u4efb\u52a1\u7ed3\u679c\u96c6\u4e0d\u5b58\u5728\uff01");
        }
        JSONObject baseInfo = this.findObjectByCatalogId(results, "baseInfo");
        if (baseInfo == null) {
            if (StringUtils.isNotEmpty((CharSequence)task.getParam())) {
                JSONObject _param = JSONObject.parseObject((String)task.getParam());
                JSONObject _baseInfo = _param.getJSONObject("baseInfo");
                JSONArray blocks = _baseInfo.getJSONArray("blocks");
                String geometry = blocks.getJSONObject(0).getString("WKT");
                TableData tableData = new TableData();
                tableData.setWkt(geometry);
                return tableData;
            }
            throw new Exception("\u4efb\u52a1\u7684\u57fa\u672c\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        JSONArray baseInfoResults = baseInfo.getJSONArray("results");
        if (baseInfoResults == null) {
            throw new Exception("\u4efb\u52a1\u7684\u57fa\u672c\u4fe1\u606f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        JSONObject baseInfoItem = baseInfoResults.getJSONObject(0);
        if (baseInfoItem == null) {
            throw new Exception("\u4efb\u52a1\u7684\u57fa\u672c\u4fe1\u606f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        JSONArray baseInfoItemFeatures = baseInfoItem.getJSONArray("data");
        if (baseInfoItemFeatures == null) {
            throw new Exception("\u4efb\u52a1\u7684\u57fa\u672c\u4fe1\u606f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        JSONObject baseInfoItemFeatureData = baseInfoItemFeatures.getJSONObject(0);
        if (baseInfoItemFeatureData == null) {
            throw new Exception("\u4efb\u52a1\u7684\u57fa\u672c\u4fe1\u606f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        String tableName = baseInfoItem.getString("name");
        TableData tableData = new TableData();
        tableData.setData(baseInfoItemFeatureData);
        tableData.setTableName(tableName);
        tableData.setWkt(tableData.getData().getString("geometry"));
        return tableData;
    }

    private JSONObject findObjectByCatalogId(JSONArray results, String catalogId) {
        for (int i = 0; i < results.size(); ++i) {
            JSONObject jsonObject = results.getJSONObject(i);
            if (!jsonObject.containsKey((Object)"catalogId") || !catalogId.equals(jsonObject.getString("catalogId"))) continue;
            return jsonObject;
        }
        return null;
    }

    @Override
    public Map buildMediaQueryParams(String bizid, String dataTableName, String tbid, List<Map> blocks, Double bufferDistance, Integer page, Integer pageSize) {
        HashMap<String, Object> geoserverRequestParams = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)bizid) && StringUtils.isEmpty((CharSequence)dataTableName) && StringUtils.isEmpty((CharSequence)tbid) && ObjectUtils.isEmpty(blocks)) {
            return geoserverRequestParams;
        }
        if (page == null) {
            page = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        if (ObjectUtils.isNotEmpty(blocks)) {
            geoserverRequestParams.put("Blocks", blocks);
            if (bufferDistance == null) {
                bufferDistance = 0.0;
            }
            geoserverRequestParams.put("bufferDistance", bufferDistance);
        }
        if (StringUtils.isNotEmpty((CharSequence)bizid)) {
            geoserverRequestParams.put("BIZID", bizid);
        }
        if (StringUtils.isNotEmpty((CharSequence)dataTableName)) {
            geoserverRequestParams.put("DATATABLENAME", dataTableName);
        }
        if (StringUtils.isNotEmpty((CharSequence)tbid)) {
            geoserverRequestParams.put("TBID", tbid);
        }
        geoserverRequestParams.put("searchCount", true);
        geoserverRequestParams.put("SFFHTX", true);
        JSONObject filter = new JSONObject();
        filter.put("page", (Object)page);
        filter.put("rows", (Object)pageSize);
        geoserverRequestParams.put("filter", filter);
        return geoserverRequestParams;
    }

    private String getServiceName(String schemeId, String ServiceNameKey) {
        CodequeryScheme scheme = this.codequerySchemeService.queryById(schemeId);
        if (scheme == null || StringUtils.isEmpty((CharSequence)scheme.getCustomConfig())) {
            throw new RuntimeException("\u65b9\u6848\u4e0d\u5b58\u5728\u6216\u8005\u65b9\u6848\u6ca1\u6709\u914d\u7f6e\u6269\u5c55\u53c2\u6570\uff01");
        }
        JSONObject customParam = JSONObject.parseObject((String)scheme.getCustomConfig());
        if (!customParam.containsKey((Object)ServiceNameKey)) {
            throw new RuntimeException("\u65b9\u6848\u914d\u7f6e\u6269\u5c55\u53c2\u6570\u6ca1\u6709\u914d\u7f6e\u5bf9\u5e94\u670d\u52a1\uff01");
        }
        String serviceName = customParam.getString(ServiceNameKey);
        if (StringUtils.isEmpty((CharSequence)serviceName)) {
            throw new RuntimeException("\u65b9\u6848\u914d\u7f6e\u6269\u5c55\u53c2\u6570\u6ca1\u6709\u914d\u7f6e\u5bf9\u5e94\u670d\u52a1\uff01");
        }
        return serviceName;
    }

    class TableData {
        private String tableName;
        private JSONObject data;
        private String wkt;

        TableData() {
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public JSONObject getData() {
            return this.data;
        }

        public void setData(JSONObject data) {
            this.data = data;
        }

        public String getWkt() {
            return this.wkt;
        }

        public void setWkt(String wkt) {
            this.wkt = wkt;
        }
    }
}

