/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.znts.controller;

import com.geoway.ns.smart.znts.entity.CloudQueryPlan;
import com.geoway.ns.smart.znts.service.CloudQueryPlanService;
import com.geoway.ns.sys.dto.RestResult;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.sso.client.client.OrganizationClient;
import com.geoway.sso.client.client.UserClient;
import com.geoway.sso.client.rpc.RpcSysOrganization;
import com.geoway.sso.client.rpc.RpcSysUser;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e91\u67e5\u8be2\u65b9\u6848\u76f8\u5173\u63a5\u53e3"})
@RestController
@CrossOrigin
@RequestMapping(value={"/cloudQueryPlan"})
public class CloudQueryPlanController {
    @Resource
    private CloudQueryPlanService cloudQueryPlanService;
    @Autowired
    OrganizationClient organizationClient;
    @Autowired
    UserClient userClient;
    @Autowired
    private ITokenService tokenService;

    @ApiOperation(value="\u65b0\u589e\u6216\u66f4\u65b0\u65b9\u6848")
    @RequestMapping(value={"/saveOrUpdatePlan"}, method={RequestMethod.POST, RequestMethod.PUT}, produces={"application/json;charset=UTF-8"})
    public RestResult<String> saveOrUpdatePlan(CloudQueryPlan cloudQueryPlan) {
        try {
            this.cloudQueryPlanService.saveOrUpdatePlan(cloudQueryPlan);
            return RestResult.success((Object)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return RestResult.error((String)("\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u65b9\u6848\u5217\u8868")
    @RequestMapping(value={"/queryPlanList"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public RestResult<Object> queryPlanList() {
        try {
            return RestResult.success(this.cloudQueryPlanService.queryPlanList());
        }
        catch (Exception e) {
            e.printStackTrace();
            return RestResult.error((String)("\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u83b7\u53d6\u5f53\u524d\u65b9\u6848")
    @RequestMapping(value={"/queryPlanByUser"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public RestResult<Object> queryPlanByUser() {
        try {
            String userId = this.tokenService.queryCurrentSysUserId();
            return RestResult.success((Object)this.cloudQueryPlanService.getByUserId(userId));
        }
        catch (Exception e) {
            return RestResult.error((String)("\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u65b9\u6848")
    @RequestMapping(value={"/queryPlanById"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public RestResult<Object> queryPlanById(String id) {
        try {
            return RestResult.success((Object)this.cloudQueryPlanService.getById((Serializable)((Object)id)));
        }
        catch (Exception e) {
            return RestResult.error((String)("\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u5220\u9664\u65b9\u6848")
    @RequestMapping(value={"/deletePlan"}, method={RequestMethod.DELETE}, produces={"application/json;charset=UTF-8"})
    public RestResult<String> deletePlan(String id) {
        try {
            this.cloudQueryPlanService.deletePlan(id);
            return RestResult.success((Object)"\u64cd\u4f5c\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return RestResult.error((String)("\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u7f16\u8f91\u65b9\u6848\u8be6\u60c5")
    @RequestMapping(value={"/editPlanDetail"}, method={RequestMethod.PUT}, produces={"application/json;charset=UTF-8"})
    public RestResult<String> editPlanDetail(CloudQueryPlan cloudQueryPlan) {
        try {
            this.cloudQueryPlanService.editPlanDetail(cloudQueryPlan);
            return RestResult.success((Object)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return RestResult.error((String)("\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u65b9\u6848\u6dfb\u52a0\u7528\u6237")
    @RequestMapping(value={"/addPlanUser"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public RestResult<String> addPlanUser(String planId, String ids, @RequestHeader(value="Access_token") String token) {
        try {
            String msg = this.cloudQueryPlanService.addPlanUser(token, planId, ids);
            return RestResult.success((Object)msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return RestResult.error((String)("\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u65b9\u6848\u5220\u9664\u7528\u6237")
    @RequestMapping(value={"/deletePlanUser"}, method={RequestMethod.DELETE}, produces={"application/json;charset=UTF-8"})
    public RestResult<String> deletePlanUser(String ids) {
        try {
            this.cloudQueryPlanService.deletePlanUser(ids);
            return RestResult.success((Object)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return RestResult.error((String)("\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u65b9\u6848\u83b7\u53d6\u7528\u6237\u5217\u8868")
    @RequestMapping(value={"/queryPlanUserList"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public RestResult<Object> queryPlanUserList(String planId, String key, int page, int size) {
        try {
            return RestResult.success(this.cloudQueryPlanService.queryPlanUserList(planId, key, page, size));
        }
        catch (Exception e) {
            e.printStackTrace();
            return RestResult.error((String)("\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u4e91\u67e5\u8be2\u6811")
    @RequestMapping(value={"/getCloudQueryItemTree"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public RestResult<Object> getCloudQueryItemTree(String planId) {
        try {
            return RestResult.success(this.cloudQueryPlanService.getCloudQueryItemTree(planId));
        }
        catch (Exception e) {
            e.printStackTrace();
            return RestResult.error((String)("\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
        }
    }

    @ApiOperationSupport(order=5)
    @ApiOperation(value="\u4eba\u5458\u9009\u53d6\u6811 - \u7cfb\u7edf\u7528\u6237")
    @GetMapping(value={"/querySystemUserTree"})
    public RestResult<List<RpcSysOrganization>> querySystemUserTree(@RequestParam(value="pid", defaultValue="0", required=false) String pid, @RequestHeader(value="Access_token") String token) {
        try {
            return RestResult.success((Object)this.organizationClient.getOrgTree());
        }
        catch (Exception e) {
            e.printStackTrace();
            return RestResult.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u4e91\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/getDtspList"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public RestResult<List> getDtspList() {
        try {
            return RestResult.success((Object)this.cloudQueryPlanService.getDtspList());
        }
        catch (Exception e) {
            return RestResult.error((String)("\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
        }
    }

    @ApiImplicitParam(name="keyword", value="\u7528\u6237\u540d\u79f0/\u771f\u5b9e\u59d3\u540d/\u624b\u673a\u53f7")
    @ApiOperationSupport(order=5)
    @ApiOperation(value="\u4eba\u5458\u9009\u53d6\u5217\u8868 - \u7cfb\u7edf\u7528\u6237")
    @GetMapping(value={"/querySystemUserList"})
    public RestResult<List<RpcSysUser>> querySystemUserList(@RequestParam(value="keyword", required=false) String keyword, @RequestHeader(value="Access_token") String token) {
        try {
            String filterParam = "";
            if (StringUtils.isNotEmpty((CharSequence)keyword)) {
                filterParam = "Q_name_S_LK=" + keyword + ";QOR_tel_S_LK=" + keyword + ";QOR_worktel_S_LK=" + keyword + ";QOR_aname_S_LK=" + keyword + ";QOR_accout_S_LK=" + keyword;
            }
            return RestResult.success((Object)this.userClient.getUserList(filterParam));
        }
        catch (Exception e) {
            e.printStackTrace();
            return RestResult.error((String)e.getMessage());
        }
    }
}

