/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.znts.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.geoserver3.service.IDTSPService;
import com.geoway.ns.smart.znts.entity.CloudQueryPlan;
import com.geoway.ns.smart.znts.entity.CloudQueryPlanItem;
import com.geoway.ns.smart.znts.entity.CloudQueryPlanUser;
import com.geoway.ns.smart.znts.mapper.CloudQueryPlanItemMapper;
import com.geoway.ns.smart.znts.mapper.CloudQueryPlanMapper;
import com.geoway.ns.smart.znts.mapper.CloudQueryPlanUserMapper;
import com.geoway.ns.smart.znts.service.CloudQueryPlanService;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.exception.ServiceException;
import com.geoway.sso.client.client.UserClient;
import com.geoway.sso.client.rpc.RpcSysUser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class CloudQueryPlanServiceImpl
extends ServiceImpl<CloudQueryPlanMapper, CloudQueryPlan>
implements CloudQueryPlanService {
    @Resource
    CloudQueryPlanItemMapper cloudQueryPlanItemMapper;
    @Resource
    CloudQueryPlanUserMapper cloudQueryPlanUserMapper;
    @Resource
    private JdbcTemplate jdbcTemplate;
    @Resource
    private IDTSPService dtspService;
    @Autowired
    UserClient userClient;

    @Override
    public void saveOrUpdatePlan(CloudQueryPlan cloudQueryPlan) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        if (StringUtils.isNotBlank((CharSequence)cloudQueryPlan.getId())) {
            wrapper.ne(CloudQueryPlan::getId, (Object)cloudQueryPlan.getId());
        }
        ((LambdaQueryWrapper)wrapper.eq(CloudQueryPlan::getName, (Object)cloudQueryPlan.getName())).eq(CloudQueryPlan::getGroup, (Object)cloudQueryPlan.getGroup());
        CloudQueryPlan one = (CloudQueryPlan)this.getOne((Wrapper)wrapper);
        if (one != null) {
            throw new ServiceException("\u540c\u540d\u65b9\u6848\u5df2\u5b58\u5728\uff01");
        }
        if (StringUtils.isBlank((CharSequence)cloudQueryPlan.getId())) {
            this.save(cloudQueryPlan);
        } else {
            this.updateById(cloudQueryPlan);
        }
    }

    @Override
    public List<CloudQueryPlan> queryPlanList() {
        return this.list().stream().sorted(Comparator.comparing(CloudQueryPlan::getName)).collect(Collectors.toList());
    }

    @Override
    public void deletePlan(String id) {
        if (StrUtil.isBlank((CharSequence)id)) {
            throw new ServiceException("\u65b9\u6848id\u4e3a\u5fc5\u4f20\u53c2\u6570");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("f_plan_id", id);
        List users = this.cloudQueryPlanUserMapper.selectByMap(map);
        if (users != null && users.size() > 0) {
            throw new ServiceException("\u8be5\u65b9\u6848\u5b58\u5728\u7528\u6237\u914d\u7f6e\uff0c\u5220\u9664\u524d\u8bf7\u5148\u6e05\u9664\u7528\u6237\u914d\u7f6e");
        }
        this.removeById((Serializable)((Object)id));
        this.cloudQueryPlanItemMapper.deleteByMap(map);
    }

    @Override
    public void editPlanDetail(CloudQueryPlan newPlan) {
        if (StringUtils.isBlank((CharSequence)newPlan.getId())) {
            throw new ServiceException("\u65b9\u6848id\u4e3a\u5fc5\u4f20\u53c2\u6570");
        }
        String planId = newPlan.getId();
        CloudQueryPlan oldPlan = (CloudQueryPlan)this.getById((Serializable)((Object)planId));
        oldPlan.setLimitAreas(newPlan.getLimitAreas());
        oldPlan.setLimitTimes(newPlan.getLimitTimes());
        this.updateById(oldPlan);
        String hideItemIds = newPlan.getHideItemIds();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("f_plan_id", planId);
        this.cloudQueryPlanItemMapper.deleteByMap(map);
        String filterIds = "'" + hideItemIds.replaceAll(",", "','") + "'";
        String sql1 = "select * from tb_cloud_query_item where f_id in (" + filterIds + ")";
        List gjHideItemList = this.jdbcTemplate.queryForList(sql1);
        String sql2 = "select * from tb_cloud_query_item_sj where f_serviceid in (" + filterIds + ")";
        List sjHideItemList = this.jdbcTemplate.queryForList(sql2);
        gjHideItemList.forEach(item -> {
            CloudQueryPlanItem cloudQueryPlanItem = new CloudQueryPlanItem();
            cloudQueryPlanItem.setItemId(item.get("f_id").toString());
            cloudQueryPlanItem.setItemName(item.get("f_name").toString());
            cloudQueryPlanItem.setItemType(1);
            cloudQueryPlanItem.setItemGroup(item.get("f_tag").toString());
            cloudQueryPlanItem.setPlanId(planId);
            this.cloudQueryPlanItemMapper.insert(cloudQueryPlanItem);
        });
        sjHideItemList.forEach(item -> {
            CloudQueryPlanItem cloudQueryPlanItem = new CloudQueryPlanItem();
            cloudQueryPlanItem.setItemId(item.get("f_serviceid").toString());
            cloudQueryPlanItem.setItemName(item.get("f_servicealias").toString());
            cloudQueryPlanItem.setItemType(2);
            cloudQueryPlanItem.setItemGroup(item.get("f_grouptype").toString());
            cloudQueryPlanItem.setPlanId(planId);
            this.cloudQueryPlanItemMapper.insert(cloudQueryPlanItem);
        });
    }

    @Override
    public String addPlanUser(String token, String planId, String ids) {
        if (StrUtil.isBlank((CharSequence)planId)) {
            throw new ServiceException("\u65b9\u6848id\u4e3a\u5fc5\u4f20\u53c2\u6570");
        }
        if (StrUtil.isBlank((CharSequence)ids)) {
            throw new ServiceException("\u7528\u6237id\u4e3a\u5fc5\u4f20\u53c2\u6570");
        }
        String filterParam = "id_IN_" + ids;
        List queryResults = this.userClient.getUserList(filterParam);
        StringBuilder errMsg = new StringBuilder();
        for (int i = 0; i < queryResults.size(); ++i) {
            RpcSysUser userObj = (RpcSysUser)queryResults.get(i);
            SysUserDTO simpleUser = new SysUserDTO();
            simpleUser.setId(userObj.getId());
            simpleUser.setAlisname(userObj.getAname());
            simpleUser.setEmail(userObj.getEmail());
            simpleUser.setTel(userObj.getTel());
            simpleUser.setUsername(userObj.getName());
            String userId = userObj.getId();
            String rname = userObj.getAname();
            HashMap<String, String> selectMap = new HashMap<String, String>();
            selectMap.put("f_userid", userId);
            List users = this.cloudQueryPlanUserMapper.selectByMap(selectMap);
            if (users != null && users.size() != 0) {
                String oldPlanId = ((CloudQueryPlanUser)users.get(0)).getPlanId();
                CloudQueryPlan oldPlan = (CloudQueryPlan)this.getById((Serializable)((Object)oldPlanId));
                errMsg.append("\u7528\u6237").append(rname).append("\u5df2\u88ab\u5206\u914d\u81f3").append(oldPlan != null ? oldPlan.getName() : "\u672a\u77e5").append("\u65b9\u6848;");
                continue;
            }
            CloudQueryPlanUser cloudQueryPlanUser = new CloudQueryPlanUser();
            cloudQueryPlanUser.setUserId(userId);
            cloudQueryPlanUser.setRname(rname);
            cloudQueryPlanUser.setUserName(userObj.getName());
            cloudQueryPlanUser.setPhone(userObj.getTel());
            cloudQueryPlanUser.setQueryTime(0);
            cloudQueryPlanUser.setQueryArea(0.0);
            cloudQueryPlanUser.setPlanId(planId);
            this.cloudQueryPlanUserMapper.insert(cloudQueryPlanUser);
        }
        return errMsg.toString();
    }

    @Override
    public void deletePlanUser(String ids) {
        String[] idArr;
        if (StrUtil.isBlank((CharSequence)ids)) {
            throw new ServiceException("\u7528\u6237id\u4e3a\u5fc5\u4f20\u53c2\u6570");
        }
        for (String id : idArr = ids.split(",")) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("f_userid", id);
            this.cloudQueryPlanUserMapper.deleteByMap(map);
        }
    }

    @Override
    public IPage<CloudQueryPlanUser> queryPlanUserList(String planId, String key, int page, int size) {
        if (StrUtil.isBlank((CharSequence)planId)) {
            throw new ServiceException("\u65b9\u6848id\u4e3a\u5fc5\u4f20\u53c2\u6570");
        }
        if (page < 1) {
            throw new ServiceException("\u9875\u7801\u53c2\u6570\u503c\u5f02\u5e38");
        }
        if (size < 1) {
            throw new ServiceException("\u6bcf\u9875\u663e\u793a\u4e2a\u6570\u53c2\u6570\u503c\u5f02\u5e38");
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate(CloudQueryPlanUser.class);
        if (!StrUtil.isBlank((CharSequence)key)) {
            wrapper.and(w -> {
                LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)w.like(CloudQueryPlanUser::getUserName, (Object)key)).or()).like(CloudQueryPlanUser::getRname, (Object)key)).or()).like(CloudQueryPlanUser::getPhone, (Object)key);
            });
        }
        wrapper.eq(CloudQueryPlanUser::getPlanId, (Object)planId);
        Page pages = new Page((long)page, (long)size);
        return this.cloudQueryPlanUserMapper.selectPage((IPage)pages, (Wrapper)wrapper);
    }

    @Override
    public Map<String, Map<String, List<Map<String, Object>>>> getCloudQueryItemTree(String planId) {
        if (StrUtil.isBlank((CharSequence)planId)) {
            throw new ServiceException("\u65b9\u6848id\u4e3a\u5fc5\u4f20\u53c2\u6570");
        }
        CloudQueryPlan plan = (CloudQueryPlan)this.getById((Serializable)((Object)planId));
        HashMap<String, Map<String, List<Map<String, Object>>>> result = new HashMap<String, Map<String, List<Map<String, Object>>>>();
        String sjSql = "select f_servicealias as name,f_serviceid as id, f_grouptype as group,f_versions as datatime from tb_cloud_query_item_sj where f_dtspid = '" + plan.getDtspId() + "' ";
        List sjList = this.jdbcTemplate.queryForList(sjSql);
        Map<String, List<Map<String, Object>>> sjMap = this.getMapItemList(planId, sjList);
        result.put("sj", sjMap);
        String gjSql = "select f_name as name,f_id as id, f_tag as group,f_time as datatime from tb_cloud_query_item";
        List gjList = this.jdbcTemplate.queryForList(gjSql);
        Map<String, List<Map<String, Object>>> gjMap = this.getMapItemList(planId, gjList);
        result.put("gj", new TreeMap<String, List<Map<String, Object>>>(gjMap));
        return result;
    }

    @Override
    public CloudQueryPlan queryDefault() {
        return (CloudQueryPlan)this.getOne((Wrapper)Wrappers.lambdaQuery(CloudQueryPlan.class).eq(CloudQueryPlan::getName, (Object)"\u57fa\u7840\u67e5\u8be2"));
    }

    @Override
    public boolean exceededQueryTimeById(String id, Integer times) {
        CloudQueryPlan cloudQueryPlan = (CloudQueryPlan)this.getById((Serializable)((Object)id));
        if (cloudQueryPlan == null || cloudQueryPlan.getLimitTimes() == null) {
            return true;
        }
        if (times == null) {
            return false;
        }
        return cloudQueryPlan.getLimitTimes() >= times;
    }

    @Override
    public List getDtspList() {
        return this.dtspService.findList();
    }

    @Override
    public CloudQueryPlan getByUserId(String userId) {
        CloudQueryPlanUser planUser = this.cloudQueryPlanUserMapper.selectByUserId(userId);
        if (planUser == null) {
            return (CloudQueryPlan)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CloudQueryPlan::getName, (Object)"\u57fa\u7840\u67e5\u8be2")).one();
        }
        return (CloudQueryPlan)this.getById((Serializable)((Object)planUser.getPlanId()));
    }

    private Map<String, List<Map<String, Object>>> getMapItemList(String planId, List<Map<String, Object>> list) {
        HashMap<String, String> selectMap = new HashMap<String, String>();
        selectMap.put("f_plan_id", planId);
        List hideItemList = this.cloudQueryPlanItemMapper.selectByMap(selectMap);
        List hideItemids = hideItemList.stream().map(CloudQueryPlanItem::getItemId).collect(Collectors.toList());
        HashMap map = new HashMap();
        list.forEach(item -> {
            String id = item.get("id").toString();
            if (hideItemids.contains(id)) {
                item.put("hide", true);
            } else {
                item.put("hide", false);
            }
            String group = item.get("group").toString();
            List groupList = new ArrayList<Map>();
            if (map.containsKey(group)) {
                groupList = (List)map.get(group);
            }
            groupList.add(item);
            groupList = groupList.stream().sorted(Comparator.comparing(a -> a.get("name").toString())).collect(Collectors.toList());
            map.put(group, groupList);
        });
        return new TreeMap<String, List<Map<String, Object>>>(map);
    }
}

