/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.znts.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.smart.znts.entity.CloudQueryStatistics;
import com.geoway.ns.smart.znts.enums.CloudTypeEnum;
import com.geoway.ns.smart.znts.mapper.CloudQueryStatisMapper;
import com.geoway.ns.smart.znts.service.CloudQueryStatisticsService;
import com.geoway.ns.smart.znts.util.CloudQueryHttpUtil;
import com.geoway.ns.sys.constants.Constants;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CloudQueryServiceStatisticsImpl
extends ServiceImpl<CloudQueryStatisMapper, CloudQueryStatistics>
implements CloudQueryStatisticsService {
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Resource
    private CloudQueryHttpUtil cloudQueryHttpUtil;

    @Override
    public CloudQueryStatistics getLatest(String taskId, String dataId, Integer type) {
        return (CloudQueryStatistics)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CloudQueryStatistics::getTaskId, (Object)taskId)).eq(CloudQueryStatistics::getDataId, (Object)dataId)).eq(CloudQueryStatistics::getType, (Object)(type == null ? CloudTypeEnum.SJ_CLOUD.type : type))).orderByDesc(CloudQueryStatistics::getCreateTime)).last("limit 1")).one();
    }

    @Override
    public void addStatistics(CloudQueryStatistics statistics) {
        statistics.setCreateTime(new Date());
        this.save(statistics);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Object queryByDataId(String dataId, String taskId, String requestId, boolean update, Integer type, String param) {
        CloudQueryStatistics existed;
        String result;
        String key = String.format("cloudResultData:%s:%s:%s", type, taskId, dataId);
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)key);
        if (Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)key)) && !update) {
            return boundValueOperations.get();
        }
        CloudQueryStatistics cloudQueryStatistics = CloudQueryStatistics.builder().taskId(taskId).dataId(dataId).queryId(requestId).createTime(new Date()).type(type).build();
        String httpRequestId = requestId;
        if (StringUtils.isBlank((CharSequence)httpRequestId)) {
            CloudQueryStatistics one = (CloudQueryStatistics)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CloudQueryStatistics::getTaskId, (Object)taskId)).eq(CloudQueryStatistics::getDataId, (Object)dataId)).eq(CloudQueryStatistics::getType, (Object)type)).one();
            if (one == null) {
                return Constants.ZERO;
            }
            httpRequestId = one.getQueryId();
            cloudQueryStatistics.setId(one.getId());
        }
        String string = result = CloudTypeEnum.GJ_CLOUD.type.equals(type) ? httpRequestId : this.findResultById(httpRequestId);
        if (result != Constants.ONE) {
            boundValueOperations.set((Object)result, 1L, TimeUnit.DAYS);
        }
        if (StringUtils.isNotBlank((CharSequence)param)) {
            cloudQueryStatistics.setParam(param);
        }
        if ((existed = (CloudQueryStatistics)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CloudQueryStatistics::getTaskId, (Object)taskId)).eq(CloudQueryStatistics::getDataId, (Object)dataId)).one()) != null) {
            cloudQueryStatistics.setId(existed.getId());
        }
        this.saveOrUpdate(cloudQueryStatistics);
        return result;
    }

    @Override
    public String exportPdf(String requestId, String templateId, String jsonParam, String nodeId) {
        return null;
    }

    private Object findResultById(String id) {
        JSONArray results = this.cloudQueryHttpUtil.getProvincialResultByTaskId(id, null);
        if (CollectionUtils.isEmpty((Collection)results)) {
            return Constants.ZERO;
        }
        JSONObject jsonObject = results.getJSONObject(0);
        Integer status = jsonObject.getInteger("status");
        return status == null || status == 0 ? Constants.ONE : results;
    }
}

