/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.zntsnew.util;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.smart.zntsnew.dto.GraphicAnalysisDTO;
import com.geoway.ns.smart.zntsnew.util.ShpUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class GraphicAnalysisUtils {
    public static GraphicAnalysisDTO analysis(MultipartFile mfile, String type) throws Exception {
        GraphicAnalysisDTO dto = new GraphicAnalysisDTO();
        String fileName = mfile.getOriginalFilename();
        String suf = fileName.substring(fileName.lastIndexOf(".") + 1);
        String tempDir = System.getProperty("user.dir") + File.separator + "txjx-" + UUID.randomUUID();
        String tempFileName = tempDir + File.separator + fileName;
        File tempFile = new File(tempFileName);
        tempFile.mkdirs();
        try {
            mfile.transferTo(tempFile);
            Map map = new HashMap();
            if ("txt".equals(suf)) {
                map = GraphicAnalysisUtils.txtManage(ShpUtils.readTxt2WKT(tempFile));
            } else if ("zip".equals(suf)) {
                String destName = tempFileName.toLowerCase().replace(".zip", "");
                GraphicAnalysisUtils.unZipFiles(new File(tempFileName), destName);
                File dir = new File(destName);
                String shpPath = GraphicAnalysisUtils.seachFirstFileBySuffix(dir);
                String prjPath = GraphicAnalysisUtils.seachFirstPrjBySuffix(dir);
                if (StringUtils.isEmpty((CharSequence)shpPath)) {
                    throw new RuntimeException("\u538b\u7f29\u5305\u4e2d\u6ca1\u627e\u5230\u6709\u6548 .shp \u6587\u4ef6\uff01");
                }
                if (StringUtils.isEmpty((CharSequence)prjPath)) {
                    throw new RuntimeException("\u538b\u7f29\u5305\u4e2d\u6ca1\u627e\u5230\u6709\u6548 .prj \u6587\u4ef6\uff01");
                }
                map = GraphicAnalysisUtils.shpManage(ShpUtils.readValidShp2WKT2(shpPath, prjPath, null), type);
                FileUtil.del((File)dir);
            } else {
                throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u7c7b\u578b\uff01");
            }
            dto.setGeoJsonMap(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            String errMsg = e.getMessage();
            if (errMsg.indexOf("LinearRing") > 0) {
                errMsg = "\u9762\u72b6\u56fe\u5f62\u5750\u6807\u6709\u4e0d\u5c01\u95ed\u60c5\u51b5\uff0c\u8bf7\u6838\u5b9e\uff01";
            }
            throw new RuntimeException(errMsg);
        }
        finally {
            try {
                FileUtil.del((String)tempFileName);
                FileUtil.del((String)tempDir);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        dto.setFileName(fileName);
        dto.setFileType(suf);
        return dto;
    }

    private static Map txtManage(Map<String, JSONObject> map) {
        return (Map)map.get("geoJsonMap");
    }

    private static Map shpManage(Map<String, Object> map, String type) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList result = new ArrayList();
        List list = (List)map.get("properties");
        for (Map res : list) {
            HashMap hashMap = new HashMap();
            hashMap.put("wkt", res.get("wkt"));
            hashMap.put("dkbh", res.get("DIKUAI_NO"));
            hashMap.put("dkmc", res.get("PL_NAME"));
            hashMap.put("dkmj", GraphicAnalysisUtils.toDouble(res.get("DIKUAIAREA")));
            hashMap.put("dkyt", res.get("PURPOSE"));
            hashMap.put("tfh", res.get("MAP_NO"));
            hashMap.put("txsx", res.get("TXSX"));
            hashMap.put("xmq".equals(type) ? "bz" : "yuliu", res.get("BZ"));
            if (!"xmq".equals(type)) {
                hashMap.put("tblx", res.get("PATCHTYPE"));
                hashMap.put("dlbm", res.get("LANDTYPE"));
                hashMap.put("gzqpjzldb", GraphicAnalysisUtils.toInt(res.get("AVGGRADE1")));
                hashMap.put("gzhpjzldb", GraphicAnalysisUtils.toInt(res.get("AVGGRADE2")));
            }
            result.add(hashMap);
        }
        resultMap.put("geometries", result);
        resultMap.put("\u5750\u6807\u7cfb", "2000\u56fd\u5bb6\u5927\u5730\u5750\u6807\u7cfb");
        resultMap.put("\u51e0\u5ea6\u5206\u5e26", "3");
        resultMap.put("\u8ba1\u91cf\u5355\u4f4d", null);
        resultMap.put("\u6570\u636e\u4ea7\u751f\u5355\u4f4d", null);
        resultMap.put("\u8f6c\u6362\u53c2\u6570", null);
        resultMap.put("\u7cbe\u5ea6", null);
        resultMap.put("\u683c\u5f0f\u7248\u672c\u53f7", null);
        resultMap.put("\u6295\u5f71\u7c7b\u578b", null);
        resultMap.put("\u5e26\u53f7", null);
        resultMap.put("\u6570\u636e\u4ea7\u751f\u65e5\u671f", null);
        return resultMap;
    }

    private static void unZipFiles(File zipFile, String descDir) throws IOException {
        File pathFile = new File(descDir);
        if (!pathFile.exists()) {
            pathFile.mkdirs();
        }
        ZipFile zip = new ZipFile(zipFile, "gbk");
        Enumeration entries = zip.getEntries();
        while (entries.hasMoreElements()) {
            int len;
            ZipEntry entry = (ZipEntry)entries.nextElement();
            String zipEntryName = entry.getName();
            InputStream in = zip.getInputStream(entry);
            String outPath = (descDir + File.separator + zipEntryName).replaceAll("\\*", "/");
            File file = new File(outPath.substring(0, outPath.lastIndexOf(47)));
            if (!file.exists()) {
                file.mkdirs();
            }
            if (new File(outPath).isDirectory()) continue;
            System.out.println(outPath);
            FileOutputStream out = new FileOutputStream(outPath);
            byte[] buf1 = new byte[1024];
            while ((len = in.read(buf1)) > 0) {
                ((OutputStream)out).write(buf1, 0, len);
            }
            in.close();
            out.flush();
            ((OutputStream)out).close();
        }
        zip.close();
    }

    private static String seachFirstFileBySuffix(File dir) {
        File[] subFiles;
        String fileName = "";
        for (File subFile : subFiles = dir.listFiles()) {
            if (subFile.isFile()) {
                if (!subFile.getName().contains(".shp")) continue;
                fileName = subFile.getAbsolutePath();
                break;
            }
            fileName = GraphicAnalysisUtils.seachFirstFileBySuffix(subFile);
            if (StringUtils.isNotBlank((CharSequence)fileName)) break;
        }
        return fileName;
    }

    private static String seachFirstPrjBySuffix(File dir) {
        File[] subFiles;
        String fileName = "";
        for (File subFile : subFiles = dir.listFiles()) {
            if (subFile.isFile()) {
                if (!subFile.getName().contains(".prj")) continue;
                fileName = subFile.getAbsolutePath();
                break;
            }
            fileName = GraphicAnalysisUtils.seachFirstPrjBySuffix(subFile);
            if (StringUtils.isNotBlank((CharSequence)fileName)) break;
        }
        return fileName;
    }

    private static void verifyProjcs(String filePath) {
        try {
            Path path = Paths.get(filePath, new String[0]);
            List<String> list = Files.readAllLines(path);
            for (String s : list) {
                if (!s.contains("PROJC")) continue;
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u4e0a\u4f20\u5e73\u9762\u76f4\u89d2\u5750\u6807\u683c\u5f0f\u6587\u4ef6\uff01");
    }

    private static Double toDouble(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof String) {
            return Double.valueOf((String)obj);
        }
        return ((BigDecimal)obj).doubleValue();
    }

    private static Integer toInt(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Double) {
            return (Integer)obj;
        }
        if (obj instanceof String) {
            if (StringUtils.isEmpty((CharSequence)((String)obj))) {
                return 0;
            }
            return Integer.valueOf((String)obj);
        }
        return ((BigDecimal)obj).intValue();
    }
}

