/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.codequery.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogNodeDTO;
import com.geoway.adf.dms.catalog.service.impl.ResCatalogNodeServiceImpl;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.ns.geoserver3.dto.ServiceMetadataDAO;
import com.geoway.ns.geoserver3.dto.TbAnalysisYZFXDetail;
import com.geoway.ns.geoserver3.dto.TbAnalysisYZFXField;
import com.geoway.ns.geoserver3.service.IDatabaseService;
import com.geoway.ns.geoserver3.service.IYZFXService;
import com.geoway.ns.onemap.service.AppCatalogNodeURLEncodeWrapper;
import com.geoway.ns.smart.codequery.dto.CodequeryGraphAndFields;
import com.geoway.ns.smart.codequery.dto.VersionTableMapping;
import com.geoway.ns.smart.codequery.entity.CodequeryCatalog;
import com.geoway.ns.smart.codequery.entity.CodequeryField;
import com.geoway.ns.smart.codequery.entity.CodequeryGraph;
import com.geoway.ns.smart.codequery.mapper.CodequeryCatalogMapper;
import com.geoway.ns.smart.codequery.service.CodequeryCatalogService;
import com.geoway.ns.smart.codequery.service.CodequeryFieldService;
import com.geoway.ns.smart.codequery.service.CodequeryGraphService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CodequeryCatalogServiceImpl
extends ServiceImpl<CodequeryCatalogMapper, CodequeryCatalog>
implements CodequeryCatalogService {
    @Value(value="${proxy.onemap.enable:false}")
    public Boolean proxyEnable;
    @Autowired
    private IYZFXService yzfxService;
    @Autowired
    private IDatabaseService databaseService;
    @Autowired
    private CodequeryCatalogMapper codequeryCatalogMapper;
    @Autowired
    private CodequeryGraphService codequeryGraphService;
    @Autowired
    private CodequeryFieldService codequeryFieldService;
    @Autowired
    private ResCatalogNodeServiceImpl resCatalogService;
    @Autowired
    private AppCatalogNodeURLEncodeWrapper appCatalogNodeURLEncodeWrapper;
    @Value(value="${geoserver.custom-analysis:true}")
    private Boolean customAnalysis;

    @Override
    public boolean saveOrUpdateInfo(CodequeryCatalog codequeryCatalog) {
        if (StringUtils.isBlank((CharSequence)codequeryCatalog.getName())) {
            throw new RuntimeException("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)codequeryCatalog.getSchemeId())) {
            throw new RuntimeException("\u65b9\u6848ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)codequeryCatalog.getPId())) {
            codequeryCatalog.setPId("-1");
        }
        if (codequeryCatalog.getType().equals(2) && (codequeryCatalog.getVersionTableMappings() == null || codequeryCatalog.getVersionTableMappings().size() == 0)) {
            throw new RuntimeException("\u5206\u6790\u9879\u8282\u70b9\u7684\u5206\u6790\u6570\u636e\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CodequeryCatalog exist = (CodequeryCatalog)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CodequeryCatalog.class).eq(CodequeryCatalog::getName, (Object)codequeryCatalog.getName())).eq(CodequeryCatalog::getSchemeId, (Object)codequeryCatalog.getSchemeId()));
        if (StringUtils.isEmpty((CharSequence)codequeryCatalog.getId())) {
            Integer order;
            if (codequeryCatalog.getType().equals(1)) {
                if (exist != null && exist.getPId().equals(codequeryCatalog.getPId())) {
                    throw new RuntimeException("\u8be5\u5c42\u7ea7\u5b58\u5728\u540c\u540d\u8282\u70b9");
                }
            } else if (codequeryCatalog.getType().equals(2) && exist != null) {
                throw new RuntimeException("\u5b58\u5728\u540c\u540d\u5206\u6790\u9879");
            }
            order = (order = this.codequeryCatalogMapper.selectMaxOrder(codequeryCatalog.getSchemeId(), codequeryCatalog.getPId())) == null ? 1 : order + 1;
            codequeryCatalog.setOrder(order);
            if (StringUtils.isNotEmpty((CharSequence)codequeryCatalog.getServiceType()) && codequeryCatalog.getServiceType().equalsIgnoreCase("geoserver")) {
                codequeryCatalog.setVersionTableMapping(JSON.toJSONString(codequeryCatalog.getVersionTableMappings()));
            } else if (this.customAnalysis.booleanValue()) {
                codequeryCatalog.setServiceId("custom-datasource");
                codequeryCatalog.setServiceName("\u538b\u5360\u5206\u6790\u81ea\u5b9a\u4e49\u6570\u636e\u6e90");
                codequeryCatalog.setVersionTableMapping(JSON.toJSONString(codequeryCatalog.getVersionTableMappings()));
            } else if (StringUtils.isEmpty((CharSequence)codequeryCatalog.getUrl())) {
                this.addOrUpdateYZFXService(codequeryCatalog);
            }
            try {
                return this.save(codequeryCatalog);
            }
            catch (Exception e) {
                if (!(StringUtils.isNotEmpty((CharSequence)codequeryCatalog.getServiceType()) && codequeryCatalog.getServiceType().equalsIgnoreCase("geoserver") || this.customAnalysis.booleanValue() || !StringUtils.isEmpty((CharSequence)codequeryCatalog.getUrl()))) {
                    this.yzfxService.delete(codequeryCatalog.getServiceId());
                }
                throw e;
            }
        }
        if (codequeryCatalog.getType().equals(1)) {
            if (exist != null && exist.getPId().equals(codequeryCatalog.getPId()) && !exist.getId().equals(codequeryCatalog.getId())) {
                throw new RuntimeException("\u8be5\u5c42\u7ea7\u5b58\u5728\u540c\u540d\u8282\u70b9");
            }
        } else if (codequeryCatalog.getType().equals(2) && exist != null && !exist.getId().equals(codequeryCatalog.getId())) {
            throw new RuntimeException("\u5b58\u5728\u540c\u540d\u5206\u6790\u9879");
        }
        if (StringUtils.isNotEmpty((CharSequence)codequeryCatalog.getServiceType()) && codequeryCatalog.getServiceType().equalsIgnoreCase("geoserver")) {
            codequeryCatalog.setVersionTableMapping(JSON.toJSONString(codequeryCatalog.getVersionTableMappings()));
        } else if (this.customAnalysis.booleanValue()) {
            codequeryCatalog.setVersionTableMapping(JSON.toJSONString(codequeryCatalog.getVersionTableMappings()));
        } else if (StringUtils.isEmpty((CharSequence)codequeryCatalog.getUrl())) {
            this.addOrUpdateYZFXService(codequeryCatalog);
        }
        return this.updateById(codequeryCatalog);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CodequeryCatalog queryDetail(String id, boolean syncCatalogInfo) {
        CodequeryCatalog CodequeryCatalog2 = (CodequeryCatalog)this.getById((Serializable)((Object)id));
        if (CodequeryCatalog2 == null || StringUtils.isEmpty((CharSequence)CodequeryCatalog2.getVersionTableMapping())) {
            return null;
        }
        CodequeryCatalog2.setVersionTableMappings(VersionTableMapping.listFromJSON(CodequeryCatalog2.getVersionTableMapping()));
        if (StringUtils.isEmpty((CharSequence)CodequeryCatalog2.getUrl()) && !this.customAnalysis.booleanValue() && syncCatalogInfo) {
            for (VersionTableMapping versionTableMapping : CodequeryCatalog2.getVersionTableMappings()) {
                ResCatalogNodeDTO resCatalogNodeDTO = this.resCatalogService.getNodeDetail(versionTableMapping.getNodeId());
                if (resCatalogNodeDTO == null) {
                    throw new RuntimeException("\u8282\u70b9\u5df2\u88ab\u5220\u9664");
                }
                versionTableMapping.setNodeName(resCatalogNodeDTO.getNodeName());
            }
            this.addOrUpdateYZFXService(CodequeryCatalog2);
            this.updateById(CodequeryCatalog2);
        }
        return CodequeryCatalog2;
    }

    @Override
    public List<CodequeryCatalog> queryTree(String schemeId, String groupId, String name) {
        List<CodequeryCatalog> list = this.queryList(schemeId, groupId, name);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            ArrayList<CodequeryCatalog> parents = new ArrayList<CodequeryCatalog>();
            for (CodequeryCatalog catalog : list) {
                this.queryParentLoop(parents, catalog.getPId());
            }
            for (CodequeryCatalog parent : parents) {
                if (list.stream().anyMatch(p -> p.getId().equals(parent.getId()))) continue;
                list.add(parent);
            }
        }
        this.queryDisplayConfigStatus(list);
        return this.constructTree(list);
    }

    @Override
    public List<CodequeryCatalog> queryList(String schemeId, String groupId, String name) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(CodequeryCatalog.class);
        queryWrapper.eq(CodequeryCatalog::getSchemeId, (Object)schemeId);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            queryWrapper.like(CodequeryCatalog::getName, (Object)name);
        }
        if (StringUtils.isNotBlank((CharSequence)groupId)) {
            queryWrapper.eq(CodequeryCatalog::getGroupId, (Object)groupId);
        }
        queryWrapper.orderByAsc(CodequeryCatalog::getOrder);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteById(String id) {
        CodequeryCatalog catalog = (CodequeryCatalog)this.getById((Serializable)((Object)id));
        if (catalog == null) {
            throw new RuntimeException("\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        return this.deleteCatalogLoop(catalog);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteMulti(String ids) {
        String[] idsArray;
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return false;
        }
        for (String id : idsArray = ids.split(",")) {
            CodequeryCatalog catalog = (CodequeryCatalog)this.getById((Serializable)((Object)id));
            if (catalog == null) continue;
            this.deleteCatalogLoop(catalog);
        }
        return true;
    }

    @Override
    public boolean deleteMulti(List<String> ids) {
        for (String id : ids) {
            CodequeryCatalog catalog = (CodequeryCatalog)this.getById((Serializable)((Object)id));
            if (catalog == null) continue;
            this.deleteCatalogLoop(catalog);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteBySchemeId(String schemeId) {
        List list = this.list((Wrapper)Wrappers.lambdaQuery(CodequeryCatalog.class).eq(CodequeryCatalog::getSchemeId, (Object)schemeId));
        if (list != null && list.size() > 0) {
            for (CodequeryCatalog catalog : list) {
                this.deleteRelates(catalog);
            }
        }
        return this.remove((Wrapper)Wrappers.lambdaQuery(CodequeryCatalog.class).eq(CodequeryCatalog::getSchemeId, (Object)schemeId));
    }

    @Override
    public boolean displayConfig(CodequeryGraphAndFields graphAndFields) {
        if (graphAndFields == null) {
            return false;
        }
        String catalogId = graphAndFields.getCatalogId();
        if (StringUtils.isBlank((CharSequence)catalogId)) {
            throw new RuntimeException("\u5206\u6790\u9879ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (graphAndFields.getGraph() != null) {
            graphAndFields.getGraph().setCatalogId(catalogId);
            this.codequeryGraphService.deleteByCatalogId(catalogId);
            this.codequeryGraphService.saveOrUpdateInfo(graphAndFields.getGraph());
        }
        this.codequeryFieldService.deleteByCatalogId(catalogId);
        this.codequeryFieldService.batchSaveOrUpdate(catalogId, graphAndFields.getFields());
        return true;
    }

    @Override
    public CodequeryGraphAndFields queryDisplayConfig(String id) {
        CodequeryGraphAndFields graphAndFields = new CodequeryGraphAndFields();
        graphAndFields.setCatalogId(id);
        CodequeryGraph graph = this.codequeryGraphService.queryByCatalogId(id);
        graphAndFields.setGraph(graph);
        List<CodequeryField> fields = this.codequeryFieldService.queryByCatalogId(id);
        Collections.sort(fields);
        graphAndFields.setFields(fields);
        return graphAndFields;
    }

    @Override
    public boolean moveToFirst(String id) {
        return this.sort(id, 1);
    }

    @Override
    public boolean moveToLast(String id) {
        CodequeryCatalog curCatalog = (CodequeryCatalog)this.getById((Serializable)((Object)id));
        if (curCatalog == null) {
            return false;
        }
        CodequeryCatalog maxCatalog = (CodequeryCatalog)this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CodequeryCatalog.class).eq(CodequeryCatalog::getSchemeId, (Object)curCatalog.getSchemeId())).eq(CodequeryCatalog::getPId, (Object)curCatalog.getPId())).orderByDesc(CodequeryCatalog::getOrder)).get(0);
        return this.sort(id, maxCatalog.getOrder());
    }

    @Override
    public boolean moveToPre(String id) {
        CodequeryCatalog curCatalog = (CodequeryCatalog)this.getById((Serializable)((Object)id));
        if (curCatalog == null) {
            return false;
        }
        if (curCatalog.getOrder().equals(1)) {
            return true;
        }
        return this.sort(id, curCatalog.getOrder() - 1);
    }

    @Override
    public boolean moveToNext(String id) {
        CodequeryCatalog curCatalog = (CodequeryCatalog)this.getById((Serializable)((Object)id));
        if (curCatalog == null) {
            return false;
        }
        int maxOrder = this.codequeryCatalogMapper.selectMaxOrder(curCatalog.getSchemeId(), curCatalog.getPId());
        if (curCatalog.getOrder().equals(maxOrder)) {
            return true;
        }
        return this.sort(id, curCatalog.getOrder() + 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sort(String id, int order) {
        CodequeryCatalog curCatalog = (CodequeryCatalog)this.getById((Serializable)((Object)id));
        if (curCatalog == null) {
            return true;
        }
        if (curCatalog.getOrder().equals(order)) {
            return true;
        }
        List needUpdateList = null;
        if (curCatalog.getOrder() > order) {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CodequeryCatalog.class).eq(CodequeryCatalog::getSchemeId, (Object)curCatalog.getSchemeId())).eq(CodequeryCatalog::getPId, (Object)curCatalog.getPId())).ge(CodequeryCatalog::getOrder, (Object)order)).lt(CodequeryCatalog::getOrder, (Object)curCatalog.getOrder())).orderByAsc(CodequeryCatalog::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((CodequeryCatalog)needUpdateList.get(i)).setOrder(order + i + 1);
            }
        } else {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CodequeryCatalog.class).eq(CodequeryCatalog::getSchemeId, (Object)curCatalog.getSchemeId())).eq(CodequeryCatalog::getPId, (Object)curCatalog.getPId())).gt(CodequeryCatalog::getOrder, (Object)curCatalog.getOrder())).le(CodequeryCatalog::getOrder, (Object)order)).orderByAsc(CodequeryCatalog::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((CodequeryCatalog)needUpdateList.get(i)).setOrder(curCatalog.getOrder() + i);
            }
        }
        curCatalog.setOrder(order);
        needUpdateList.add(curCatalog);
        return this.updateBatchById(needUpdateList);
    }

    @Override
    public ServiceMetadataDAO metadata(String id) {
        CodequeryCatalog catalog = (CodequeryCatalog)this.getById((Serializable)((Object)id));
        if (catalog == null) {
            throw new RuntimeException("\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        if (!catalog.getType().equals(2)) {
            throw new RuntimeException("\u975e\u5206\u6790\u9879\u8282\u70b9\u4e0d\u5b58\u5728\u670d\u52a1\u5143\u6570\u636e\u4fe1\u606f");
        }
        if (StringUtils.isNotEmpty((CharSequence)catalog.getUrl()) && "geoserver".equalsIgnoreCase(catalog.getServiceType())) {
            String applicationGuid = null;
            String accessKey = null;
            if (StringUtils.isNotEmpty((CharSequence)catalog.getOtherParams())) {
                JSONObject otherParams = JSONObject.parseObject((String)catalog.getOtherParams());
                applicationGuid = otherParams.getString("ApplicationGUID");
                accessKey = otherParams.getString("accessKey");
            }
            return this.yzfxService.metadata(catalog.getUrl(), applicationGuid, accessKey);
        }
        if (this.customAnalysis.booleanValue()) {
            catalog.setVersionTableMappings(VersionTableMapping.listFromJSON(catalog.getVersionTableMapping()));
            if (catalog.getVersionTableMappings() == null || catalog.getVersionTableMappings().size() == 0) {
                throw new RuntimeException("\u672a\u5173\u8054\u5206\u6790\u6570\u636e");
            }
            VersionTableMapping curVersion = catalog.getVersionTableMappings().get(0);
            ResCatalogNodeDTO resCatalogNodeDTO = this.resCatalogService.getNodeDetail(curVersion.getNodeId());
            ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)resCatalogNodeDTO;
            if (resCatalogDataNodeDTO == null) {
                throw new RuntimeException("\u6570\u636e\u8282\u70b9\u4e0d\u5b58\u5728");
            }
            FeatureClassDTO featureDatasetDTO = (FeatureClassDTO)resCatalogDataNodeDTO.getDataset();
            String dataUrl = "geoserver:" + featureDatasetDTO.getDsKey() + "/" + featureDatasetDTO.getFullName().replace(".", "/");
            HashMap<String, Object> customAnalysisItem = new HashMap<String, Object>();
            JSONArray analysisDatas = new JSONArray();
            JSONObject analysisData = new JSONObject();
            analysisData.put("dataType", (Object)"default");
            analysisData.put("fields", null);
            analysisData.put("whereClause", null);
            analysisData.put("dataUrl", (Object)dataUrl);
            analysisDatas.add((Object)analysisData);
            customAnalysisItem.put("analysisDatas", analysisDatas);
            customAnalysisItem.put("analysisAlgorithm", null);
            customAnalysisItem.put("analysisItemName", resCatalogDataNodeDTO.getNodeId());
            return this.yzfxService.getAlgorithmFieldsMeta(customAnalysisItem);
        }
        if (StringUtils.isBlank((CharSequence)catalog.getServiceId())) {
            throw new RuntimeException("\u5206\u6790\u9879\u8282\u70b9\u5bf9\u5e94\u7684\u538b\u5360\u5206\u6790\u670d\u52a1ID\u4e3a\u7a7a");
        }
        TbAnalysisYZFXDetail yzfxDetail = this.yzfxService.findById(catalog.getServiceId());
        return this.yzfxService.metadata(yzfxDetail.getName());
    }

    @Override
    public Object findCustoms() {
        return this.yzfxService.findCustoms();
    }

    @Override
    public DatasetRenderDTO queryRender(String id, String year) {
        CodequeryCatalog curCatalog = (CodequeryCatalog)this.getById((Serializable)((Object)id));
        if (curCatalog == null) {
            return null;
        }
        curCatalog.setVersionTableMappings(VersionTableMapping.listFromJSON(curCatalog.getVersionTableMapping()));
        if (curCatalog.getVersionTableMappings() == null || curCatalog.getVersionTableMappings().size() == 0) {
            return null;
        }
        VersionTableMapping curVersion = VersionTableMapping.findByYear(curCatalog.getVersionTableMappings(), year);
        if (curVersion == null) {
            return null;
        }
        ResCatalogNodeDTO resCatalogNodeDTO = this.resCatalogService.getNodeDetail(curVersion.getNodeId());
        ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)resCatalogNodeDTO;
        DatasetRenderDTO render = resCatalogDataNodeDTO.getRender();
        if (this.proxyEnable.booleanValue()) {
            try {
                this.appCatalogNodeURLEncodeWrapper.urlManage(render);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return render;
    }

    private void queryDisplayConfigStatus(List<CodequeryCatalog> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        List<String> catlogIds = list.stream().filter(p -> p.getType().equals(2)).map(p -> p.getId()).collect(Collectors.toList());
        List<CodequeryGraph> lstGraphs = this.codequeryGraphService.queryByCatalogIds(catlogIds);
        for (CodequeryCatalog catalog : list) {
            Optional<CodequeryGraph> optionalGraph = lstGraphs.stream().filter(p -> p.getCatalogId().equals(catalog.getId())).findFirst();
            if (optionalGraph == null || !optionalGraph.isPresent()) continue;
            catalog.setDisplayConfigStatus(1);
        }
    }

    private List<CodequeryCatalog> constructTree(List<CodequeryCatalog> list) {
        ArrayList<CodequeryCatalog> roots = new ArrayList<CodequeryCatalog>();
        for (CodequeryCatalog catalog : list) {
            if (!StringUtils.isEmpty((CharSequence)catalog.getVersionTableMapping())) {
                catalog.setVersionTableMappings(VersionTableMapping.listFromJSON(catalog.getVersionTableMapping()));
            }
            List<CodequeryCatalog> children = list.stream().filter(p -> p.getPId().equals(catalog.getId())).collect(Collectors.toList());
            catalog.setChildren(children);
            if (!"-1".equals(catalog.getPId())) continue;
            roots.add(catalog);
        }
        return roots;
    }

    private void queryParentLoop(List<CodequeryCatalog> parents, String pId) {
        if ("-1".equals(pId)) {
            return;
        }
        CodequeryCatalog parent = (CodequeryCatalog)this.getById((Serializable)((Object)pId));
        if (parent == null) {
            return;
        }
        parents.add(parent);
        this.queryParentLoop(parents, parent.getPId());
    }

    private boolean deleteCatalogLoop(CodequeryCatalog catalog) {
        List children = this.list((Wrapper)Wrappers.lambdaQuery(CodequeryCatalog.class).eq(CodequeryCatalog::getPId, (Object)catalog.getId()));
        if (children != null && children.size() > 0) {
            for (CodequeryCatalog child : children) {
                this.deleteCatalogLoop(child);
            }
        }
        this.deleteRelates(catalog);
        return this.removeById((Serializable)((Object)catalog.getId()));
    }

    private boolean deleteRelates(CodequeryCatalog catalog) {
        if (catalog.getType().equals(2)) {
            this.codequeryGraphService.deleteByCatalogId(catalog.getId());
            this.codequeryFieldService.deleteByCatalogId(catalog.getId());
            if (!StringUtils.isBlank((CharSequence)catalog.getServiceId())) {
                try {
                    if (StringUtils.isEmpty((CharSequence)catalog.getUrl()) && !this.customAnalysis.booleanValue()) {
                        this.yzfxService.delete(catalog.getServiceId());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    private void addOrUpdateYZFXService(CodequeryCatalog CodequeryCatalog2) {
        if (CodequeryCatalog2.getVersionTableMappings() == null || CodequeryCatalog2.getVersionTableMappings().size() == 0) {
            CodequeryCatalog2.setVersionTableMapping(null);
            return;
        }
        int versionSize = CodequeryCatalog2.getVersionTableMappings().size();
        VersionTableMapping curTableMapping = CodequeryCatalog2.getVersionTableMappings().get(versionSize - 1);
        ResCatalogNodeDTO resCatalogNodeDTO = this.resCatalogService.getNodeDetail(curTableMapping.getNodeId());
        ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)resCatalogNodeDTO;
        if (resCatalogDataNodeDTO == null) {
            return;
        }
        FeatureClassDTO featureDatasetDTO = (FeatureClassDTO)resCatalogDataNodeDTO.getDataset();
        if (!this.databaseService.addDatabase(featureDatasetDTO.getDsKey())) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u65b0\u589e\u6570\u636e\u6e90\u5931\u8d25");
        }
        TbAnalysisYZFXDetail yzfxDetail = null;
        if (!StringUtils.isEmpty((CharSequence)CodequeryCatalog2.getServiceId())) {
            yzfxDetail = this.yzfxService.findById(CodequeryCatalog2.getServiceId());
        }
        if (yzfxDetail == null) {
            yzfxDetail = new TbAnalysisYZFXDetail();
            String serviceName = "ONEMAP_ztfx_" + CodequeryCatalog2.getName() + "_" + featureDatasetDTO.getName();
            String serviceAlias = "\u4e00\u5f20\u56fe-\u4e13\u9898\u5206\u6790-" + CodequeryCatalog2.getName() + "-" + featureDatasetDTO.getAliasName();
            serviceName = this.realYZFXServiceName(serviceName);
            yzfxDetail.setName(serviceName);
            yzfxDetail.setAlias(serviceAlias);
        }
        yzfxDetail.setGroup("\u4e00\u5f20\u56fe4.0-\u4e13\u9898\u5206\u6790");
        yzfxDetail.setStatus(Integer.valueOf(1));
        yzfxDetail.setInputParams(new ArrayList());
        yzfxDetail.setCustomServiceClass(CodequeryCatalog2.getCustomServiceClass());
        yzfxDetail.setLayer(featureDatasetDTO.getName());
        yzfxDetail.setLayerAlias(featureDatasetDTO.getAliasName());
        yzfxDetail.setDatasourceKey(featureDatasetDTO.getDsKey());
        yzfxDetail.setPrimaryField(featureDatasetDTO.getOidField());
        yzfxDetail.setShapeField(featureDatasetDTO.getShapeField());
        List<TbAnalysisYZFXField> commonFields = this.getYZFXField(featureDatasetDTO.getFields());
        ArrayList<TbAnalysisYZFXField> lstRemoveFields = new ArrayList<TbAnalysisYZFXField>();
        ArrayList<JSONObject> lstGeoserverMapping = new ArrayList<JSONObject>();
        JSONObject tempGeoserverMapping = null;
        for (int i = 0; i < versionSize - 1; ++i) {
            VersionTableMapping versionTableMapping = CodequeryCatalog2.getVersionTableMappings().get(i);
            if (StringUtils.isEmpty((CharSequence)versionTableMapping.getYear())) {
                throw new RuntimeException("\u6570\u636e\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)versionTableMapping.getDatasetId())) {
                throw new RuntimeException("\u6570\u636e\u96c6ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!Objects.equals(versionTableMapping.getDatasetType(), 2)) {
                throw new RuntimeException("\u8bf7\u9009\u62e9\u8981\u7d20\u7c7b\u8282\u70b9");
            }
            DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo((String)versionTableMapping.getDatasetId());
            if (!this.databaseService.addDatabase(datasetNameInfo.getDsKey())) {
                throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u65b0\u589e\u6570\u636e\u6e90\u5931\u8d25");
            }
            ResCatalogNodeDTO tempCatalogNodeDTO = this.resCatalogService.getNodeDetail(versionTableMapping.getNodeId());
            ResCatalogDataNodeDTO tempCatalogDataNodeDTO = (ResCatalogDataNodeDTO)tempCatalogNodeDTO;
            if (tempCatalogDataNodeDTO == null) {
                return;
            }
            FeatureClassDTO tempFeatureDatasetDTO = (FeatureClassDTO)tempCatalogDataNodeDTO.getDataset();
            if (!this.databaseService.addDatabase(tempFeatureDatasetDTO.getDsKey())) {
                throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u65b0\u589e\u6570\u636e\u6e90\u5931\u8d25");
            }
            tempGeoserverMapping = new JSONObject();
            tempGeoserverMapping.put("datasourceKey", (Object)tempFeatureDatasetDTO.getDsKey());
            tempGeoserverMapping.put("version", (Object)versionTableMapping.getYear());
            tempGeoserverMapping.put("tableName", (Object)tempFeatureDatasetDTO.getName());
            lstGeoserverMapping.add(tempGeoserverMapping);
            for (TbAnalysisYZFXField yzfxField : commonFields) {
                Optional<FieldDTO> optionalFieldDTO = tempFeatureDatasetDTO.getFields().stream().filter(p -> p.getName().equalsIgnoreCase(yzfxField.getName())).findFirst();
                if (optionalFieldDTO != null && optionalFieldDTO.isPresent()) continue;
                lstRemoveFields.add(yzfxField);
            }
            commonFields.removeAll(lstRemoveFields);
            lstRemoveFields.clear();
        }
        tempGeoserverMapping = new JSONObject();
        tempGeoserverMapping.put("datasourceKey", (Object)featureDatasetDTO.getDsKey());
        tempGeoserverMapping.put("version", (Object)curTableMapping.getYear());
        tempGeoserverMapping.put("tableName", (Object)featureDatasetDTO.getName());
        lstGeoserverMapping.add(tempGeoserverMapping);
        yzfxDetail.setFields(commonFields);
        yzfxDetail.setVersionTableMapping(JSON.toJSONString(lstGeoserverMapping));
        yzfxDetail = this.yzfxService.save(yzfxDetail);
        CodequeryCatalog2.setVersionTableMapping(JSON.toJSONString(CodequeryCatalog2.getVersionTableMappings()));
        CodequeryCatalog2.setServiceId(yzfxDetail.getId());
        CodequeryCatalog2.setServiceName(yzfxDetail.getName());
    }

    private String realYZFXServiceName(String yzfxServiceName) {
        String realServiceName = yzfxServiceName;
        if (this.yzfxService.checkIsExist(yzfxServiceName)) {
            for (int i = 1; i < Integer.MAX_VALUE && this.yzfxService.checkIsExist(realServiceName = yzfxServiceName + "_" + i); ++i) {
            }
        }
        return realServiceName;
    }

    private List<TbAnalysisYZFXField> getYZFXField(List<FieldDTO> fields) {
        ArrayList<TbAnalysisYZFXField> fieldList = new ArrayList<TbAnalysisYZFXField>();
        TbAnalysisYZFXField tbAnalysisYZFXField = null;
        int order = 1;
        for (FieldDTO field : fields) {
            tbAnalysisYZFXField = new TbAnalysisYZFXField();
            tbAnalysisYZFXField.setName(field.getName());
            tbAnalysisYZFXField.setAlias(field.getAliasName());
            tbAnalysisYZFXField.setReturnName(field.getName().toUpperCase());
            tbAnalysisYZFXField.setType(this.covertType(field.getFieldType()));
            tbAnalysisYZFXField.setOrder(Integer.valueOf(order++));
            fieldList.add(tbAnalysisYZFXField);
        }
        return fieldList;
    }

    private String covertType(int value) {
        FieldType fieldType = FieldType.getByValue((Integer)value);
        switch (fieldType) {
            case Int: {
                return "int4";
            }
            case OID: {
                return "oid";
            }
            case Blob: {
                return "blob";
            }
            case Byte: {
                return "byte";
            }
            case Long: {
                return "long";
            }
            case Text: 
            case String: {
                return "string";
            }
            case Float: {
                return "float";
            }
            case Shape: {
                return "geometry";
            }
            case Short: {
                return "short";
            }
            case Double: {
                return "double";
            }
            case Boolean: {
                return "boolean";
            }
            case Decimal: {
                return "decimal";
            }
            default: {
                return "unknown";
            }
            case DateTime: 
        }
        return "datetime";
    }
}

