/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.update.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.ns.geoserver3.dto.ServiceMetadataDAO;
import com.geoway.ns.geoserver3.dto.TbAnalysisBaseInfo;
import com.geoway.ns.geoserver3.dto.TbAnalysisTask;
import com.geoway.ns.geoserver3.dto.TbAnalysisTaskLog;
import com.geoway.ns.geoserver3.dto.TbAnalysisTaskParam;
import com.geoway.ns.geoserver3.dto.TbAnalysisUpdateField;
import com.geoway.ns.geoserver3.dto.UpdateToolDTO;
import com.geoway.ns.geoserver3.service.IGeoserver3TaskService;
import com.geoway.ns.geoserver3.service.IGeoserver3UpdateToolService;
import com.geoway.ns.geoserver3.service.ITbAnalysisBaseInfoService;
import com.geoway.ns.smart.update.dto.UpdateRecordDTO;
import com.geoway.ns.smart.update.dto.UpdateRecordFilterDTO;
import com.geoway.ns.smart.update.dto.UpdateStatResultDTO;
import com.geoway.ns.smart.update.entity.TbUpdateBusiness;
import com.geoway.ns.smart.update.entity.TbUpdateBusinessItem;
import com.geoway.ns.smart.update.entity.TbUpdateRecord;
import com.geoway.ns.smart.update.service.SmartUpdateService;
import com.geoway.ns.smart.update.service.TbUpdateBusinessItemService;
import com.geoway.ns.smart.update.service.TbUpdateBusinessService;
import com.geoway.ns.smart.update.service.impl.TbUpdateRecordServiceImpl;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
public class SmartUpdateServiceImpl
implements SmartUpdateService,
ApplicationRunner {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final DecimalFormat df = new DecimalFormat("0.00");
    @Value(value="${smart.updatetool.syncEnable:false}")
    private boolean syncEnable = false;
    @Value(value="${smart.updatetool.syncInterval:1800}")
    private long interval = 1800L;
    @Autowired
    private TbUpdateBusinessService tbUpdateBusinessService;
    @Autowired
    private TbUpdateBusinessItemService tbUpdateBusinessItemService;
    @Autowired
    private TbUpdateRecordServiceImpl tbUpdateToolRecordService;
    @Autowired
    private IGeoserver3UpdateToolService geoserver3UpdateToolService;
    @Autowired
    private IGeoserver3TaskService geoserver3TaskService;
    @Autowired
    private ITbAnalysisBaseInfoService tbAnalysisBaseInfoService;

    @Override
    public List<TbUpdateBusiness> queryBusiness() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(TbUpdateBusiness.class);
        wrapper.orderByAsc(TbUpdateBusiness::getOrder);
        List listBusiness = this.tbUpdateBusinessService.list((Wrapper)wrapper);
        return listBusiness;
    }

    @Override
    public UpdateStatResultDTO stat(UpdateRecordFilterDTO filter) {
        long businessCount = this.tbUpdateBusinessService.count();
        long updateServiceCount = this.tbUpdateBusinessItemService.count();
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(TbUpdateRecord.class);
        if (filter != null && !StringUtils.isEmpty((CharSequence)filter.getBusinessId())) {
            wrapper.eq(TbUpdateRecord::getBusinessId, (Object)filter.getBusinessId());
        }
        if (filter != null && filter.getStartTime() != null) {
            wrapper.ge(TbUpdateRecord::getUpdateTime, (Object)filter.getStartTime());
        }
        if (filter != null && filter.getEndTime() != null) {
            wrapper.le(TbUpdateRecord::getUpdateTime, (Object)filter.getEndTime());
        }
        List records = this.tbUpdateToolRecordService.list((Wrapper)wrapper);
        AtomicLong sumUpdateRows = new AtomicLong();
        records.stream().filter(p -> p.getUpdateRows() != null).forEach(p -> sumUpdateRows.addAndGet(p.getUpdateRows().intValue()));
        UpdateStatResultDTO statResultDTO = new UpdateStatResultDTO();
        statResultDTO.setAllBusinessCount(businessCount);
        statResultDTO.setUpdateCount(records.stream().count());
        statResultDTO.setUpdateRowCount(sumUpdateRows.get());
        statResultDTO.setUpdateServiceCount(updateServiceCount);
        return statResultDTO;
    }

    @Override
    public IPage<UpdateRecordDTO> pageUpdateRecord(UpdateRecordFilterDTO filter) {
        List listBusiness = this.tbUpdateBusinessService.list();
        List listBusinessItem = this.tbUpdateBusinessItemService.list();
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(TbUpdateRecord.class);
        if (filter != null && !StringUtils.isEmpty((CharSequence)filter.getBusinessId())) {
            wrapper.eq(TbUpdateRecord::getBusinessId, (Object)filter.getBusinessId());
        }
        if (filter != null && filter.getStartTime() != null) {
            wrapper.ge(TbUpdateRecord::getUpdateTime, (Object)filter.getStartTime());
        }
        if (filter != null && filter.getEndTime() != null) {
            wrapper.le(TbUpdateRecord::getUpdateTime, (Object)filter.getEndTime());
        }
        wrapper.orderByDesc(TbUpdateRecord::getUpdateTime);
        Page page = new Page((long)filter.getPage(), (long)filter.getSize());
        IPage pageRecords = this.tbUpdateToolRecordService.page((IPage)page, (Wrapper)wrapper);
        ArrayList<UpdateRecordDTO> records = new ArrayList<UpdateRecordDTO>();
        UpdateRecordDTO recordDTO = null;
        Optional<TbUpdateBusiness> optinalBusiness = null;
        Optional<TbUpdateBusinessItem> optinalBusinessItem = null;
        for (TbUpdateRecord record : pageRecords.getRecords()) {
            recordDTO = new UpdateRecordDTO();
            BeanUtils.copyProperties((Object)record, (Object)recordDTO);
            optinalBusiness = listBusiness.stream().filter(p -> Objects.equals(p.getId(), record.getBusinessId())).findFirst();
            if (optinalBusiness != null && optinalBusiness.isPresent()) {
                recordDTO.setBusinessName(optinalBusiness.get().getBusinessName());
                recordDTO.setAppName(optinalBusiness.get().getAppName());
            }
            if ((optinalBusinessItem = listBusinessItem.stream().filter(p -> Objects.equals(p.getUpdateServiceId(), record.getUpdateServiceId())).findFirst()) != null && optinalBusinessItem.isPresent()) {
                recordDTO.setBz(optinalBusinessItem.get().getBz());
            }
            records.add(recordDTO);
        }
        Page newPage = new Page();
        newPage.setTotal(pageRecords.getTotal());
        newPage.setPages(pageRecords.getPages());
        newPage.setSize(pageRecords.getSize());
        newPage.setCurrent(pageRecords.getCurrent());
        newPage.setRecords(records);
        return newPage;
    }

    @Override
    public UpdateToolDTO.UpdateRecordDetail queryUpdateRecordDetail(String uniqueTaskId) throws Exception {
        TbUpdateRecord tbUpdateRecord = (TbUpdateRecord)this.tbUpdateToolRecordService.getById((Serializable)((Object)uniqueTaskId));
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(TbUpdateBusinessItem.class);
        wrapper.eq(TbUpdateBusinessItem::getBusinessId, (Object)tbUpdateRecord.getBusinessId());
        wrapper.eq(TbUpdateBusinessItem::getUpdateServiceId, (Object)tbUpdateRecord.getUpdateServiceId());
        TbUpdateBusinessItem businessItem = (TbUpdateBusinessItem)this.tbUpdateBusinessItemService.getOne((Wrapper)wrapper);
        UpdateToolDTO.UpdateRecordDetail updateRecordDetail = this.geoserver3UpdateToolService.contentDetail(uniqueTaskId, businessItem.getContentField());
        this.queryGeometryField(updateRecordDetail);
        return updateRecordDetail;
    }

    @Override
    public TbAnalysisTask queryUpdateTask(String uniqueTaskId) throws Exception {
        return this.geoserver3TaskService.findTaskById(uniqueTaskId);
    }

    @Override
    public TbAnalysisTaskParam queryUpdateTaskParam(String uniqueTaskId) throws Exception {
        return this.geoserver3TaskService.findTaskParam(uniqueTaskId);
    }

    @Override
    public List<TbAnalysisTaskLog> queryUpdateTaskLog(String uniqueTaskId) throws Exception {
        return this.geoserver3TaskService.findTaskLog(uniqueTaskId);
    }

    @Override
    public ServiceMetadataDAO queryUpdateServiceMetadata(String updateServiceId) throws Exception {
        TbAnalysisBaseInfo baseInfo = this.tbAnalysisBaseInfoService.findById(updateServiceId);
        if (baseInfo == null) {
            throw new RuntimeException("\u66f4\u65b0\u670d\u52a1\u4e0d\u5b58\u5728\uff01");
        }
        return this.tbAnalysisBaseInfoService.metadata(baseInfo.getType(), baseInfo.getName());
    }

    @Override
    public void syncData() {
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            List businessItems = this.tbUpdateBusinessItemService.list();
            if (businessItems == null || businessItems.size() == 0) {
                return;
            }
            this.syncUpdateContent(businessItems);
            stopWatch.stop();
            double cost = stopWatch.getTotalTimeSeconds();
            System.out.println(String.format("%s : \u540c\u6b65\u8054\u52a8\u66f4\u65b0\u8bb0\u5f55\u8017\u65f6\uff1a\u3010%s\u3011\u79d2\uff01", this.dateFormat.format(new Date()), this.df.format(cost)));
        }
        catch (Throwable e) {
            System.out.println("\u540c\u6b65\u8054\u52a8\u66f4\u65b0\u8bb0\u5f55\u5f02\u5e38\uff1a");
            e.printStackTrace();
        }
    }

    private void syncUpdateContent(List<TbUpdateBusinessItem> businessItems) throws Exception {
        for (TbUpdateBusinessItem businessItem : businessItems) {
            this.syncUpdateContentSingle(businessItem);
        }
    }

    private void syncUpdateContentSingle(TbUpdateBusinessItem businessItem) throws Exception {
        if (StringUtils.isEmpty((CharSequence)businessItem.getUpdateServiceId())) {
            return;
        }
        List lstUpdateRecord = this.geoserver3UpdateToolService.recordList(businessItem.getUpdateServiceId());
        if (lstUpdateRecord == null || lstUpdateRecord.size() == 0) {
            return;
        }
        ArrayList<TbUpdateRecord> tbUpdateRecords = new ArrayList<TbUpdateRecord>();
        TbUpdateRecord tbUpdateRecord = null;
        for (UpdateToolDTO.UpdateRecordSimple updateRecordSimple : lstUpdateRecord) {
            tbUpdateRecord = new TbUpdateRecord();
            BeanUtils.copyProperties((Object)updateRecordSimple, (Object)tbUpdateRecord);
            tbUpdateRecord.setUpdateRows(updateRecordSimple.getUpdateRowCount());
            tbUpdateRecord.setBusinessId(businessItem.getBusinessId());
            tbUpdateRecords.add(tbUpdateRecord);
        }
        this.tbUpdateToolRecordService.saveOrUpdateBatch(tbUpdateRecords);
    }

    private void queryGeometryField(UpdateToolDTO.UpdateRecordDetail updateRecordDetail) {
        if (updateRecordDetail == null || updateRecordDetail.getUpdateServiceInfo() == null || updateRecordDetail.getUpdateServiceInfo().getFields() == null) {
            return;
        }
        TbAnalysisUpdateField geometryField = null;
        for (TbAnalysisUpdateField updateField : updateRecordDetail.getUpdateServiceInfo().getFields()) {
            if (!"geometry".equalsIgnoreCase(updateField.getGdbFieldType()) && !"polygon".equalsIgnoreCase(updateField.getGdbFieldType()) && !"line".equalsIgnoreCase(updateField.getGdbFieldType()) && !"point".equalsIgnoreCase(updateField.getGdbFieldType())) continue;
            geometryField = updateField;
            break;
        }
        updateRecordDetail.setGeometryField(geometryField);
    }

    public void run(ApplicationArguments args) throws Exception {
        if (this.syncEnable) {
            try {
                new Thread(() -> {
                    while (true) {
                        try {
                            while (true) {
                                this.syncData();
                                TimeUnit.SECONDS.sleep(this.interval);
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }, "updatetool-sync-thread").start();
            }
            catch (Throwable ee) {
                ee.printStackTrace();
            }
        }
    }
}

