/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.znts.util;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.geoserver3.service.IGeoserver3ConfigService;
import com.geoway.ns.smart.znts.service.ICloudQueryConfigService;
import com.geoway.ns.smart.znts.util.JwtUtils;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component
public class CloudQueryHttpUtil {
    @Resource
    private ICloudQueryConfigService cloudQueryConfig;
    @Autowired
    private IGeoserver3ConfigService geoserver3ConfigService;

    @PostConstruct
    private void initConfig() {
    }

    private Map<String, String> buildHeaders() {
        String token = JwtUtils.createJWT(UUID.randomUUID().toString(), this.cloudQueryConfig.getAppKey(), this.cloudQueryConfig.getAppSecret(), System.currentTimeMillis());
        return MapUtil.builder((Object)"appkey", (Object)this.cloudQueryConfig.getAppKey()).put((Object)"nodeid", (Object)this.cloudQueryConfig.getNodeId()).put((Object)"token", (Object)token).build();
    }

    public JSONObject sendCloudQuery(String userId, String param, String requestId, String name, String tag) {
        Assert.notBlank((CharSequence)userId, (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)param, (String)"\u53c2\u6570param\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (this.cloudQueryConfig == null) {
            this.initConfig();
        }
        String token = JwtUtils.createJWT(UUID.randomUUID().toString(), this.cloudQueryConfig.getAppKey(), this.cloudQueryConfig.getAppSecret(), System.currentTimeMillis());
        String url = this.cloudQueryConfig.getURL() + "/cloudQuery/v3/add";
        Map requestParams = MapUtil.builder((Object)"userId", (Object)userId).put((Object)"param", (Object)param).put((Object)"tag", (Object)tag).put((Object)"analyzeType", (Object)"0").build();
        if (StringUtils.isNotBlank((CharSequence)requestId)) {
            requestParams.put("requestId", requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            requestParams.put("name", name);
        }
        return this.getResponseData(HttpMethod.POST, url, requestParams, JSONObject.class);
    }

    public String getCloudQueryResultUrl(String requestId, String metaJson, String detailResultJson) {
        String url = this.cloudQueryConfig.getURL() + "/cloudQuery/result/addResult";
        Map requestParams = MapUtil.builder((Object)"id", (Object)requestId).put((Object)"metaJson", (Object)metaJson).put((Object)"detailResultJson", (Object)detailResultJson).build();
        return this.getResponseData(HttpMethod.POST, url, requestParams, String.class);
    }

    public String getCloudQueryDbUrl(String id) {
        String url = this.cloudQueryConfig.getURL() + "/cloudQuery/v3/getRecordById?id=" + id;
        JSONObject jo = this.getResponseData(HttpMethod.GET, url, null, JSONObject.class);
        return jo.getString("result");
    }

    public JSONObject getCloudQueryResultDetail(String queryId) {
        String url = this.cloudQueryConfig.getURL() + "/cloudQuery/v3/getDetailRecordById";
        Map requestParams = MapUtil.builder((Object)"id", (Object)queryId).build();
        return this.getResponseData(HttpMethod.GET, url, requestParams, JSONObject.class);
    }

    public JSONArray getRecordStateByRequestIds(List<String> listRequestIds) {
        String url = this.cloudQueryConfig.getURL() + "/cloudQuery/v3/getRecordStateByRequestIds";
        Map requestParams = MapUtil.builder((Object)"requestIds", (Object)String.join((CharSequence)",", listRequestIds)).build();
        return this.getResponseData(HttpMethod.GET, url, requestParams, JSONArray.class);
    }

    private JSONObject getSJResponseData(String url, String body) {
        return this.getSJResponseData(url, body, "data", JSONObject.class);
    }

    private <T> T getSJResponseData(String url, String body, String resultKey, Class<T> clazz) {
        String respBody = HttpUtil.createPost((String)url).body(body).execute().body();
        if (StrUtil.isBlank((CharSequence)respBody)) {
            throw new RuntimeException("\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25");
        }
        JSONObject object = JSON.parseObject((String)respBody);
        return (T)object.getObject(resultKey, clazz);
    }

    private <T> T getResponseData(HttpMethod httpMethod, String url, Map<String, Object> requestParams, Class<T> clazz) {
        return this.getResponseData(httpMethod, url, requestParams, "data", clazz);
    }

    private <T> T getResponseData(HttpMethod httpMethod, String url, Map<String, Object> requestParams, String resultKey, Class<T> clazz) {
        String respBody;
        Method method = Method.GET;
        if (httpMethod == HttpMethod.POST) {
            method = Method.POST;
        }
        if (StrUtil.isBlank((CharSequence)(respBody = ((HttpRequest)HttpUtil.createRequest((Method)method, (String)url).addHeaders(this.buildHeaders())).form(requestParams).execute().body()))) {
            throw new RuntimeException("\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25");
        }
        JSONObject object = JSON.parseObject((String)respBody);
        return (T)object.getObject(resultKey, clazz);
    }

    public String sendProvincialCloudQuery(JSONObject params) {
        if (this.cloudQueryConfig == null) {
            this.initConfig();
        }
        String url = String.format("%s/rest/dtsp/%s/extension", this.cloudQueryConfig.getProvincialUrl(), this.cloudQueryConfig.getProvincialServiceName());
        return this.getSJResponseData(url, JSONObject.toJSONString((Object)params), "UniqueTaskID", String.class);
    }

    public String sendProvincialCloudRule(JSONObject params, String service) {
        if (this.cloudQueryConfig == null) {
            this.initConfig();
        }
        String url = String.format("%s/rest/dtsp/%s/rule", this.cloudQueryConfig.getProvincialUrl(), service);
        return this.getSJResponseData(url, JSONObject.toJSONString((Object)params), "UniqueTaskID", String.class);
    }

    public String sendProvincialCloudRule(JSONObject params) {
        return this.sendProvincialCloudRule(params, this.cloudQueryConfig.getProvincialServiceName());
    }

    public JSONArray getProvincialCloudQueryConfig() {
        if (this.cloudQueryConfig == null) {
            this.initConfig();
        }
        String url = this.cloudQueryConfig.getProvincialUrl() + "/rest/dtsp/findByName";
        Map params = MapUtil.builder((Object)"name", (Object)this.cloudQueryConfig.getProvincialServiceName()).build();
        return this.getResponseData(HttpMethod.GET, url, params, "Results", JSONArray.class);
    }

    public JSONArray getProvincialCloudRuleConfig() {
        if (this.cloudQueryConfig == null) {
            this.initConfig();
        }
        String url = this.cloudQueryConfig.getProvincialUrl() + "/rest/rule/getRules";
        Map params = MapUtil.builder((Object)"serviceName", (Object)this.cloudQueryConfig.getProvincialServiceName()).build();
        return this.getResponseData(HttpMethod.GET, url, params, "Results", JSONArray.class);
    }

    public JSONArray getProvincialResultByTaskId(String taskId, String serviceIds) {
        if (this.cloudQueryConfig == null) {
            this.initConfig();
        }
        Map params = MapUtil.builder((Object)"id", (Object)taskId).put((Object)"serviceId", (Object)serviceIds).build();
        String url = this.cloudQueryConfig.getProvincialUrl() + "/rest/dtsp/result/findResultByTaskId";
        return this.getResponseData(HttpMethod.GET, url, params, "Results", JSONArray.class);
    }

    public JSONObject getProvincialRuleResultByTaskId(String taskId) {
        if (this.cloudQueryConfig == null) {
            this.initConfig();
        }
        Map params = MapUtil.builder((Object)"id", (Object)taskId).build();
        String url = this.cloudQueryConfig.getProvincialUrl() + "/rest/dtsp/result/rule/findResultByTaskId";
        return this.getResponseData(HttpMethod.GET, url, params, "Results", JSONObject.class);
    }

    public JSONObject getProvincialLandStatistics(String serviceName, String analysisResult) {
        if (this.cloudQueryConfig == null) {
            this.initConfig();
        }
        Map params = MapUtil.builder((Object)"AnalysisID", (Object)123).put((Object)"analysisResult", (Object)JSONArray.parseArray((String)analysisResult)).put((Object)"ApplicationGUID", (Object)this.cloudQueryConfig.getProvincialKey()).build();
        String url = this.cloudQueryConfig.getProvincialUrl() + "/rest/yzfx/" + serviceName + "/StatByResult";
        return this.getSJResponseData(url, JSONObject.toJSONString((Object)params), "Results", JSONObject.class);
    }

    public JSONObject resetProvincialCloudQuery(String id, String serviceId) {
        if (this.cloudQueryConfig == null) {
            this.initConfig();
        }
        Map params = MapUtil.builder((Object)"taskId", (Object)id).put((Object)"serviceId", (Object)serviceId).build();
        String url = this.cloudQueryConfig.getProvincialUrl() + "/rest/dtsp/" + this.cloudQueryConfig.getProvincialServiceName() + "/extension/reset";
        return this.getSJResponseData(url, JSONObject.toJSONString((Object)params));
    }

    public JSONArray getProvincialImages(String id, String serviceId) {
        if (this.cloudQueryConfig == null) {
            this.initConfig();
        }
        Map params = MapUtil.builder((Object)"id", (Object)id).put((Object)"serviceId", (Object)serviceId).build();
        String url = this.cloudQueryConfig.getProvincialUrl() + "/rest/dtsp/result/findImageByServiceId";
        return this.getResponseData(HttpMethod.GET, url, params, "Results", JSONArray.class);
    }

    public JSONArray getProvincialStatusByTaskId(String cloudqueryId) {
        String url = this.cloudQueryConfig.getProvincialUrl() + "/rest/dtsp/result/findStatusByTaskId";
        Map params = MapUtil.builder((Object)"id", (Object)cloudqueryId).build();
        return this.getResponseData(HttpMethod.GET, url, params, "Results", JSONArray.class);
    }
}

