-- ----------------------------
--2025年4月8日，oyyh，创建用地审批合理判定工具相关库表
-- ----------------------------

--1.创建用地审批合理判定任务表
DROP TABLE IF EXISTS "tb_smart_ydsphlpd_task";
CREATE TABLE "tb_smart_ydsphlpd_task" (
                                                   "f_id" varchar(50) NOT NULL,
                                                   "f_user_id" varchar(50),
                                                   "f_name" varchar(255),
                                                   "f_create_time" timestamp(6),
                                                   "f_status" int4,
                                                   "f_msg" text,
                                                   "f_analysis_time" timestamp(6),
                                                   "f_cost" float8,
                                                   "f_dkzmj" float8,
                                                   "f_yzzmj" float8,
                                                   "f_yzbl" float8,
                                                   "f_uniquetaskid" varchar(50)
);
COMMENT ON COLUMN "tb_smart_ydsphlpd_task"."f_user_id" IS '用户id';
COMMENT ON COLUMN "tb_smart_ydsphlpd_task"."f_name" IS '任务名称';
COMMENT ON COLUMN "tb_smart_ydsphlpd_task"."f_create_time" IS '创建时间';
COMMENT ON COLUMN "tb_smart_ydsphlpd_task"."f_status" IS '任务状态，0：未分析，-1：正在运行，200：执行成功，500：执行失败';
COMMENT ON COLUMN "tb_smart_ydsphlpd_task"."f_msg" IS '消息';
COMMENT ON COLUMN "tb_smart_ydsphlpd_task"."f_analysis_time" IS '分析时间';
COMMENT ON COLUMN "tb_smart_ydsphlpd_task"."f_cost" IS '分析耗时：秒';
COMMENT ON COLUMN "tb_smart_ydsphlpd_task"."f_dkzmj" IS '地块总面积，单位：平方米';
COMMENT ON COLUMN "tb_smart_ydsphlpd_task"."f_yzzmj" IS '压占总面积，单位：平方米';
COMMENT ON COLUMN "tb_smart_ydsphlpd_task"."f_yzbl" IS '压占比例 = 压占总面积/地块总面积';
COMMENT ON COLUMN "tb_smart_ydsphlpd_task"."f_uniquetaskid" IS '引擎里的任务id';

ALTER TABLE "tb_smart_ydsphlpd_task" ADD CONSTRAINT "tb_smart_ydsphlpd_task_pkey" PRIMARY KEY ("f_id");
CREATE INDEX "i_tb_smart_ydsphlpd_task" ON "tb_smart_ydsphlpd_task"(
                                                                             "f_user_id",
                                                                             "f_name",
                                                                             "f_create_time",
                                                                             "f_status"
    );


--2.创建用地审批合理判定任务数据表
DROP TABLE IF EXISTS "tb_smart_ydsphlpd_taskdata";
CREATE TABLE "tb_smart_ydsphlpd_taskdata" (
                                                       "f_id" varchar(50) NOT NULL,
                                                       "f_dskey" varchar(50),
                                                       "f_txt_path" text,
                                                       "f_shp_path" text,
                                                       "f_shp_layername" varchar(100),
                                                       "f_blocks" text,
                                                       "f_result_detail" text,
                                                       "f_xmin" float8,
                                                       "f_xmax" float8,
                                                       "f_ymin" float8,
                                                       "f_ymax" float8
);
COMMENT ON COLUMN "tb_smart_ydsphlpd_taskdata"."f_dskey" IS '文件保存的数据源标识';
COMMENT ON COLUMN "tb_smart_ydsphlpd_taskdata"."f_txt_path" IS 'txt路径';
COMMENT ON COLUMN "tb_smart_ydsphlpd_taskdata"."f_shp_path" IS 'shp路径';
COMMENT ON COLUMN "tb_smart_ydsphlpd_taskdata"."f_shp_layername" IS 'shp图层名';
COMMENT ON COLUMN "tb_smart_ydsphlpd_taskdata"."f_blocks" IS '地块范围，从txt中解析';
COMMENT ON COLUMN "tb_smart_ydsphlpd_taskdata"."f_result_detail" IS '结果详情，不包含地块坐标信息';

ALTER TABLE "tb_smart_ydsphlpd_taskdata" ADD CONSTRAINT "tb_smart_ydsphlpd_taskdata_pkey" PRIMARY KEY ("f_id");
