/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.asr.util;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.sun.media.sound.WaveFileReader;
import com.sun.media.sound.WaveFileWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.annotation.PostConstruct;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.vosk.Model;
import org.vosk.Recognizer;

@Component
public class VoskAsrUtil {
    @Value(value="${asr.vosk.model:}")
    private String modelPath;
    @Value(value="${asr.enable:false}")
    private boolean enable;
    private Model voskModel;

    public Model getVoskModel() {
        return this.voskModel;
    }

    @PostConstruct
    public void init() {
        if (this.enable) {
            try {
                System.out.println("\u5df2\u542f\u7528ASR\uff0c\u5f00\u59cb\u52a0\u8f7dvosk\uff01");
                this.voskModel = new Model(this.modelPath);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("vosk\u6a21\u578b\u6784\u5efa\u5931\u8d25\uff01");
            }
        }
    }

    /*
     * Exception decompiling
     */
    public String getWord(String filePath) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int toInt(byte[] b) {
        return ((b[3] & 0xFF) << 24) + ((b[2] & 0xFF) << 16) + ((b[1] & 0xFF) << 8) + ((b[0] & 0xFF) << 0);
    }

    public static short toShort(byte[] b) {
        return (short)((b[1] << 8) + (b[0] << 0));
    }

    public static byte[] read(RandomAccessFile rdf, int pos, int length) throws IOException {
        rdf.seek(pos);
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = rdf.readByte();
        }
        return result;
    }

    public static void reSamplingAndSave(byte[] data, String path) throws Exception {
        WaveFileReader reader = new WaveFileReader();
        AudioInputStream audioIn = reader.getAudioInputStream(new ByteArrayInputStream(data));
        AudioFormat srcFormat = audioIn.getFormat();
        int targetSampleRate = 16000;
        AudioFormat dstFormat = new AudioFormat(srcFormat.getEncoding(), targetSampleRate, srcFormat.getSampleSizeInBits(), srcFormat.getChannels(), srcFormat.getFrameSize(), srcFormat.getFrameRate(), srcFormat.isBigEndian());
        AudioInputStream convertedIn = AudioSystem.getAudioInputStream(dstFormat, audioIn);
        File file = new File(path);
        WaveFileWriter writer = new WaveFileWriter();
        writer.write(convertedIn, AudioFileFormat.Type.WAVE, file);
    }

    public String recognize(byte[] audioData) throws Exception {
        try (Recognizer recognizer = new Recognizer(this.voskModel, 16000.0f);){
            if (recognizer.acceptWaveForm(audioData, audioData.length)) {
                String result = recognizer.getResult();
                if (StringUtils.hasLength((String)result)) {
                    JSONObject jsonObject = JSON.parseObject((String)result);
                    String string = jsonObject.getString("text").replace(" ", "");
                    return string;
                }
            } else {
                String partialResult = recognizer.getPartialResult();
                if (StringUtils.hasLength((String)partialResult)) {
                    JSONObject jsonObject = JSON.parseObject((String)partialResult);
                    String string = jsonObject.getString("partial").replace(" ", "");
                    return string;
                }
            }
            String string = "";
            return string;
        }
    }
}

