/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.codequery.controler;

import com.geoway.ns.smart.codequery.entity.CodequeryScheme;
import com.geoway.ns.smart.codequery.service.CodequerySchemeResNodeService;
import com.geoway.ns.smart.codequery.service.CodequerySchemeService;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5fae\u89c2\u67e5\u8be2\u65b9\u6848\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/codequery/scheme"})
public class CodequerySchemeController {
    private static final Logger log = LoggerFactory.getLogger(CodequerySchemeController.class);
    @Autowired
    private CodequerySchemeService tbCodequerySchemeService;
    @Autowired
    private CodequerySchemeResNodeService codequerySchemeResNodeService;

    @ApiOperation(value="1-\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResponse<List<CodequeryScheme>> selectAll(String group) throws Exception {
        List<CodequeryScheme> lshsList = this.tbCodequerySchemeService.queryList(group);
        return DataResponse.success(lshsList);
    }

    @ApiOperation(value="2-\u67e5\u8be2\u9ed8\u8ba4\u65b9\u6848")
    @RequestMapping(value={"/queryDefault"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResponse<CodequeryScheme> queryDefault() {
        return DataResponse.success((Object)this.tbCodequerySchemeService.queryDefault());
    }

    @ApiOperation(value="3-\u4fdd\u5b58\u6216\u66f4\u65b0")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse saveOrUpdate(CodequeryScheme tbCodequeryScheme) {
        this.tbCodequerySchemeService.saveOrUpdateInfo(tbCodequeryScheme);
        return BaseResponse.success();
    }

    @ApiOperation(value="4-\u5220\u9664")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse schemeDelete(@RequestParam(value="id") String id) {
        this.tbCodequerySchemeService.deleteById(id);
        return BaseResponse.success();
    }

    @ApiOperation(value="5-\u8bbe\u7f6e\u9ed8\u8ba4\u65b9\u6848")
    @RequestMapping(value={"/setDefault"}, method={RequestMethod.POST})
    @ResponseBody
    public BaseResponse setDefault(@RequestParam(value="id") String id) {
        this.tbCodequerySchemeService.setDefault(id);
        return BaseResponse.success();
    }

    @ApiOperation(value="6-\u901a\u8fc7\u8d44\u6e90id\u83b7\u53d6\u65b9\u6848")
    @RequestMapping(value={"/queryByResNodeId"}, method={RequestMethod.GET})
    @ResponseBody
    public BaseResponse queryByResNodeId(String resNodeId) {
        try {
            return DataResponse.success((Object)this.tbCodequerySchemeService.queryByResNodeId(resNodeId));
        }
        catch (Exception e) {
            e.printStackTrace();
            return DataResponse.error((Exception)e);
        }
    }

    @ApiOperation(value="7-\u83b7\u53d6\u65b9\u6848\u8be6\u60c5\uff08\u5305\u542b\u5206\u7ec4\u4ee5\u53ca\u76ee\u5f55\u6811\uff09")
    @RequestMapping(value={"/info/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public DataResponse<CodequeryScheme> queryInfo(@PathVariable(value="id") String schemeId) throws Exception {
        if (StringUtils.isBlank((CharSequence)schemeId)) {
            throw new RuntimeException("\u65b9\u6848id(schemeId)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CodequeryScheme codequeryScheme = this.tbCodequerySchemeService.queryAllInfoById(schemeId);
        return DataResponse.success((Object)codequeryScheme);
    }

    @RequestMapping(value={"/moveSort"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="8-\u62d6\u62fd\u6392\u5e8f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u66f4\u65b0\u5143\u7d20\u7684id", required=true, dataTypeClass=Integer.class), @ApiImplicitParam(name="targetOrder", value="\u76ee\u6807\u4f4d\u7f6e\u5143\u7d20\u7684\u5e8f\u53f7", required=true, dataTypeClass=Integer.class)})
    public BaseResponse moveSort(@RequestParam(value="id") String id, @RequestParam(value="targetOrder") Integer targetOrder) {
        boolean res = this.tbCodequerySchemeService.sort(id, targetOrder);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/updateToFirst"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="9-\u7f6e\u9876")
    public BaseResponse updateToFirst(@RequestParam(value="id") String id) {
        boolean res = this.tbCodequerySchemeService.updateToFirst(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/updateToLast"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="10-\u7f6e\u5e95")
    public BaseResponse updateToLast(@RequestParam(value="id") String id) {
        boolean res = this.tbCodequerySchemeService.updateToLast(id);
        return res ? BaseResponse.success() : BaseResponse.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @ApiOperation(value="11-\u8bbe\u7f6e\u6570\u636e\u8d44\u6e90\u4e0e\u65b9\u6848\u5173\u8054\u5173\u7cfb")
    @RequestMapping(value={"/setScheme2ResNodeRes"}, method={RequestMethod.POST})
    public BaseResponse setScheme2ResNodeRes(@RequestParam String schemeId, @RequestParam(required=false, defaultValue="") String nodeIds) {
        this.codequerySchemeResNodeService.setScheme2ResNodeRes(schemeId, nodeIds);
        return BaseResponse.success();
    }

    @ApiOperation(value="12-\u67e5\u627e\u65b9\u6848\u5173\u8054\u7684\u6570\u636e\u6761\u76ee")
    @RequestMapping(value={"/getScheme2ResNodeRes"}, method={RequestMethod.GET})
    public DataResponse<List> getScheme2ResNodeRes(@RequestParam(required=false) String schemeId) {
        return DataResponse.success(this.codequerySchemeResNodeService.getScheme2ResNodeRes(schemeId));
    }
}

