/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.znts.util;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.util.Date;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class JwtUtils {
    private JwtUtils() {
    }

    public static String createJWT(String id, String subject, String secret, long ttlMillis) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        SecretKey secretKey = JwtUtils.generalKey(secret);
        if (secretKey == null) {
            return null;
        }
        JwtBuilder builder = Jwts.builder().setId(id).setSubject(subject).setIssuer("user").setIssuedAt(now).signWith(signatureAlgorithm, (Key)secretKey);
        if (ttlMillis >= 0L) {
            long expMillis = nowMillis + ttlMillis;
            Date expDate = new Date(expMillis);
            builder.setExpiration(expDate);
        }
        return builder.compact();
    }

    private static SecretKey generalKey(String appsecret) {
        byte[] encodedKey = new byte[]{};
        try {
            encodedKey = appsecret.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        SecretKeySpec key = new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
        return key;
    }
}

