/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.zntsnew.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.geoway.ns.geoserver3.dto.TbAnalysisTaskParam;
import com.geoway.ns.geoserver3.service.IDTSPService;
import com.geoway.ns.geoserver3.service.IGeoserver3ConfigService;
import com.geoway.ns.geoserver3.service.IGeoserver3TaskService;
import com.geoway.ns.onemap.encrypttool.entity.EncryptType;
import com.geoway.ns.onemap.encrypttool.service.BizEncryptRecordsService;
import com.geoway.ns.smart.znts.entity.CloudQueryItemSj;
import com.geoway.ns.smart.znts.entity.CloudQueryPlan;
import com.geoway.ns.smart.znts.service.CloudQueryItemSjService;
import com.geoway.ns.smart.znts.service.ICloudQueryConfigService;
import com.geoway.ns.smart.znts.util.CloudQueryHttpUtil;
import com.geoway.ns.smart.zntsnew.dto.CloudAnalaysParamDTO;
import com.geoway.ns.smart.zntsnew.entity.CloudQueryRecordNew;
import com.geoway.ns.smart.zntsnew.enums.CloudQueryType;
import com.geoway.ns.smart.zntsnew.service.CloudQueryRecordNewService;
import com.geoway.ns.smart.zntsnew.service.CloudQuerySJService;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CloudQuerySJServiceImpl
implements CloudQuerySJService {
    @Autowired
    private CloudQueryItemSjService cloudQueryItemSjService;
    @Autowired
    private CloudQueryHttpUtil cloudQueryHttpUtil;
    @Autowired
    private CloudQueryRecordNewService cloudQueryRecordNewService;
    @Autowired
    private IGeoserver3ConfigService geoserver3ConfigService;
    @Autowired
    private ICloudQueryConfigService cloudQueryConfig;
    @Autowired
    private IDTSPService idtspService;
    @Autowired
    private IGeoserver3TaskService geoserver3TaskService;
    @Autowired
    private BizEncryptRecordsService bizEncryptRecordsService;
    @Value(value="${cloud.query.bufferDistance:100}")
    private Double bufferDistance;
    @Value(value="${cloud.encryption.enable:false}")
    private boolean encryptioneEnable;

    @Override
    public JSONArray queryRule(String serviceName) {
        JSONObject responseObj = this.idtspService.queryRules(serviceName);
        return responseObj.getJSONObject("Results").getJSONArray("rules");
    }

    @Override
    public String sendCloudQuery(CloudQueryPlan plan, String taskId, CloudAnalaysParamDTO param, String address, JSONObject xmInfo) {
        List<JSONObject> list;
        JSONObject object;
        JSONObject analysisParam;
        JSONObject params = new JSONObject();
        params.put("AnalysisID", (Object)UUID.randomUUID().toString());
        params.put("ApplicationGUID", (Object)this.geoserver3ConfigService.getApplicationGuid());
        params.put("SFFHTX", (Object)true);
        params.put("YearMonth", (Object)"");
        params.put("areaType", (Object)"ProjectArea");
        params.put("bufferDistance", (Object)this.bufferDistance);
        params.put("drawBlocks", (Object)(param.getDrawBlocks() == null ? true : param.getDrawBlocks()));
        params.put("drawWidth", (Object)2);
        params.put("inCoorFormat", (Object)"WKT");
        params.put("outCoorFormat", (Object)"WKT");
        params.put("getImage", (Object)true);
        params.put("translate", (Object)true);
        params.put("async", (Object)true);
        params.put("color", (Object)"#f73131");
        xmInfo = xmInfo == null ? new JSONObject() : xmInfo;
        xmInfo.put("address", (Object)address);
        params.put("xmAttributes", (Object)xmInfo);
        params.put("filter", new HashMap(xmInfo));
        if (CollectionUtil.isNotEmpty(param.getBlocks())) {
            params.put("Blocks", param.getBlocks().stream().map(m -> {
                JSONObject object = new JSONObject();
                object.put("DK_ID", (Object)(StringUtils.isNotBlank((CharSequence)m.getDk_id()) ? m.getDk_id() : UUID.randomUUID().toString()));
                object.put("WKID", (Object)"4490");
                object.put("WKT", (Object)m.getWkt());
                object.put("attributes", m);
                return object;
            }).collect(Collectors.toList()));
        } else {
            params.put("Blocks", param.getWkts().stream().map(m -> {
                JSONObject object = new JSONObject();
                object.put("DK_ID", (Object)UUID.randomUUID().toString());
                object.put("WKID", (Object)"4490");
                object.put("WKT", m);
                return object;
            }).collect(Collectors.toList()));
        }
        String planParams = plan.getParams();
        if (StringUtils.isNotEmpty((CharSequence)planParams) && (analysisParam = (object = JSON.parseObject((String)planParams)).getJSONObject("analysisParam")) != null) {
            params.putAll((Map)analysisParam);
        }
        if (!ObjectUtils.isNotEmpty(list = this.getServices(param.getProvince(), plan.getId(), param.getWkts()))) {
            return null;
        }
        params.put("serviceList", list);
        CloudQueryRecordNew record = CloudQueryRecordNew.builder().startTime(new Date()).type(CloudQueryType.SJ.value).status(0).taskId(taskId).total(list.size()).build();
        String rid = this.cloudQueryHttpUtil.sendProvincialCloudRule(params, plan.getServiceName());
        record.setRid(rid);
        record.setCid(String.join((CharSequence)",", list.stream().map(m -> m.getString("serviceId")).collect(Collectors.toList())));
        this.cloudQueryRecordNewService.save(record);
        return rid;
    }

    @Override
    public JSONObject queryRuleResult(String rid) {
        CloudQueryRecordNew record = this.getRecord(rid);
        return this.cloudQueryHttpUtil.getProvincialRuleResultByTaskId(record.getRid());
    }

    @Override
    public JSONArray queryAnalysResult(String rid, String serviceIds) {
        CloudQueryRecordNew record = this.getRecord(rid);
        JSONArray jsonArray = this.cloudQueryHttpUtil.getProvincialResultByTaskId(record.getRid(), serviceIds);
        if (this.encryptioneEnable) {
            try {
                GeometryFactory geometryFactory = new GeometryFactory();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    ObjectMapper mapper = new ObjectMapper();
                    JSONObject resultObject = JSONObject.parseObject((String)jsonObject.getString("result"));
                    JSONArray attrArray = resultObject.getJSONArray("Results");
                    for (int j = 0; j < attrArray.size(); ++j) {
                        JSONObject attrObject = attrArray.getJSONObject(j);
                        String newWkt = this.bizEncryptRecordsService.wktEncrypt(attrObject.getString("YZWKT"), EncryptType.Encrypt);
                        attrArray.getJSONObject(j).put("YZWKT", (Object)newWkt);
                    }
                    resultObject.put("Results", (Object)attrArray);
                    JSONObject imgStringObject = JSONObject.parseObject((String)resultObject.getString("imgString"));
                    JSONObject envelopeObject = JSONObject.parseObject((String)imgStringObject.getString("envelope"));
                    double xMin = envelopeObject.getDouble("xMin");
                    double yMin = envelopeObject.getDouble("yMin");
                    double xMax = envelopeObject.getDouble("xMax");
                    double yMax = envelopeObject.getDouble("yMax");
                    ArrayList<Coordinate> colist1 = new ArrayList<Coordinate>();
                    colist1.add(new Coordinate(xMin, yMin));
                    colist1.add(new Coordinate(xMin, yMax));
                    colist1.add(new Coordinate(xMax, yMax));
                    colist1.add(new Coordinate(xMax, yMin));
                    colist1.add(new Coordinate(xMin, yMin));
                    Coordinate[] cn = colist1.toArray(new Coordinate[colist1.size()]);
                    Polygon polygon1 = geometryFactory.createPolygon(cn);
                    String newWkt = this.bizEncryptRecordsService.wktEncrypt(polygon1.toText(), EncryptType.Encrypt);
                    List coordinates = this.bizEncryptRecordsService.fromWKT(newWkt);
                    envelopeObject.put("xMin", (Object)((Coordinate[])coordinates.get((int)0))[0].x);
                    envelopeObject.put("yMin", (Object)((Coordinate[])coordinates.get((int)0))[0].y);
                    envelopeObject.put("xMax", (Object)((Coordinate[])coordinates.get((int)0))[2].x);
                    envelopeObject.put("yMax", (Object)((Coordinate[])coordinates.get((int)0))[2].y);
                    imgStringObject.put("envelope", (Object)envelopeObject);
                    resultObject.put("imgString", (Object)imgStringObject.toJSONString());
                    jsonArray.getJSONObject(i).put("result", (Object)resultObject.toJSONString());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return jsonArray;
    }

    @Override
    public JSONArray queryAnalysStatus(String rid) {
        CloudQueryRecordNew record = this.getRecord(rid);
        return this.cloudQueryHttpUtil.getProvincialStatusByTaskId(record.getRid());
    }

    @Override
    public void exportReport(HttpServletResponse response, String taskId) {
        this.idtspService.exportReport(response, taskId);
    }

    @Override
    public JSONObject findReport(String dtspId) {
        return this.idtspService.findReport(dtspId);
    }

    @Override
    public JSONObject findTaskParam(String rid) {
        CloudQueryRecordNew record = this.getRecord(rid);
        TbAnalysisTaskParam taskParam = this.geoserver3TaskService.findTaskParam(record.getRid());
        JSONObject object = JSON.parseObject((String)taskParam.getParams());
        return object;
    }

    @Override
    public JSONArray findRuleResult(String serviceName, String id, String type, Boolean status, Integer verify) {
        return this.idtspService.findRuleRes(serviceName, type, status, id, verify);
    }

    private CloudQueryRecordNew getRecord(String rid) {
        CloudQueryRecordNew one = (CloudQueryRecordNew)this.cloudQueryRecordNewService.getOne((Wrapper)Wrappers.lambdaQuery(CloudQueryRecordNew.class).eq(CloudQueryRecordNew::getRid, (Object)rid));
        if (one == null) {
            throw new RuntimeException("\u672a\u67e5\u5230\u4e91\u67e5\u8be2\u5206\u6790\u8bb0\u5f55\uff01");
        }
        return one;
    }

    private List<JSONObject> getServices(List<String> province, String planId, List<String> wkts) {
        List<CloudQueryItemSj> service = this.cloudQueryItemSjService.getService(planId, wkts, province);
        return service.stream().map(m -> {
            JSONObject object = new JSONObject();
            object.put("serviceId", (Object)m.getServiceid());
            return object;
        }).collect(Collectors.toList());
    }
}

