/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.zntsnew.util;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.ns.geoserver3.dto.TbAnalysisTask;
import com.geoway.ns.geoserver3.service.IGeoserver3TaskService;
import com.geoway.ns.smart.znts.util.CloudQueryHttpUtil;
import com.geoway.ns.smart.zntsnew.entity.CloudQueryRecordNew;
import com.geoway.ns.smart.zntsnew.entity.CloudQueryTask;
import com.geoway.ns.smart.zntsnew.enums.CloudQueryType;
import com.geoway.ns.smart.zntsnew.service.CloudQueryRecordNewService;
import com.geoway.ns.smart.zntsnew.service.CloudQueryTaskService;
import com.geoway.ns.sys.utils.TenantUserUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CloudScheduler {
    @Value(value="${cloud.query.enable:false}")
    private Boolean enable;
    @Value(value="${cloud.query.timeout:30}")
    private int timeout;
    @Autowired
    private CloudQueryTaskService cloudQueryTaskService;
    @Autowired
    private CloudQueryRecordNewService cloudQueryRecordNewService;
    @Autowired
    private CloudQueryHttpUtil cloudQueryHttpUtil;
    @Autowired
    private IGeoserver3TaskService geoserver3TaskService;
    @Autowired
    private TenantUserUtil tenantUserUtil;

    @Scheduled(cron="${cloud.query.cron:0/3 * * * * ?}")
    public void pollingTask() {
        if (this.enable.booleanValue()) {
            this.tenantUserUtil.userManage();
            List tasks = this.cloudQueryTaskService.list((Wrapper)Wrappers.lambdaQuery(CloudQueryTask.class).eq(CloudQueryTask::getStatus, (Object)0));
            if (!tasks.isEmpty()) {
                for (CloudQueryTask task : tasks) {
                    try {
                        this.manage(task);
                    }
                    catch (Exception e) {
                        task.setStatus(-1);
                        task.setMessage(e.getMessage());
                    }
                }
                this.cloudQueryTaskService.updateBatchById(tasks);
            }
        }
    }

    private void manage(CloudQueryTask task) {
        long createTime = new Date().getTime();
        List list = this.cloudQueryRecordNewService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CloudQueryRecordNew.class).eq(CloudQueryRecordNew::getTaskId, (Object)task.getId())).eq(CloudQueryRecordNew::getStatus, (Object)0));
        for (CloudQueryRecordNew record : list) {
            record = CloudQueryType.SJ.value.equals(record.getType()) ? this.queryStatusSJ(record) : this.queryStatusGJ(record);
            if (record.getMessage() == null) continue;
            task.setMessage(record.getMessage());
        }
        CloudQueryRecordNew running = list.stream().filter(f -> f.getStatus() == 0).findAny().orElse(null);
        CloudQueryRecordNew failed = list.stream().filter(f -> f.getStatus() == -1).findAny().orElse(null);
        if (running == null && failed == null) {
            task.setStatus(1);
        } else if (running == null && failed != null) {
            task.setStatus(-1);
        }
        long nowTime = new Date().getTime();
        if (nowTime - createTime > (long)(60 * this.timeout * 1000)) {
            task.setStatus(-1);
            task.setMessage("\u7b49\u5f85\u7ed3\u679c\u8d85\u65f6\uff01");
        }
        this.cloudQueryRecordNewService.updateBatchById(list);
    }

    private CloudQueryRecordNew queryStatusSJ(CloudQueryRecordNew record) {
        TbAnalysisTask task;
        JSONArray array = this.cloudQueryHttpUtil.getProvincialResultByTaskId(record.getRid(), record.getCid());
        List javaList = array.toJavaList(JSONObject.class);
        boolean flag = javaList.stream().allMatch(a -> a.getInteger("status") == -1);
        if (flag && (task = this.geoserver3TaskService.findTaskById(record.getRid())).getStatus() == 500) {
            record.setStatus(-1);
            record.setMessage(task.getMsg());
            return record;
        }
        List result = javaList.stream().map(m -> m.getJSONObject("result")).collect(Collectors.toList());
        result = (List)CollectionUtil.removeNull(result);
        CloudQueryRecordNew recordNew = this.totalManage(result, "status", record);
        ArrayList<String> isResult = new ArrayList<String>();
        for (JSONObject object : result) {
            Object o = object.get((Object)"Results");
            if (!(o instanceof List) || ((List)o).isEmpty()) continue;
            isResult.add(object.getString("serviceId") == null ? object.getString("ServiceId") : object.getString("serviceId"));
        }
        recordNew.setResultIds(String.join((CharSequence)",", isResult));
        return recordNew;
    }

    private CloudQueryRecordNew queryStatusGJ(CloudQueryRecordNew record) {
        final String rid = record.getRid();
        JSONArray array = this.cloudQueryHttpUtil.getRecordStateByRequestIds((List<String>)new ArrayList<String>(){
            {
                this.add(rid);
            }
        });
        return this.totalManage(array.toJavaList(JSONObject.class), "state", record);
    }

    private CloudQueryRecordNew totalManage(List<JSONObject> array, String statusField, CloudQueryRecordNew record) {
        Integer success = 0;
        Integer failed = 0;
        for (JSONObject object : array) {
            Integer status = object.getInteger(statusField);
            if (status == 1) {
                success = success + 1;
                continue;
            }
            if (status == 0) continue;
            failed = failed + 1;
        }
        record.setSuccess(success);
        record.setFailed(failed);
        int total = record.getSuccess() + record.getFailed();
        if (record.getSuccess().equals(record.getTotal())) {
            record.setStatus(1);
            record.setEndTime(new Date());
            record.setCost(this.getCost(record.getStartTime(), record.getEndTime()));
        } else if (total == record.getTotal()) {
            record.setStatus(-1);
            record.setEndTime(new Date());
            record.setCost(this.getCost(record.getStartTime(), record.getEndTime()));
        }
        return record;
    }

    private double getCost(Date start, Date end) {
        double e = (double)end.getTime() / 1000.0;
        double s = (double)start.getTime() / 1000.0;
        double res = e - s;
        return BigDecimal.valueOf(res).setScale(3, 1).doubleValue();
    }
}

