-- tb_cloud_query definition

-- Drop table

-- DROP TABLE tb_cloud_query;

CREATE TABLE if not exists tb_cloud_query
(
    f_id           varchar(64)                   NOT NULL,
    f_param        text                          NULL,
    f_userid       int8                          NULL,
    f_xzqdm        varchar(32)                   NULL,
    f_querytime    timestamptz(6)                NULL,
    f_result       text                          NULL,
    f_replytime    timestamptz(6)                NULL,
    f_state        int4                          NULL,
    f_weight       int4                          NULL,
    f_device_guid  varchar(64)                   NULL,
    f_isdeleted    int2    DEFAULT 0             NULL,
    f_type         int2                          NULL,
    f_querytype    int2    DEFAULT 0             NULL,
    f_relid        varchar(64)                   NULL,
    f_area         numeric                       NULL,
    f_iscollect    numeric DEFAULT 0             NULL,
    f_repeatcount  int2    DEFAULT 0             NULL,
    f_name         varchar(255)                  NULL,
    f_shareid      varchar(50)                   NULL,
    f_shareuser    int8    DEFAULT NULL::numeric NULL,
    f_appkey       varchar(64)                   NULL,
    f_ip           varchar(255)                  NULL,
    f_num          varchar(255)                  NULL,
    f_useridstr    varchar(255)                  NULL,
    f_nodeid       bpchar                        NULL,
    f_requestid    bpchar                        NULL,
    f_tag          varchar(50)                   NULL,
    f_detailresult text                          NULL,
    f_mark         int2    DEFAULT 0             NULL,
    f_lon          numeric(10, 7)                NULL,
    f_lat          numeric(10, 7)                NULL,
    f_wkt          text                          NULL,
    CONSTRAINT tb_cloud_query_pkey_1 PRIMARY KEY (f_id)
);


-- tb_cloud_query_images definition

-- Drop table

-- DROP TABLE tb_cloud_query_images;

CREATE TABLE if not exists tb_cloud_query_images
(
    f_id      varchar(100) NOT NULL,
    f_dburl   varchar(400) NULL,
    f_type    varchar(100) NULL,
    f_url     varchar(300) NULL,
    f_imgtype int2         NULL,
    CONSTRAINT tb_cloud_query_images_pkey PRIMARY KEY (f_id)
);
CREATE INDEX if not exists index_all_cloud ON tb_cloud_query_images USING btree (f_dburl, f_type, f_imgtype);
CREATE INDEX if not exists index_dburltype_cloud ON tb_cloud_query_images USING btree (f_dburl, f_type);


-- tb_cloud_query_item definition

-- Drop table

-- DROP TABLE tb_cloud_query_item;

CREATE TABLE if not exists tb_cloud_query_item
(
    f_id              bpchar(36)     NOT NULL,
    f_name            varchar(50)    NULL,
    f_tag             varchar(100)   NULL,
    f_time            date           NULL,
    f_displayformat   varchar(100)   NULL,
    f_nodeid          bpchar(36)     NULL,
    f_tablename       varchar(50)    NULL,
    f_displayname     varchar(50)    NULL,
    f_tablecontent    text           NULL,
    f_order           int2           NULL,
    f_displaytext     varchar(100)   NULL,
    f_datasource      varchar(100)   NULL,
    f_mark            int2 DEFAULT 0 NULL,
    f_tablecontentapp text           NULL,
    f_displayset      int4           NULL,
    f_enable          int2 DEFAULT 1 NULL,
    CONSTRAINT tb_cloud_query_item_pkey PRIMARY KEY (f_id)
);
CREATE INDEX if not exists tb_cloud_query_item_f_displayset_idx ON tb_cloud_query_item USING btree (f_displayset);
CREATE INDEX if not exists tb_cloud_query_item_f_order_idx ON tb_cloud_query_item USING btree (f_order);
CREATE INDEX if not exists tb_cloud_query_item_f_tag_idx ON tb_cloud_query_item USING btree (f_tag);


-- tb_cloud_query_item_config definition

-- Drop table

-- DROP TABLE tb_cloud_query_item_config;

CREATE TABLE if not exists tb_cloud_query_item_config
(
    f_id            varchar NOT NULL,
    f_item_group    varchar NULL,
    f_item_type     int2    NULL,
    f_item_url      varchar NULL,
    f_create_time   date    NULL,
    f_update_time   date    NULL,
    f_create_userid varchar NULL,
    f_update_userid varchar NULL,
    f_limit         int2    NULL
);

-- Column comments

COMMENT ON COLUMN tb_cloud_query_item_config.f_id IS '主键';
COMMENT ON COLUMN tb_cloud_query_item_config.f_item_group IS '查询项类别';
COMMENT ON COLUMN tb_cloud_query_item_config.f_item_type IS '查询项类型（1国家，2省级）';
COMMENT ON COLUMN tb_cloud_query_item_config.f_item_url IS '省级查询项对应查询地址';
COMMENT ON COLUMN tb_cloud_query_item_config.f_create_time IS '创建时间';
COMMENT ON COLUMN tb_cloud_query_item_config.f_update_time IS '更新时间';
COMMENT ON COLUMN tb_cloud_query_item_config.f_create_userid IS '创建用户';
COMMENT ON COLUMN tb_cloud_query_item_config.f_update_userid IS '更新用户';
COMMENT ON COLUMN tb_cloud_query_item_config.f_limit IS '是否默认（0非受限，1受限）';


-- tb_cloud_query_item_sj definition

-- Drop table

-- DROP TABLE tb_cloud_query_item_sj;

CREATE TABLE if not exists tb_cloud_query_item_sj
(
    f_id           varchar NOT NULL,
    f_dtspid       varchar NULL,
    f_enable       int2    NULL,
    f_servicealias varchar NULL,
    f_serviceid    varchar NULL,
    f_servicename  varchar NULL,
    f_grouptype    varchar NULL,
    f_layers       varchar NULL,
    f_chartdata    varchar NULL,
    f_serviceinfo  varchar NULL,
    f_charttype    varchar NULL,
    f_versions     varchar NULL,
    f_extention    varchar NULL,
    f_chartlayout  varchar NULL,
    f_order        int4    NULL,
    f_defaultyear  int4    NULL,
    CONSTRAINT tb_cloud_query_item_sj_pk PRIMARY KEY (f_id)
);


-- tb_cloud_query_node definition

-- Drop table

-- DROP TABLE tb_cloud_query_node;

CREATE TABLE if not exists tb_cloud_query_node
(
    f_id         varchar(36)  NOT NULL,
    f_name       varchar(50)  NULL,
    f_ip         varchar(200) NULL,
    f_regioncode varchar(6)   NULL,
    CONSTRAINT tb_cloud_query_node_pkey PRIMARY KEY (f_id)
);


-- tb_cloud_query_plan definition

-- Drop table

-- DROP TABLE tb_cloud_query_plan;

CREATE TABLE if not exists tb_cloud_query_plan
(
    f_id          varchar NOT NULL,
    f_name        varchar NULL,
    f_desc        varchar NULL,
    f_limit_times int8    NULL,
    f_limit_areas numeric NULL
);

-- Column comments

COMMENT ON COLUMN tb_cloud_query_plan.f_id IS '主键';
COMMENT ON COLUMN tb_cloud_query_plan.f_name IS '方案名称';
COMMENT ON COLUMN tb_cloud_query_plan.f_desc IS '方案描述';
COMMENT ON COLUMN tb_cloud_query_plan.f_limit_times IS '查询次数上限';
COMMENT ON COLUMN tb_cloud_query_plan.f_limit_areas IS '查询面积上限';


-- tb_cloud_query_plan_item definition

-- Drop table

-- DROP TABLE tb_cloud_query_plan_item;

CREATE TABLE if not exists tb_cloud_query_plan_item
(
    f_id         varchar NOT NULL,
    f_item_name  varchar NULL,
    f_item_id    varchar NULL,
    f_item_type  int2    NULL,
    f_item_group varchar NULL,
    f_plan_id    varchar NULL
);

-- Column comments

COMMENT ON COLUMN tb_cloud_query_plan_item.f_id IS '主键';
COMMENT ON COLUMN tb_cloud_query_plan_item.f_item_name IS '查询项名称';
COMMENT ON COLUMN tb_cloud_query_plan_item.f_item_id IS '隐藏查询项id';
COMMENT ON COLUMN tb_cloud_query_plan_item.f_item_type IS '查询项类型（1国家，2省级）';
COMMENT ON COLUMN tb_cloud_query_plan_item.f_item_group IS '查询项组别';
COMMENT ON COLUMN tb_cloud_query_plan_item.f_plan_id IS '方案id';


-- tb_cloud_query_plan_user definition

-- Drop table

-- DROP TABLE tb_cloud_query_plan_user;

CREATE TABLE if not exists tb_cloud_query_plan_user
(
    f_id         varchar NOT NULL,
    f_userid     varchar NULL,
    f_rname      varchar NULL,
    f_username   varchar NULL,
    f_phone      varchar NULL,
    f_department varchar NULL,
    f_query_time int8    NULL,
    f_query_area numeric NULL,
    f_plan_id    varchar NULL
);

-- Column comments

COMMENT ON COLUMN tb_cloud_query_plan_user.f_id IS '主键';
COMMENT ON COLUMN tb_cloud_query_plan_user.f_userid IS '用户id';
COMMENT ON COLUMN tb_cloud_query_plan_user.f_rname IS '真实姓名';
COMMENT ON COLUMN tb_cloud_query_plan_user.f_username IS '账户名';
COMMENT ON COLUMN tb_cloud_query_plan_user.f_phone IS '手机号码';
COMMENT ON COLUMN tb_cloud_query_plan_user.f_department IS '所属单位';
COMMENT ON COLUMN tb_cloud_query_plan_user.f_query_time IS '查询次数';
COMMENT ON COLUMN tb_cloud_query_plan_user.f_query_area IS '查询面积和';
COMMENT ON COLUMN tb_cloud_query_plan_user.f_plan_id IS '方案id';


-- tb_cloud_query_record definition

-- Drop table

-- DROP TABLE tb_cloud_query_record;

CREATE TABLE if not exists tb_cloud_query_record
(
    f_id          varchar(255) NOT NULL,
    f_user_id     varchar(255) NULL,
    f_update_time timestamp    NULL,
    f_name        varchar(255) NULL,
    f_address     varchar(255) NULL,
    f_param       text         NULL,
    f_collect     int2         NULL,
    f_cloud_id    varchar      NULL,
    f_status      int2         NULL,
    f_result      text         NULL,
    f_sort        int8         NULL,
    f_type        int2         NULL,
    f_request_id  varchar      NULL
);

-- Column comments

COMMENT ON COLUMN tb_cloud_query_record.f_user_id IS '用户id';
COMMENT ON COLUMN tb_cloud_query_record.f_update_time IS '分析时间';
COMMENT ON COLUMN tb_cloud_query_record.f_name IS '分析名称';
COMMENT ON COLUMN tb_cloud_query_record.f_address IS '分析位置';
COMMENT ON COLUMN tb_cloud_query_record.f_param IS '请求参数';
COMMENT ON COLUMN tb_cloud_query_record.f_collect IS '收藏（0.未收藏 1.收藏）';
COMMENT ON COLUMN tb_cloud_query_record.f_cloud_id IS '云查询返回id';
COMMENT ON COLUMN tb_cloud_query_record.f_status IS '云分析状态（0.进行 1.成功 2.失败）';
COMMENT ON COLUMN tb_cloud_query_record.f_result IS '返回结果';
COMMENT ON COLUMN tb_cloud_query_record.f_sort IS '排序值';
COMMENT ON COLUMN tb_cloud_query_record.f_type IS '查询记录类型（1国家 2省级）';
COMMENT ON COLUMN tb_cloud_query_record.f_request_id IS '云查询请求id';


-- tb_cloud_query_record_new definition

-- Drop table

-- DROP TABLE tb_cloud_query_record_new;

CREATE TABLE if not exists tb_cloud_query_record_new
(
    f_id           varchar   NOT NULL,
    f_dtspid       varchar   NOT NULL,
    f_resulttype   int2      NULL,
    f_uniquetaskid varchar   NULL,
    f_serviceid    varchar   NULL,
    f_servicename  varchar   NULL,
    f_year         varchar   NULL,
    f_analysistime timestamp NULL,
    f_status       int2      NULL,
    f_result       text      NULL,
    f_chartresult  text      NULL,
    f_userid       varchar   NULL,
    f_query_type   int2      NULL,
    f_group        varchar   NULL
);

-- Column comments

COMMENT ON COLUMN tb_cloud_query_record_new.f_id IS '查询id';
COMMENT ON COLUMN tb_cloud_query_record_new.f_dtspid IS '带图审批服务id';
COMMENT ON COLUMN tb_cloud_query_record_new.f_resulttype IS '结果类型:1: 项目结果，2: 自定义范围结果';
COMMENT ON COLUMN tb_cloud_query_record_new.f_uniquetaskid IS '如果是项目结果，则是xmguid; 否则就是唯一任务id';
COMMENT ON COLUMN tb_cloud_query_record_new.f_serviceid IS '服务项id';
COMMENT ON COLUMN tb_cloud_query_record_new.f_servicename IS '服务项名称';
COMMENT ON COLUMN tb_cloud_query_record_new.f_year IS '服务项所分析的年份';
COMMENT ON COLUMN tb_cloud_query_record_new.f_analysistime IS '分析时间';
COMMENT ON COLUMN tb_cloud_query_record_new.f_status IS '状态: -1: 分析失败，0: 正在，1: 分析成功';
COMMENT ON COLUMN tb_cloud_query_record_new.f_result IS '原始结果';
COMMENT ON COLUMN tb_cloud_query_record_new.f_chartresult IS '图表';
COMMENT ON COLUMN tb_cloud_query_record_new.f_userid IS '查询用户id';
COMMENT ON COLUMN tb_cloud_query_record_new.f_query_type IS '查询类型，1国家，2省级';
COMMENT ON COLUMN tb_cloud_query_record_new.f_group IS '查询类别';


-- tb_cloud_query_role_quetyitem definition

-- Drop table

-- DROP TABLE tb_cloud_query_role_quetyitem;

CREATE TABLE if not exists tb_cloud_query_role_quetyitem
(
    f_roleid bpchar(36)  NULL,
    f_itemid bpchar(200) NULL
);


-- tb_cloud_query_statis definition

-- Drop table

-- DROP TABLE tb_cloud_query_statis;

CREATE TABLE if not exists tb_cloud_query_statis
(
    f_id          varchar   NOT NULL,
    f_task_id     varchar   NULL,
    f_query_id    varchar   NULL,
    f_create_time timestamp NULL,
    f_data_id     varchar   NULL,
    f_type        int2      NULL,
    f_param       text      NULL
);

-- Column comments

COMMENT ON COLUMN tb_cloud_query_statis.f_type IS '0.国家云查询  1.省级云查询';
COMMENT ON COLUMN tb_cloud_query_statis.f_param IS '扩展参数';


-- tb_cloud_query_user_item definition

-- Drop table

-- DROP TABLE tb_cloud_query_user_item;

CREATE TABLE if not exists tb_cloud_query_user_item
(
    f_userid varchar NULL,
    f_itemid varchar NULL
);

drop table if exists t_znts_history;