/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.asr.service.impl;

import cn.hutool.core.io.FileUtil;
import com.alibaba.dashscope.audio.asr.recognition.Recognition;
import com.alibaba.dashscope.audio.asr.recognition.RecognitionParam;
import com.geoway.ns.smart.asr.service.AsrParaformerService;
import java.io.File;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AsrParaformerServiceImpl
implements AsrParaformerService {
    @Value(value="${asr.enable:false}")
    private boolean enable;
    @Value(value="${asr.paraformer.key:}")
    private String key;

    @Override
    public String analysis(MultipartFile audioFile) throws Exception {
        if (!this.enable) {
            throw new Exception("\u8bed\u97f3\u8bc6\u522b\u529f\u80fd\u672a\u542f\u7528!");
        }
        String dir = System.getProperty("user.dir");
        String tempDirPath = dir + File.separator + UUID.randomUUID().toString();
        File tempDirFile = new File(tempDirPath);
        tempDirFile.mkdir();
        String tempFilePath = tempDirPath + File.separator + audioFile.getOriginalFilename();
        Recognition recognizer = new Recognition();
        RecognitionParam param = ((RecognitionParam.RecognitionParamBuilder)((RecognitionParam.RecognitionParamBuilder)((RecognitionParam.RecognitionParamBuilder)RecognitionParam.builder().apiKey(this.key)).model("paraformer-realtime-v2")).format("wav").sampleRate(Integer.valueOf(16000)).parameter("language_hints", (Object)new String[]{"zh", "en"})).build();
        try {
            File file = new File(tempFilePath);
            audioFile.transferTo(file);
            String string = recognizer.call(param, file);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u8bed\u97f3\u8bc6\u522b\u5931\u8d25:" + e.getMessage());
        }
        finally {
            FileUtil.del((String)tempFilePath);
            FileUtil.del((File)tempDirFile);
        }
    }
}

