/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.fzxz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.geoserver3.dto.TbAnalysisBaseInfo;
import com.geoway.ns.geoserver3.service.IGeoserver3FzxzService;
import com.geoway.ns.smart.fzxz.entity.FzxzModel;
import com.geoway.ns.smart.fzxz.entity.FzxzModelFactor;
import com.geoway.ns.smart.fzxz.entity.FzxzModelLimitLayer;
import com.geoway.ns.smart.fzxz.mapper.FzxzModelMapper;
import com.geoway.ns.smart.fzxz.service.FzxzModelFactorService;
import com.geoway.ns.smart.fzxz.service.FzxzModelLimitLayerService;
import com.geoway.ns.smart.fzxz.service.FzxzModelService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class FzxzModelServiceImpl
extends ServiceImpl<FzxzModelMapper, FzxzModel>
implements FzxzModelService {
    @Autowired
    private FzxzModelFactorService factorService;
    @Autowired
    private FzxzModelLimitLayerService limitLayerService;
    @Autowired
    private IGeoserver3FzxzService geoserver3FzxzService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FzxzModel saveModel(FzxzModel model) {
        Integer n;
        Integer n2;
        if (model == null) {
            throw new RuntimeException("body\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)model.getName())) {
            throw new RuntimeException("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)model.getPid())) {
            model.setPid("-1");
        }
        if (model.getType() != 1 && model.getType() != 2) {
            throw new RuntimeException("\u7c7b\u578b\u8bbe\u7f6e\u9519\u8bef");
        }
        FzxzModel exist = (FzxzModel)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(FzxzModel.class).eq(FzxzModel::getName, (Object)model.getName())).eq(FzxzModel::getPid, (Object)model.getPid()));
        if (StringUtils.isEmpty((Object)model.getId())) {
            if (exist != null) {
                throw new RuntimeException("\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540d\u79f0!");
            }
            model.setId(UUID.randomUUID().toString());
            Integer order = ((FzxzModelMapper)this.baseMapper).selectMaxOrder(model.getPid());
            order = order == null ? 1 : order + 1;
            model.setOrder(order);
        } else if (exist != null && !exist.getId().equals(model.getId())) {
            throw new RuntimeException("\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540d\u79f0!");
        }
        this.factorService.remove((Wrapper)Wrappers.lambdaUpdate(FzxzModelFactor.class).eq(FzxzModelFactor::getModelId, (Object)model.getId()));
        if (model.getFactors() != null && !model.getFactors().isEmpty()) {
            Integer factorOrder = this.factorService.selectMaxOrder(model.getId());
            factorOrder = factorOrder == null ? 1 : factorOrder + 1;
            for (FzxzModelFactor factor : model.getFactors()) {
                if (StringUtils.isEmpty((Object)factor.getId())) {
                    factor.setId(UUID.randomUUID().toString());
                    n2 = factorOrder;
                    n = factorOrder = Integer.valueOf(factorOrder + 1);
                    factor.setOrder(n2);
                }
                factor.setModelId(model.getId());
            }
            this.factorService.saveBatch(model.getFactors());
        }
        this.limitLayerService.remove((Wrapper)Wrappers.lambdaUpdate(FzxzModelLimitLayer.class).eq(FzxzModelLimitLayer::getModelId, (Object)model.getId()));
        if (model.getLimitLayers() != null && !model.getLimitLayers().isEmpty()) {
            Integer limitOrder = this.limitLayerService.selectMaxOrder(model.getId());
            limitOrder = limitOrder == null ? 1 : limitOrder + 1;
            for (FzxzModelLimitLayer limitLayer : model.getLimitLayers()) {
                if (StringUtils.isEmpty((Object)limitLayer.getId())) {
                    limitLayer.setId(UUID.randomUUID().toString());
                    n2 = limitOrder;
                    n = limitOrder = Integer.valueOf(limitOrder + 1);
                    limitLayer.setOrder(n2);
                }
                limitLayer.setModelId(model.getId());
            }
            this.limitLayerService.saveBatch(model.getLimitLayers());
        }
        this.saveOrUpdate(model);
        return model;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(String id) {
        if (StringUtils.isEmpty((Object)id)) {
            return;
        }
        List<String> idList = Arrays.asList(id.split(","));
        if (idList.size() > 1) {
            this.factorService.remove((Wrapper)Wrappers.lambdaUpdate(FzxzModelFactor.class).in(FzxzModelFactor::getModelId, idList));
            this.limitLayerService.remove((Wrapper)Wrappers.lambdaUpdate(FzxzModelLimitLayer.class).in(FzxzModelLimitLayer::getModelId, idList));
            this.remove((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(FzxzModel.class).in(FzxzModel::getId, idList)).eq(FzxzModel::getType, (Object)2));
        } else {
            FzxzModel model = (FzxzModel)this.getById((Serializable)((Object)id));
            if (model != null) {
                FzxzModel subModel;
                if (model.getType() == 1 && (subModel = (FzxzModel)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(FzxzModel.class).eq(FzxzModel::getPid, (Object)model.getId())).last("limit 1"))) != null) {
                    throw new RuntimeException("\u5206\u7ec4\u4e0b\u5b58\u5728\u5185\u5bb9\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
                }
                this.factorService.remove((Wrapper)Wrappers.lambdaUpdate(FzxzModelFactor.class).eq(FzxzModelFactor::getModelId, (Object)model.getId()));
                this.limitLayerService.remove((Wrapper)Wrappers.lambdaUpdate(FzxzModelLimitLayer.class).eq(FzxzModelLimitLayer::getModelId, (Object)model.getId()));
                this.removeById((Serializable)((Object)model.getId()));
            }
        }
    }

    @Override
    public List<FzxzModel> queryGroups() {
        List list = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(FzxzModel.class).eq(FzxzModel::getType, (Object)1)).orderByAsc(FzxzModel::getOrder));
        return list;
    }

    @Override
    public IPage<FzxzModel> queryModelPage(String pid, String name, Integer type, Integer page, Integer size) {
        return ((FzxzModelMapper)this.baseMapper).queryPage((IPage<FzxzModel>)new Page((long)page.intValue(), (long)size.intValue()), pid, name, type);
    }

    @Override
    public List<FzxzModel> queryModelTree(String name) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery(FzxzModel.class);
        if (!StringUtils.isEmpty((Object)name)) {
            queryWrapper = (LambdaQueryWrapper)queryWrapper.like(FzxzModel::getName, (Object)name);
        }
        List lstModels = this.list((Wrapper)queryWrapper);
        ArrayList<String> lstNotQueryedPIds = new ArrayList<String>();
        for (FzxzModel model : lstModels) {
            Optional<FzxzModel> pModel;
            if ("-1".equals(model.getPid()) || lstNotQueryedPIds.contains(model.getPid()) || (pModel = lstModels.stream().filter(p -> Objects.equals(p.getId(), model.getPid())).findFirst()) != null || pModel.isPresent()) continue;
            lstNotQueryedPIds.add(model.getPid());
        }
        queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(FzxzModel.class).in(FzxzModel::getPid, lstNotQueryedPIds);
        lstModels.addAll(this.list((Wrapper)queryWrapper));
        List<FzxzModel> roots = lstModels.stream().filter(p -> "-1".equals(p.getPid())).collect(Collectors.toList());
        Collections.sort(roots, Comparator.comparing(FzxzModel::getOrder));
        this.setChildren(roots, lstModels);
        return roots;
    }

    @Override
    public FzxzModel queryDetail(String id) {
        FzxzModel model = (FzxzModel)this.getById((Serializable)((Object)id));
        List factors = this.factorService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(FzxzModelFactor.class).eq(FzxzModelFactor::getModelId, (Object)id)).orderByAsc(FzxzModelFactor::getOrder));
        List limitLayers = this.limitLayerService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(FzxzModelLimitLayer.class).eq(FzxzModelLimitLayer::getModelId, (Object)id)).orderByAsc(FzxzModelLimitLayer::getOrder));
        model.setFactors(factors);
        model.setLimitLayers(limitLayers);
        return model;
    }

    @Override
    public FzxzModel queryDetailName(String name) {
        FzxzModel model = (FzxzModel)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(FzxzModel.class).eq(FzxzModel::getName, (Object)name)).eq(FzxzModel::getType, (Object)2)).last("limit 1"));
        List factors = this.factorService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(FzxzModelFactor.class).eq(FzxzModelFactor::getModelId, (Object)model.getId())).orderByAsc(FzxzModelFactor::getOrder));
        List limitLayers = this.limitLayerService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(FzxzModelLimitLayer.class).eq(FzxzModelLimitLayer::getModelId, (Object)model.getId())).orderByAsc(FzxzModelLimitLayer::getOrder));
        model.setFactors(factors);
        model.setLimitLayers(limitLayers);
        return model;
    }

    @Override
    public List<TbAnalysisBaseInfo> findFzxzServices() {
        return this.geoserver3FzxzService.findList();
    }

    @Override
    public JSONObject findFzxzServiceDetail(String serviceId, String serviceName) {
        return org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)serviceId) ? this.geoserver3FzxzService.findDetailByName(serviceName) : this.geoserver3FzxzService.findDetailById(serviceId);
    }

    @Override
    public JSONArray fzxzServiceLandType(String serviceId) {
        return this.geoserver3FzxzService.queryLandType(serviceId);
    }

    @Override
    public String queryLandType(String id, String type) {
        ArrayList<JSONObject> list = new ArrayList();
        if (this.redisTemplate.hasKey((Object)("fzxzLandType:" + id)).booleanValue()) {
            list = (List)this.redisTemplate.boundValueOps((Object)("fzxzLandType:" + id)).get();
        } else {
            FzxzModel queryDetail = this.queryDetail(id);
            list = this.geoserver3FzxzService.queryLandType(queryDetail.getServiceId()).toJavaList(JSONObject.class);
            this.redisTemplate.boundValueOps((Object)("fzxzLandType:" + id)).set(list, 30L, TimeUnit.MINUTES);
        }
        return this.getType(list, type);
    }

    private String getType(List<JSONObject> list, String type) {
        for (JSONObject object : list) {
            String code = object.getString("code");
            if (type.equals(code)) {
                return object.getString("codeName");
            }
            if (!type.startsWith(code)) continue;
            return this.getType(object.getJSONArray("children").toJavaList(JSONObject.class), type);
        }
        return "";
    }

    @Override
    public void syncService(String ids) {
        List models = this.listByIds(Arrays.asList(ids.split(",")));
        for (FzxzModel model : models) {
            JSONObject jSONObject = this.geoserver3FzxzService.findDetailById(model.getServiceId());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sort(String id, String sid) {
        FzxzModel model = (FzxzModel)this.getById((Serializable)((Object)id));
        Integer order = model.getOrder();
        FzxzModel models = (FzxzModel)this.getById((Serializable)((Object)sid));
        model.setOrder(models.getOrder());
        models.setOrder(order);
        this.updateBatchById(CollectionUtil.toList((Object[])new FzxzModel[]{models, model}));
    }

    private void setChildren(List<FzxzModel> parents, List<FzxzModel> models) {
        if (parents == null || parents.size() == 0 || models == null || models.size() == 0) {
            return;
        }
        for (FzxzModel parent : parents) {
            List<FzxzModel> children = models.stream().filter(p -> Objects.equals(p.getPid(), parent.getId())).collect(Collectors.toList());
            Collections.sort(children, Comparator.comparing(FzxzModel::getOrder));
            parent.setChildren(children);
            this.setChildren(children, models);
        }
    }
}

