/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.zntsnew.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.base.util.GaussXY2BL;
import com.geoway.ns.smart.zntsnew.util.EncodingDetect;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.geotools.data.PrjFileReader;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.springframework.util.StringUtils;

public class ShpUtils {
    private static final String DEFAULT_CHARSET = "gb2312";
    private static final List<String> propKeyList = new ArrayList<String>();

    public static Map readValidShp2WKT2(String shpPath, String prjpath, List<String> requiredPropList) {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        String[] fieldIgnoreArr = new String[]{"Shape_Area", "the_geom", "Shape_Le_1"};
        try {
            List<String> notValidProps;
            ArrayList<String> geoJsonMap = new ArrayList<String>();
            ArrayList attrsMap = new ArrayList();
            ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
            File shpFile = new File(shpPath);
            ShapefileDataStore shpDataStore = (ShapefileDataStore)dataStoreFactory.createDataStore(shpFile.toURI().toURL());
            FileInputStream dbf = new FileInputStream(shpPath.replace(".shp", ".dbf"));
            byte[] bytes = new byte[30];
            ((InputStream)dbf).read(bytes);
            byte b = bytes[29];
            Charset charset = "4d".equals(Integer.toHexString(Byte.toUnsignedInt(b))) ? Charset.forName(DEFAULT_CHARSET) : StandardCharsets.UTF_8;
            shpDataStore.setCharset(charset);
            ((InputStream)dbf).close();
            ContentFeatureSource featureSource = shpDataStore.getFeatureSource();
            SimpleFeatureIterator itertor = featureSource.getFeatures().features();
            double[] bounds = new double[4];
            int i = 0;
            if (requiredPropList == null || requiredPropList.size() == 0) {
                requiredPropList = propKeyList;
            }
            if ((notValidProps = ShpUtils.validatePropKeys((SimpleFeatureSource)featureSource, requiredPropList)).size() > 0) {
                String errMsg = String.join((CharSequence)"\u3001", notValidProps);
                throw new Exception(String.format("\u5bfc\u5165\u7684shape\u6570\u636e\u7f3a\u5c11\u3010 %s \u3011\u7b49\u5fc5\u987b\u5c5e\u6027\u5b57\u6bb5!", errMsg));
            }
            SimpleFeature feature = null;
            while (itertor.hasNext()) {
                ++i;
                feature = (SimpleFeature)itertor.next();
                Geometry shape1 = (Geometry)feature.getDefaultGeometry();
                Geometry shape = ShpUtils.lonlat2WebMactor(shape1, prjpath);
                HashMap<String, String> plotAttr = new HashMap<String, String>();
                Envelope envelope = shape.getEnvelopeInternal();
                if (i == 1) {
                    bounds[0] = envelope.getMinX();
                    bounds[1] = envelope.getMinX();
                }
                bounds[0] = envelope.getMinX() < bounds[0] ? envelope.getMinX() : bounds[0];
                bounds[1] = envelope.getMinY() < bounds[1] ? envelope.getMinY() : bounds[1];
                bounds[2] = envelope.getMaxX() > bounds[2] ? envelope.getMaxX() : bounds[2];
                bounds[3] = envelope.getMaxY() > bounds[3] ? envelope.getMaxY() : bounds[3];
                Collection properties = feature.getProperties();
                Iterator iterator = properties.iterator();
                plotAttr.put("wkt", shape.toText());
                while (iterator.hasNext()) {
                    String propvalue;
                    Property property = (Property)iterator.next();
                    String propName = property.getName().getLocalPart();
                    String string = propvalue = property.getValue() == null ? "" : property.getValue().toString();
                    if (Arrays.asList(fieldIgnoreArr).contains(propName)) continue;
                    plotAttr.put(propName, propvalue);
                }
                geoJsonMap.add(shape.toText());
                attrsMap.add(plotAttr);
            }
            itertor.close();
            shpDataStore.dispose();
            rtnMap.put("bounds", bounds);
            rtnMap.put("geos", geoJsonMap);
            rtnMap.put("properties", attrsMap);
            rtnMap.put("fileType", "zip");
            rtnMap.put("status", "OK");
            rtnMap.put("message", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            rtnMap.put("status", "FAILURE");
            rtnMap.put("message", e.getMessage());
        }
        return rtnMap;
    }

    public static Map readTxt2WKT(File file) throws Exception {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, EncodingDetect.detect(file.getPath()));
        BufferedReader reader = new BufferedReader(inputStreamReader);
        try {
            JSONObject xmxx = new JSONObject();
            JSONArray dkList = new JSONArray();
            xmxx.put("geometries", (Object)dkList);
            JSONObject curDk = null;
            JSONArray curRing = null;
            String curRingIndex = null;
            String text = null;
            while ((text = reader.readLine()) != null) {
                if ("".equals(text = text.trim())) continue;
                if (text.indexOf("=") > 0) {
                    String[] pArry = text.split("=");
                    if (pArry.length == 0) continue;
                    String key = pArry[0];
                    String value = null;
                    if (pArry.length == 2) {
                        value = pArry[1];
                    }
                    xmxx.put(key, (Object)(value == null ? null : value.trim()));
                    continue;
                }
                String[] pointArry = text.split(",");
                if (pointArry.length < 4) continue;
                boolean bLandStart = text.endsWith("@");
                if (bLandStart) {
                    curRingIndex = "-1";
                    curDk = new JSONObject();
                    curDk.put("jzds", (Object)(StringUtils.isEmpty((Object)pointArry[0]) ? 0 : Integer.parseInt(pointArry[0])));
                    curDk.put("dkmj", (Object)(StringUtils.isEmpty((Object)pointArry[1]) ? 0.0 : Double.parseDouble(pointArry[1])));
                    curDk.put("dkbh", (Object)pointArry[2]);
                    curDk.put("dkmc", (Object)pointArry[3]);
                    curDk.put("txsx", (Object)pointArry[4]);
                    curDk.put("tfh", (Object)pointArry[5]);
                    curDk.put("dkyt", (Object)pointArry[6]);
                    if (pointArry.length > 9) {
                        curDk.put("yuliu", (Object)pointArry[7]);
                        curDk.put("tblx", (Object)pointArry[8]);
                        curDk.put("dlbm", (Object)pointArry[9]);
                        curDk.put("gzqpjzldb", (Object)(StringUtils.isEmpty((Object)pointArry[10]) ? 0.0 : Double.parseDouble(pointArry[10])));
                        curDk.put("gzhpjzldb", (Object)(StringUtils.isEmpty((Object)pointArry[11]) ? 0.0 : Double.parseDouble(pointArry[11])));
                        if (pointArry.length > 13) {
                            curDk.put("gddb", StringUtils.isEmpty((Object)pointArry[12]) ? null : Double.valueOf(Double.parseDouble(pointArry[12])));
                        }
                    } else {
                        curDk.put("bz", (Object)pointArry[7]);
                    }
                    curDk.put("rings", (Object)new JSONArray());
                    dkList.add((Object)curDk);
                    continue;
                }
                String ringIndex = pointArry[1];
                String zbx = xmxx.get((Object)"\u5750\u6807\u7cfb").toString();
                double[] cordinate = new double[]{new Double(pointArry[2]), new Double(pointArry[3])};
                if (!zbx.contains("\u5730\u7406\u5750\u6807\u7cfb")) {
                    int num = GaussXY2BL.Beijing54;
                    num = zbx.contains("80") ? GaussXY2BL.Xian80 : num;
                    num = zbx.contains("2000") ? GaussXY2BL.CGCS2000 : num;
                    int mZoneWide = new Integer(xmxx.get((Object)"\u51e0\u5ea6\u5206\u5e26").toString());
                    cordinate = GaussXY2BL.GaussToBL((double)new Double(pointArry[3]), (double)new Double(pointArry[2]), (int)num, (int)mZoneWide);
                }
                if (!ringIndex.equals(curRingIndex)) {
                    curRing = new JSONArray();
                    JSONArray rings = curDk.getJSONArray("rings");
                    rings.add((Object)curRing);
                    curRingIndex = ringIndex;
                }
                curRing.add((Object)cordinate);
            }
            JSONObject curJSONOject = null;
            GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
            for (int i = 0; i < dkList.size(); ++i) {
                curJSONOject = (JSONObject)dkList.get(i);
                Geometry geo = ShpUtils.dk2Geometry(curJSONOject, geometryFactory);
                double akArea = geo.getArea();
                String wkt = geo.toText();
                curJSONOject.put("wkt", (Object)wkt);
                curJSONOject.put("DKAREA", (Object)akArea);
            }
            rtnMap.put("geoJsonMap", xmxx);
            rtnMap.put("fileType", "txt");
            rtnMap.put("status", "OK");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            reader.close();
            inputStreamReader.close();
            fileInputStream.close();
        }
        return rtnMap;
    }

    private static Geometry dk2Geometry(JSONObject dkJSONObj, GeometryFactory geometryFactory) {
        JSONArray dkRings = (JSONArray)dkJSONObj.get((Object)"rings");
        Object dkGeometry = null;
        for (int j = 0; j < dkRings.size(); ++j) {
            JSONArray ring = (JSONArray)dkRings.get(j);
            Coordinate[] coords = new Coordinate[ring.size()];
            for (int k = 0; k < ring.size(); ++k) {
                Coordinate coord;
                double[] cordinate = (double[])ring.get(k);
                coords[k] = coord = new Coordinate(cordinate[0], cordinate[1]);
            }
            Polygon polygon = geometryFactory.createPolygon(coords);
            dkGeometry = dkGeometry == null ? polygon : (dkGeometry.contains((Geometry)polygon) ? dkGeometry.difference((Geometry)polygon) : dkGeometry.union((Geometry)polygon));
        }
        return dkGeometry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Geometry lonlat2WebMactor(Geometry geom, String prjpath) {
        try {
            CoordinateReferenceSystem crs = null;
            File prjFile = new File(prjpath);
            if (prjFile.exists()) {
                try (FileInputStream instream = null;){
                    instream = new FileInputStream(prjFile);
                    FileChannel channel = instream.getChannel();
                    PrjFileReader reader = new PrjFileReader((ReadableByteChannel)channel);
                    crs = reader.getCoordinateReferenceSystem();
                    reader.close();
                }
            }
            CoordinateReferenceSystem crs2000 = CRS.parseWKT((String)"GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4490]]");
            MathTransform transform = CRS.findMathTransform(crs, (CoordinateReferenceSystem)crs2000);
            return JTS.transform((Geometry)geom, (MathTransform)transform);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> validatePropKeys(SimpleFeatureSource featureSource, List<String> requiredKeyList) {
        ArrayList<String> result = new ArrayList<String>();
        try (SimpleFeatureIterator itertor = featureSource.getFeatures().features();){
            if (!itertor.hasNext()) return result;
            SimpleFeature feature = (SimpleFeature)itertor.next();
            Collection propsCollection = feature.getProperties();
            List<String> propKeyList = propsCollection.stream().map(i -> i.getName().toString()).collect(Collectors.toList());
            List<String> list2 = ShpUtils.subList2(requiredKeyList, propKeyList);
            itertor.close();
            List<String> list = list2;
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static List<String> subList2(List<String> list1, List<String> list2) {
        Map tempMap = list2.parallelStream().collect(Collectors.toMap(Function.identity(), Function.identity(), (oldData, newData) -> newData));
        return list1.parallelStream().filter(str -> !tempMap.containsKey(str)).collect(Collectors.toList());
    }
}

