/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.codequery.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogNodeDTO;
import com.geoway.adf.dms.catalog.service.impl.ResCatalogNodeServiceImpl;
import com.geoway.ns.smart.codequery.entity.CodequeryGroup;
import com.geoway.ns.smart.codequery.entity.CodequeryScheme;
import com.geoway.ns.smart.codequery.entity.CodequerySchemeResNode;
import com.geoway.ns.smart.codequery.mapper.CodequerySchemeMapper;
import com.geoway.ns.smart.codequery.mapper.CodequerySchemeResNodeMapper;
import com.geoway.ns.smart.codequery.service.CodequeryCatalogService;
import com.geoway.ns.smart.codequery.service.CodequeryGroupService;
import com.geoway.ns.smart.codequery.service.CodequerySchemeService;
import com.geoway.ns.sys.exception.ServiceException;
import com.geoway.ns.sys.service.SysPowerService;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CodequerySchemeServiceImpl
extends ServiceImpl<CodequerySchemeMapper, CodequeryScheme>
implements CodequerySchemeService {
    @Autowired
    private ResCatalogNodeServiceImpl resCatalogService;
    @Autowired
    private CodequerySchemeMapper codequerySchemeMapper;
    @Autowired
    private CodequeryCatalogService codequeryCatalogService;
    @Autowired
    private CodequeryGroupService codequeryGroupService;
    @Resource
    CodequerySchemeResNodeMapper codequerySchemeResNodeMapper;
    @Value(value="${geoserver.custom-analysis:true}")
    private Boolean customAnalysis;
    @Autowired
    private SysPowerService sysPowerService;

    @Override
    public boolean saveOrUpdateInfo(CodequeryScheme ztfxScheme) {
        CodequeryScheme originDefault;
        if (StringUtils.isBlank((CharSequence)ztfxScheme.getName())) {
            throw new RuntimeException("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)ztfxScheme.getAlias())) {
            ztfxScheme.setAlias(ztfxScheme.getName());
        }
        if (ztfxScheme.getIsDefault() == null) {
            ztfxScheme.setIsDefault(0);
        }
        if (ztfxScheme.getIsDefault().equals(1) && (originDefault = (CodequeryScheme)this.getOne((Wrapper)Wrappers.lambdaQuery(CodequeryScheme.class).eq(CodequeryScheme::getIsDefault, (Object)1))) != null) {
            originDefault.setIsDefault(0);
            this.updateById(originDefault);
        }
        CodequeryScheme exist = (CodequeryScheme)this.getOne((Wrapper)Wrappers.lambdaQuery(CodequeryScheme.class).eq(CodequeryScheme::getName, (Object)ztfxScheme.getName()));
        if (StringUtils.isEmpty((CharSequence)ztfxScheme.getId())) {
            if (exist != null) {
                throw new RuntimeException("\u540c\u540d\u65b9\u6848\u5df2\u7ecf\u5b58\u5728");
            }
            Integer order = this.codequerySchemeMapper.selectMaxOrder();
            order = order == null ? 1 : order + 1;
            ztfxScheme.setOrder(order);
            return this.save(ztfxScheme);
        }
        if (exist != null && !exist.getId().equals(ztfxScheme.getId())) {
            throw new RuntimeException("\u540c\u540d\u65b9\u6848\u5df2\u7ecf\u5b58\u5728");
        }
        return this.updateById(ztfxScheme);
    }

    @Override
    public List<CodequeryScheme> queryList(String group) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(CodequeryScheme.class).orderByAsc(CodequeryScheme::getOrder);
        if (StringUtils.isNotEmpty((CharSequence)group)) {
            wrapper.eq(CodequeryScheme::getGroup, (Object)group);
        }
        return this.list((Wrapper)wrapper);
    }

    @Override
    public CodequeryScheme queryDefault() {
        return (CodequeryScheme)this.getOne((Wrapper)Wrappers.lambdaQuery(CodequeryScheme.class).eq(CodequeryScheme::getIsDefault, (Object)1));
    }

    @Override
    public boolean setDefault(String id) {
        CodequeryScheme originDefault = (CodequeryScheme)this.getOne((Wrapper)Wrappers.lambdaQuery(CodequeryScheme.class).eq(CodequeryScheme::getIsDefault, (Object)1));
        if (originDefault != null) {
            originDefault.setIsDefault(0);
            this.updateById(originDefault);
        }
        CodequeryScheme tbCodequeryScheme = (CodequeryScheme)this.getById((Serializable)((Object)id));
        tbCodequeryScheme.setIsDefault(1);
        return this.updateById(tbCodequeryScheme);
    }

    @Override
    public boolean deleteById(String id) {
        this.codequeryCatalogService.deleteBySchemeId(id);
        this.codequeryGroupService.deleteBySchemeId(id);
        return this.removeById((Serializable)((Object)id));
    }

    @Override
    public String addPlanResNode(String planId, String ids) {
        if (StrUtil.isBlank((CharSequence)planId)) {
            throw new ServiceException("\u65b9\u6848id\u4e3a\u5fc5\u4f20\u53c2\u6570");
        }
        if (StrUtil.isBlank((CharSequence)ids)) {
            throw new ServiceException("\u8d44\u6e90\u8282\u70b9id\u4e3a\u5fc5\u4f20\u53c2\u6570");
        }
        Map nodeDTOMap = this.resCatalogService.getNodeDetails(Arrays.asList(ids.split(",")));
        StringBuilder errMsg = new StringBuilder();
        for (String idKey : nodeDTOMap.keySet()) {
            ResCatalogNodeDTO resNode = (ResCatalogNodeDTO)nodeDTOMap.get(idKey);
            CodequerySchemeResNode codequerySchemeResNode = new CodequerySchemeResNode();
            codequerySchemeResNode.setResNodeId(resNode.getNodeId());
            codequerySchemeResNode.setResName(resNode.getNodeName());
            codequerySchemeResNode.setPlanId(planId);
            this.codequerySchemeResNodeMapper.insert(codequerySchemeResNode);
        }
        return errMsg.toString();
    }

    @Override
    public void deletePlanResNode(String ids) {
        this.codequerySchemeResNodeMapper.deleteBatchIds(Arrays.asList(ids.split(",")));
    }

    @Override
    public IPage<CodequerySchemeResNode> queryPlanResNodeList(String planId, String key, int page, int size) {
        if (StrUtil.isBlank((CharSequence)planId)) {
            throw new ServiceException("\u65b9\u6848id\u4e3a\u5fc5\u4f20\u53c2\u6570");
        }
        if (page < 1) {
            throw new ServiceException("\u9875\u7801\u53c2\u6570\u503c\u5f02\u5e38");
        }
        if (size < 1) {
            throw new ServiceException("\u6bcf\u9875\u663e\u793a\u4e2a\u6570\u53c2\u6570\u503c\u5f02\u5e38");
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate(CodequerySchemeResNode.class);
        if (!StrUtil.isBlank((CharSequence)key)) {
            wrapper.and(w -> {
                LambdaUpdateWrapper cfr_ignored_0 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)w.like(CodequerySchemeResNode::getResName, (Object)key)).or()).like(CodequerySchemeResNode::getResNodeId, (Object)key);
            });
        }
        wrapper.eq(CodequerySchemeResNode::getPlanId, (Object)planId);
        Page pages = new Page((long)page, (long)size);
        return this.codequerySchemeResNodeMapper.selectPage((IPage)pages, (Wrapper)wrapper);
    }

    @Override
    public CodequeryScheme queryByResNodeId(String resNodeId) throws Exception {
        if (StringUtils.isEmpty((CharSequence)resNodeId)) {
            throw new RuntimeException("resNodeId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MPJLambdaWrapper queryWrapper = new MPJLambdaWrapper();
        queryWrapper.leftJoin(CodequerySchemeResNode.class, CodequerySchemeResNode::getPlanId, CodequeryScheme::getId);
        queryWrapper.eq(CodequerySchemeResNode::getResNodeId, (Object)resNodeId);
        queryWrapper.orderByAsc(CodequeryScheme::getOrder);
        List codequerySchemeList = this.list((Wrapper)queryWrapper);
        if (codequerySchemeList != null && codequerySchemeList.size() > 0) {
            return (CodequeryScheme)codequerySchemeList.get(0);
        }
        return this.queryDefault();
    }

    @Override
    public CodequeryScheme queryById(String id) {
        CodequeryScheme codequeryScheme = (CodequeryScheme)this.getById((Serializable)((Object)id));
        List<CodequeryGroup> groups = this.codequeryGroupService.queryBySchemeId(id);
        codequeryScheme.setGroupList(groups);
        return codequeryScheme;
    }

    @Override
    public CodequeryScheme queryAllInfoById(String id) {
        CodequeryScheme codequeryScheme = (CodequeryScheme)this.getById((Serializable)((Object)id));
        List<CodequeryGroup> groups = this.codequeryGroupService.queryListWithCatalogsBySchemeId(id);
        codequeryScheme.setGroupList(groups);
        return codequeryScheme;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sort(String id, int order) {
        CodequeryScheme curScheme = (CodequeryScheme)this.getById((Serializable)((Object)id));
        if (curScheme == null) {
            return true;
        }
        if (curScheme.getOrder().equals(order)) {
            return true;
        }
        List needUpdateList = null;
        if (curScheme.getOrder() > order) {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CodequeryScheme.class).ge(CodequeryScheme::getOrder, (Object)order)).lt(CodequeryScheme::getOrder, (Object)curScheme.getOrder())).orderByAsc(CodequeryScheme::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((CodequeryScheme)needUpdateList.get(i)).setOrder(order + i + 1);
            }
        } else {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CodequeryScheme.class).gt(CodequeryScheme::getOrder, (Object)curScheme.getOrder())).le(CodequeryScheme::getOrder, (Object)order)).orderByAsc(CodequeryScheme::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((CodequeryScheme)needUpdateList.get(i)).setOrder(curScheme.getOrder() + i);
            }
        }
        curScheme.setOrder(order);
        needUpdateList.add(curScheme);
        return this.updateBatchById(needUpdateList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToFirst(String id) {
        return this.sort(id, 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateToLast(String id) {
        CodequeryScheme curScheme = (CodequeryScheme)this.getById((Serializable)((Object)id));
        if (curScheme == null) {
            return false;
        }
        CodequeryScheme maxTable = (CodequeryScheme)this.list((Wrapper)Wrappers.lambdaQuery(CodequeryScheme.class).orderByDesc(CodequeryScheme::getOrder)).get(0);
        return this.sort(id, maxTable.getOrder());
    }
}

