/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.fzxz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.ns.smart.fzxz.dto.FzxzRequestDTO;
import com.geoway.ns.smart.fzxz.entity.FzxzTask;
import com.geoway.ns.smart.fzxz.service.FzxzTaskService;
import com.geoway.ns.sys.dto.PageParam;
import com.geoway.ns.sys.dto.RestResult;
import com.geoway.ns.sys.service.ITokenService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8f85\u52a9\u9009\u5740\u4efb\u52a1\u76f8\u5173\u63a5\u53e3"})
@RestController
@CrossOrigin
@RequestMapping(value={"/smart/fzxz/task"})
public class FzxzTaskController {
    @Autowired
    private ITokenService tokenService;
    @Autowired
    private FzxzTaskService fzxzTaskService;

    @ApiOperation(value="1-\u67e5\u8be2\u8f85\u52a9\u9009\u5740\u4efb\u52a1\u5206\u9875")
    @ApiOperationSupport(order=1)
    @RequestMapping(value={"/page"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public RestResult<IPage<FzxzTask>> queryModelPage(PageParam pageParam, String modelPid, String modelId, Integer status, String name) throws Exception {
        String userId = this.getUserId();
        return RestResult.success(this.fzxzTaskService.queryTaskPage(pageParam.getPage(), pageParam.getSize(), userId, modelPid, modelId, status, name));
    }

    @ApiOperation(value="2-\u521b\u5efa\u8f85\u52a9\u9009\u5740\u4efb\u52a1")
    @ApiOperationSupport(order=2)
    @RequestMapping(value={"/create"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public RestResult<String> createTask(@RequestBody FzxzRequestDTO fzxzRequestDTO) throws Exception {
        String taskId = this.fzxzTaskService.createTask(fzxzRequestDTO, this.getUserId());
        return RestResult.success((Object)taskId);
    }

    @ApiOperation(value="3-\u5220\u9664\u8f85\u52a9\u9009\u5740\u4efb\u52a1")
    @ApiOperationSupport(order=3)
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public RestResult<String> delete(String id) throws Exception {
        this.fzxzTaskService.deleteTaskById(id);
        return RestResult.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="4-\u67e5\u8be2\u8f85\u52a9\u9009\u5740\u4efb\u52a1\u7ed3\u679c")
    @ApiOperationSupport(order=4)
    @RequestMapping(value={"/result"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public RestResult<List<JSONObject>> queryAnalysResult(PageParam pageParam, String id) throws Exception {
        return RestResult.success((Object)this.fzxzTaskService.queryResult(pageParam, id));
    }

    @ApiOperation(value="5-\u5bfc\u51fa\u9009\u5740\u7ed3\u679c\u62a5\u544a")
    @ApiOperationSupport(order=5)
    @RequestMapping(value={"/exportReport"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public void exportReport(HttpServletResponse response, String taskId) throws Exception {
        this.fzxzTaskService.exportReport(response, taskId);
    }

    @ApiOperation(value="6-\u83b7\u53d6\u62a5\u544a\u57fa\u672c\u4fe1\u606f")
    @ApiOperationSupport(order=6)
    @RequestMapping(value={"/report"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public RestResult<JSONObject> report(HttpServletResponse response, String taskId) throws Exception {
        return RestResult.success((Object)this.fzxzTaskService.report(taskId));
    }

    @ApiOperation(value="7-\u53d1\u8d77\u8f85\u52a9\u9009\u5740\u5206\u6790\uff08\u9002\u914d\u65e7\u7248\u8f85\u52a9\u9009\u5740\uff09")
    @ApiOperationSupport(order=2)
    @RequestMapping(value={"/analys/{serviceName}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public RestResult<JSONObject> sendService(@PathVariable String serviceName, @RequestBody Map<String, Object> map) throws Exception {
        return RestResult.success((Object)this.fzxzTaskService.sendService(serviceName, map));
    }

    @ApiOperation(value="8-\u9009\u5740\u4efb\u52a1\u8be6\u60c5")
    @ApiOperationSupport(order=2)
    @RequestMapping(value={"/detail"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public RestResult<FzxzTask> detail(String taskId) throws Exception {
        return RestResult.success((Object)this.fzxzTaskService.getTaskDetail(taskId));
    }

    private String getUserId() throws Exception {
        String userId = this.tokenService.queryCurrentSysUserId();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        return userId;
    }
}

