/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.fzxz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.geoserver3.service.IGeoserver3FzxzService;
import com.geoway.ns.geoserver3.service.IGeoserver3TaskService;
import com.geoway.ns.smart.fzxz.dto.FzxzRequestDTO;
import com.geoway.ns.smart.fzxz.entity.FzxzModel;
import com.geoway.ns.smart.fzxz.entity.FzxzModelFactor;
import com.geoway.ns.smart.fzxz.entity.FzxzModelLimitLayer;
import com.geoway.ns.smart.fzxz.entity.FzxzTask;
import com.geoway.ns.smart.fzxz.enums.EnumAreaUnit;
import com.geoway.ns.smart.fzxz.mapper.FzxzTaskMapper;
import com.geoway.ns.smart.fzxz.service.FzxzModelService;
import com.geoway.ns.smart.fzxz.service.FzxzTaskService;
import com.geoway.ns.sys.dto.PageParam;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FzxzTaskServiceImpl
extends ServiceImpl<FzxzTaskMapper, FzxzTask>
implements FzxzTaskService {
    @Autowired
    private IGeoserver3FzxzService geoserver3FzxzService;
    @Autowired
    private IGeoserver3TaskService geoserver3TaskService;
    @Autowired
    private FzxzModelService fzxzModelService;

    @Override
    public FzxzTask getTaskDetail(String taskId) {
        FzxzTask task = (FzxzTask)this.getById((Serializable)((Object)taskId));
        return task;
    }

    @Override
    public IPage<FzxzTask> queryTaskPage(Integer page, Integer size, String userId, String modelPid, String modelId, Integer status, String name) {
        return ((FzxzTaskMapper)this.baseMapper).queryPage((IPage<FzxzTask>)new Page((long)page.intValue(), (long)size.intValue()), userId, modelPid, modelId, status, name);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String createTask(FzxzRequestDTO dto, String userId) {
        FzxzModel model = this.fzxzModelService.queryDetail(dto.getModelId());
        dto.setAsync(true);
        dto.setLayer(model.getSiteLayerAlias());
        JSONObject object = this.geoserver3FzxzService.analysis(model.getServiceId(), BeanUtil.beanToMap((Object)dto, (String[])new String[0]));
        FzxzTask task = new FzxzTask();
        task.setId(object.getString("UniqueTaskID"));
        task.setUserId(userId);
        task.setCreateTime(new Date());
        task.setModelId(model.getId());
        task.setModelPid(model.getPid());
        task.setName(dto.getTaskName());
        task.setStatus(0);
        List list = dto.getLimitLayers().stream().map(m -> m.getId()).collect(Collectors.toList());
        List<FzxzModelLimitLayer> layersFilter = model.getLimitLayers().stream().filter(f -> list.contains(f.getLayerId())).collect(Collectors.toList());
        model.setLimitLayers(layersFilter);
        List factors = dto.getFactorInfo().stream().map(m -> m.getFid()).collect(Collectors.toList());
        List<FzxzModelFactor> factorsCollect = model.getFactors().stream().filter(f -> factors.contains(f.getFactorId())).collect(Collectors.toList());
        model.setFactors(factorsCollect);
        model.setYdmjUnit(EnumAreaUnit.getType(dto.getUnit()));
        task.setParam(JSONObject.toJSONString((Object)model));
        this.save(task);
        return task.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteTaskById(String id) {
        this.removeById((Serializable)((Object)id));
    }

    @Override
    public List queryResult(PageParam pageParam, String taskId) {
        JSONObject result = this.geoserver3TaskService.findResult(taskId);
        return result.getJSONArray("Results");
    }

    @Override
    public void exportReport(HttpServletResponse response, String taskId) {
        this.geoserver3TaskService.exportReport(response, taskId);
    }

    @Override
    public JSONObject report(String taskId) {
        FzxzTask task = (FzxzTask)this.getById((Serializable)((Object)taskId));
        FzxzModel fzxzModel = this.fzxzModelService.queryDetail(task.getModelId());
        return this.geoserver3FzxzService.report(fzxzModel.getServiceId());
    }

    @Override
    public JSONObject sendService(String serviceName, Map<String, Object> map) {
        return this.geoserver3FzxzService.analysisByName(serviceName, map);
    }
}

