/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.smart.znts.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.ns.smart.znts.dto.CloudQueryRecordDTO;
import com.geoway.ns.smart.znts.entity.CloudQueryRecord;
import com.geoway.ns.smart.znts.service.CloudQueryRecordService;
import com.geoway.ns.sys.dto.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e91\u67e5\u8be2\u8bb0\u5f55\u76f8\u5173\u63a5\u53e3"})
@RestController
@CrossOrigin
@RequestMapping(value={"/cloudQueryRecord"})
public class CloudQueryRecordController {
    @Resource
    private CloudQueryRecordService cloudQueryRecordService;

    @ApiOperation(value="\u4fdd\u5b58\u8bb0\u5f55")
    @RequestMapping(value={"/saveRecord"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public RestResult<String> saveRecord(CloudQueryRecord cloudQueryRecord) throws Exception {
        this.cloudQueryRecordService.saveRecord(cloudQueryRecord);
        return RestResult.success((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u67e5\u8be2\u8bb0\u5f55")
    @RequestMapping(value={"/queryPageRecord"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public RestResult<IPage> queryPageRecord(CloudQueryRecordDTO cqd, HttpServletRequest request) throws Exception {
        String userId = "101";
        cqd.setUserId(userId);
        if (cqd.getPage() == null || cqd.getPage() < 1) {
            cqd.setPage(1);
        }
        if (cqd.getSize() == null || cqd.getSize() < 1) {
            cqd.setSize(10);
        }
        if (cqd.getSortByTime() == null || cqd.getSize() != 1 && cqd.getSize() != 0) {
            cqd.setSortByTime(0);
        }
        return RestResult.success(this.cloudQueryRecordService.queryPageRecord(cqd));
    }

    @ApiOperation(value="\u5220\u9664\u8bb0\u5f55")
    @RequestMapping(value={"/deleteRecord"}, method={RequestMethod.DELETE}, produces={"application/json;charset=UTF-8"})
    public RestResult<Object> deleteRecord(String id) throws Exception {
        this.cloudQueryRecordService.deleteRecord(id);
        return RestResult.success((Object)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u7f16\u8f91\u8bb0\u5f55")
    @RequestMapping(value={"/updateRecord"}, method={RequestMethod.PUT}, produces={"application/json;charset=UTF-8"})
    public RestResult<Object> updateRecord(CloudQueryRecord cloudQueryRecord) throws Exception {
        this.cloudQueryRecordService.updateRecord(cloudQueryRecord);
        return RestResult.success((Object)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u4efb\u52a1\u8bb0\u5f55")
    @GetMapping(value={"/cloudQueryTaskRecord"})
    public RestResult<Object> cloudQueryRecord(@RequestHeader(value="Access_token") String token, @ApiParam(value="\u5f53\u524d\u9875\u6570", required=false) @RequestParam(name="currentPage", required=false) Integer currentPage, @ApiParam(value="\u6bcf\u9875\u663e\u793a\u8bb0\u5f55\u6570", required=false) @RequestParam(name="pageSize", required=false) Integer pageSize) throws Exception {
        if (currentPage == null || currentPage < 1) {
            currentPage = 1;
        }
        if (pageSize == null || pageSize < 1) {
            pageSize = 10;
        }
        return RestResult.success(this.cloudQueryRecordService.findCloudQueryRecord(pageSize, currentPage));
    }

    @ApiOperation(value="\u5220\u9664\u4e91\u67e5\u8be2\u8bb0\u5f55")
    @GetMapping(value={"/deleteCloudQueryRecord"})
    public RestResult<Object> deleteCloudQueryRecord(@RequestHeader(value="Access_token") String token, @ApiParam(value="\u8bf7\u6c42requestId", required=true) @RequestParam(name="requestId", required=true) String requestId) throws Exception {
        boolean flag = false;
        if (StringUtils.isNotBlank((CharSequence)requestId) && (flag = this.cloudQueryRecordService.deleteByRequstId(requestId).booleanValue())) {
            return RestResult.success((Object)"\u5220\u9664\u4e91\u67e5\u8be2\u8bb0\u5f55\u6210\u529f\uff01");
        }
        return RestResult.error((String)"\u5220\u9664\u4e91\u67e5\u8be2\u8bb0\u5f55\u5931\u8d25\uff01");
    }
}

