/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.config;

import cn.hutool.core.util.StrUtil;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.service.LoginUserService;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.utils.MyRequestUtil;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
@ConditionalOnProperty(name={"catalog.right.disabled"}, havingValue="false")
public class LoginUserConfig
implements LoginUserService {
    @Autowired
    private ITokenService tokenService;

    public LoginUserInfo getUserInfo(HttpServletRequest request) {
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader(request);
            if (StrUtil.isEmpty((CharSequence)token)) {
                throw new RuntimeException("\u672a\u83b7\u53d6\u5230token!");
            }
            SysUserDTO sysUserDTO = this.tokenService.querySysUserByToken(token);
            LoginUserInfo loginUserInfo = new LoginUserInfo();
            loginUserInfo.setRoleId(sysUserDTO.getRoles().stream().map(m -> m.getId()).collect(Collectors.joining(",")));
            loginUserInfo.setUserId(sysUserDTO.getId());
            loginUserInfo.setUserName(sysUserDTO.getUsername());
            return loginUserInfo;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

