/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.controller;

import com.geoway.ns.sys.dto.BaseObjectResponse;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.utils.MyRequestUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/user"})
public class UserController {
    @Autowired
    private ITokenService tokenService;

    @ApiOperation(value="1-\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"userInfo"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse<SysUserDTO> queryUserInfo(HttpServletRequest request) {
        DataResponse<SysUserDTO> response = new DataResponse<SysUserDTO>();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader(request);
            SysUserDTO userDTO = this.tokenService.querySysUserByToken(token);
            response.setResult(userDTO);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="2-\u5206\u9875\u67e5\u8be2")
    @RequestMapping(value={"list"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public BaseResponse listUser(HttpServletRequest request, @RequestParam(defaultValue="1", required=false) int page, @RequestParam(defaultValue="1", required=false) int rows) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader(request);
            response.setData(this.tokenService.getUserList(token));
        }
        catch (Exception ex) {
            response.setMessage(ex.getMessage());
            response.setStatus("FAILURE");
        }
        return response;
    }
}

