/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.exception;

import com.geoway.ns.sys.dto.RestResult;
import com.geoway.ns.sys.enums.ResultCodeEnum;
import com.geoway.ns.sys.exception.FileException;
import com.geoway.ns.sys.exception.ServiceException;
import java.sql.SQLException;
import java.util.List;
import javax.security.auth.login.AccountException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class NsGlobalExceptionHandler {
    public static Logger log = LogManager.getLogger(NsGlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public RestResult<ResultCodeEnum> error(Exception e) {
        e.printStackTrace();
        log.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7\uff1a" + e);
        return RestResult.error(500, e.getMessage());
    }

    @ExceptionHandler(value={NullPointerException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public RestResult<ResultCodeEnum> error(NullPointerException e) {
        e.printStackTrace();
        log.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7\uff1a" + e);
        return RestResult.error(ResultCodeEnum.NULL_POINT);
    }

    @ExceptionHandler(value={IndexOutOfBoundsException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public RestResult<ResultCodeEnum> error(IndexOutOfBoundsException e) {
        e.printStackTrace();
        log.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7\uff1a" + e);
        return RestResult.error(ResultCodeEnum.INDEX_OUT_OF_BOUNDS);
    }

    @ExceptionHandler(value={SQLException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public RestResult<ResultCodeEnum> error(SQLException e) {
        e.printStackTrace();
        log.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7\uff1a" + e);
        return RestResult.error(ResultCodeEnum.SQL_ERROR);
    }

    @ExceptionHandler(value={FileException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.REQUEST_TIMEOUT)
    public RestResult<ResultCodeEnum> error(FileException e) {
        e.printStackTrace();
        log.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7\uff1a" + e);
        return RestResult.error(ResultCodeEnum.REQUEST_TIMEOUT);
    }

    @ExceptionHandler(value={AccountException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public RestResult<ResultCodeEnum> error(AccountException e) {
        e.printStackTrace();
        log.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7\uff1a" + e);
        return RestResult.error(ResultCodeEnum.NOT_LOGIN_ERROR);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public RestResult<ResultCodeEnum> handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        log.error(e.getMessage());
        BindingResult result = e.getBindingResult();
        StringBuilder errorMsg = new StringBuilder();
        if (result.hasErrors()) {
            List fieldErrors = result.getFieldErrors();
            fieldErrors.forEach(error -> errorMsg.append("field\uff1a").append(error.getField()).append(", msg\uff1a").append(error.getDefaultMessage()).append("\uff1b"));
        }
        return RestResult.error(400, errorMsg.toString());
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public RestResult<ResultCodeEnum> error(ServiceException e) {
        e.printStackTrace();
        log.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7\uff1a" + e);
        return RestResult.error(ResultCodeEnum.CUSTOM_ERROR.getCode(), e.getMessage());
    }
}

