/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.service.impl;

import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.adf.dms.config.service.DictionaryService;
import com.geoway.ns.sys.utils.RedisUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictService {
    private String redisKeyPre = "Dict_";
    private long expire = 14400L;
    @Autowired
    private DictionaryService dictionaryService;
    @Autowired
    private RedisUtil redisUtil;

    public String getDictValueByRedis(String dictKey, String name, String defaultValue) {
        String redisKey = this.redisKeyPre + dictKey + "_" + name;
        if (this.redisUtil.hasKey(redisKey)) {
            return this.redisUtil.get(redisKey).toString();
        }
        String value = this.getDictValue(dictKey, name, defaultValue);
        this.redisUtil.set(redisKey, value, this.expire);
        return value;
    }

    public String getDictValue(String dictKey, String name, String defaultValue) {
        DmDictValueDTO dictionaryTree = this.dictionaryService.getDictionaryTree(dictKey);
        if (dictionaryTree == null || StringUtils.isEmpty((CharSequence)name) || dictionaryTree.getChildren() == null || dictionaryTree.getChildren().size() == 0) {
            return defaultValue;
        }
        for (DmDictValueDTO dictValueDTO : dictionaryTree.getChildren()) {
            if (!name.equalsIgnoreCase(dictValueDTO.getName())) continue;
            return dictValueDTO.getCode();
        }
        return null;
    }

    public DmDictValueDTO getDictTree(String dictKey) {
        return this.dictionaryService.getDictionaryTree(dictKey);
    }

    public String queryNameByDictCode(DmDictValueDTO dictValueTree, String code) {
        String result = code;
        if (dictValueTree == null || dictValueTree.getChildren() == null || dictValueTree.getChildren().size() == 0) {
            return result;
        }
        for (DmDictValueDTO dictValueDTO : dictValueTree.getChildren()) {
            if (!code.equalsIgnoreCase(dictValueDTO.getCode())) continue;
            result = dictValueDTO.getName();
            break;
        }
        return result;
    }
}

