/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.sys.domain.FileServer;
import com.geoway.ns.sys.dto.FileDownloadMeta;
import com.geoway.ns.sys.dto.FileServerResponse;
import com.geoway.ns.sys.dto.FileStoreMeta;
import com.geoway.ns.sys.mapper.FileServerMapper;
import com.geoway.ns.sys.service.FileServerService;
import com.geoway.ns.sys.service.HuWeiObsFileService;
import com.geoway.ns.sys.service.MinIOFileService;
import com.geoway.ns.sys.service.ShareFileService;
import com.geoway.ns.sys.utils.ObjectKeyUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileServerServiceImpl
extends ServiceImpl<FileServerMapper, FileServer>
implements FileServerService {
    @Autowired
    ShareFileService shareFileService;
    @Autowired
    MinIOFileService minIOFileService;
    @Autowired
    HuWeiObsFileService huWeiObsFileService;
    @Autowired
    FileServerMapper fileServerMapper;

    @Override
    public FileServerResponse sendFileToServer(MultipartFile file) throws Exception {
        return this.sendFileToServer(file, false);
    }

    @Override
    public FileServerResponse sendFileToServer(MultipartFile file, boolean buildThumbnail) throws Exception {
        FileServer fileServer = this.findDefault();
        if (fileServer == null) {
            throw new Exception("\u672a\u914d\u7f6e\u6587\u4ef6\u670d\u52a1");
        }
        return this.sendFileToServer(file, null, buildThumbnail);
    }

    @Override
    public FileServerResponse sendFileToServer(MultipartFile file, String objectName, boolean buildThumbnail) throws Exception {
        FileServer fileServer = this.findDefault();
        if (fileServer == null) {
            throw new Exception("\u672a\u914d\u7f6e\u6587\u4ef6\u670d\u52a1");
        }
        return this.saveFile(fileServer, file, objectName, buildThumbnail);
    }

    @Override
    public FileServerResponse sendFileToServer(String serverId, MultipartFile file, String objectName, boolean buildThumbnail) throws Exception {
        FileServer fileServer = this.findById(Integer.parseInt(serverId));
        if (fileServer == null) {
            throw new Exception("\u672a\u914d\u7f6e\u6587\u4ef6\u670d\u52a1");
        }
        return this.saveFile(fileServer, file, objectName, buildThumbnail);
    }

    @Override
    public FileServerResponse sendFileToServerOnSpeFolder(MultipartFile file, String foldName) throws Exception {
        return this.sendFileToServerOnSpeFolder(file, foldName, false);
    }

    @Override
    public FileServerResponse sendFileToServerOnSpeFolder(MultipartFile file, String foldName, boolean buildThumbnail) throws Exception {
        FileServer fileServer = this.findDefault();
        if (fileServer == null) {
            throw new Exception("\u672a\u914d\u7f6e\u6587\u4ef6\u670d\u52a1");
        }
        String fileName = file.getOriginalFilename();
        String objectName = ObjectKeyUtil.formatObjectName(fileName);
        if (StrUtil.isNotBlank((CharSequence)foldName)) {
            objectName = foldName + "/" + objectName;
        }
        return this.sendFileToServer(file, objectName, buildThumbnail);
    }

    private FileServerResponse saveFile(FileServer fileServer, MultipartFile file, String objectName, boolean buildThumbnail) throws Exception {
        String type = fileServer.getType();
        FileStoreMeta fileStoreMeta = null;
        FileStoreMeta minFileStoreMeta = null;
        FileServerResponse fileServerResponse = new FileServerResponse();
        if ("share".equalsIgnoreCase(type)) {
            fileStoreMeta = this.shareFileService.sendFile(fileServer, file, objectName);
            if (buildThumbnail) {
                minFileStoreMeta = this.shareFileService.buildThumbnailFile(fileServer, fileStoreMeta.getRelPath());
            }
        } else if ("minio".equalsIgnoreCase(type)) {
            fileStoreMeta = this.minIOFileService.sendFile(fileServer, file, objectName);
            if (buildThumbnail) {
                minFileStoreMeta = this.minIOFileService.buildThumbnailFile(fileServer, fileStoreMeta.getRelPath());
            }
        } else {
            fileStoreMeta = this.huWeiObsFileService.sendFile(fileServer, file, objectName);
            if (buildThumbnail) {
                minFileStoreMeta = this.huWeiObsFileService.buildThumbnailFile(fileServer, fileStoreMeta.getRelPath());
            }
        }
        fileServerResponse.setServerId(fileServer.getId());
        fileServerResponse.setServerURL(fileServer.getUrl());
        fileServerResponse.setBucket(fileServer.getBucket());
        if (fileStoreMeta != null) {
            fileServerResponse.setPath(fileStoreMeta.getRelPath());
            fileServerResponse.setFileSize(fileStoreMeta.getFileSize());
            fileServerResponse.setFileType(fileStoreMeta.getFileType());
            fileServerResponse.setPreviewURL(fileStoreMeta.getPreviewURL());
            fileServerResponse.setViewURL(fileServer.getUrl() + "/" + fileServer.getBucket() + "/" + fileStoreMeta.getRelPath());
        }
        if (minFileStoreMeta != null) {
            fileServerResponse.setThumailPath(minFileStoreMeta.getRelPath());
        }
        return fileServerResponse;
    }

    @Override
    public void deleteFile(String objectName) throws Exception {
        FileServer fileServer = this.findDefault();
        this.deleteFileByFileServer(objectName, fileServer);
    }

    @Override
    public void deleteFile(Integer serverId, String objectName) throws Exception {
        FileServer fileServer = this.findById(serverId);
        this.deleteFileByFileServer(objectName, fileServer);
    }

    private void deleteFileByFileServer(String objectName, FileServer fileServer) throws Exception {
        String type;
        switch (type = fileServer.getType().toLowerCase()) {
            case "share": {
                this.shareFileService.deleteFile(fileServer, objectName);
                break;
            }
            case "minio": {
                this.minIOFileService.deleteFile(fileServer, fileServer.getBucket(), objectName);
                break;
            }
            case "obs": {
                this.huWeiObsFileService.deleteFile(fileServer, fileServer.getBucket(), objectName);
                break;
            }
        }
    }

    @Override
    @Cacheable(value={"FileServerCache#10"}, key="#root.methodName")
    public FileServer findDefault() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(FileServer::getIsdefault, (Object)1);
        wrapper.last("LIMIT 1");
        FileServer fileServer = (FileServer)this.getOne((Wrapper)wrapper);
        return fileServer;
    }

    @Override
    @Cacheable(value={"FileServerCache#10"}, key="#root.methodName+ '-' + #id")
    public FileServer findById(Integer id) {
        return (FileServer)this.getById(id);
    }

    @Override
    public String buildPreviewURL(Integer serverId, String objectName, Integer expires) throws Exception {
        String type;
        String previewURL = "";
        FileServer fileServer = (FileServer)this.getById(serverId);
        if (fileServer == null) {
            return previewURL;
        }
        switch (type = fileServer.getType().toLowerCase()) {
            case "share": {
                previewURL = this.shareFileService.buildPreviewURL(fileServer, objectName, expires);
                break;
            }
            case "minio": {
                previewURL = this.minIOFileService.buildPreviewURL(fileServer, objectName, expires);
                break;
            }
            case "obs": {
                previewURL = this.huWeiObsFileService.buildPreviewURL(fileServer, objectName, expires);
                break;
            }
        }
        return previewURL;
    }

    @Override
    public byte[] createThumail(Integer serverId, String objectName) throws Exception {
        String type;
        FileServer fileServer = (FileServer)this.getById(serverId);
        if (fileServer == null) {
            return new byte[0];
        }
        byte[] thumnailBytes = new byte[]{};
        switch (type = fileServer.getType().toLowerCase()) {
            case "share": {
                thumnailBytes = this.shareFileService.createThumbnail(fileServer, objectName);
                break;
            }
            case "minio": {
                thumnailBytes = this.minIOFileService.createThumbnail(fileServer, objectName);
                break;
            }
            case "obs": {
                thumnailBytes = this.huWeiObsFileService.createThumbnail(fileServer, objectName);
                break;
            }
        }
        return thumnailBytes;
    }

    @Override
    public FileDownloadMeta queryDownLoadMeta(Integer serverId, String objectName) throws Exception {
        FileServer fileServer = (FileServer)this.getById(serverId);
        if (fileServer == null) {
            return null;
        }
        return this.getFileDownloadMeta(objectName, fileServer);
    }

    @Override
    public FileDownloadMeta queryDownLoadMeta(String objectName) throws Exception {
        FileServer fileServer = this.findDefault();
        if (fileServer == null) {
            return null;
        }
        return this.getFileDownloadMeta(objectName, fileServer);
    }

    private FileDownloadMeta getFileDownloadMeta(String objectName, FileServer fileServer) throws Exception {
        String type;
        FileDownloadMeta fileDownloadMeta = null;
        switch (type = fileServer.getType().toLowerCase()) {
            case "share": {
                fileDownloadMeta = this.shareFileService.downLoadFile(fileServer, objectName);
                break;
            }
            case "minio": {
                fileDownloadMeta = this.minIOFileService.downLoadFile(fileServer, objectName);
                break;
            }
            case "obs": {
                fileDownloadMeta = this.huWeiObsFileService.downLoadFile(fileServer, objectName);
                break;
            }
        }
        return fileDownloadMeta;
    }

    @Override
    @CacheEvict(value={"FileServerCache#10"}, allEntries=true)
    public void deleteCache() {
    }

    @Override
    public FileServer saveOne(FileServer fileServer) {
        int hasDefault;
        if (fileServer.getId() == null || fileServer.getId() == 0) {
            int maxId = this.fileServerMapper.findMaxId();
            fileServer.setId(maxId + 1);
        }
        if ((hasDefault = this.fileServerMapper.hasDefault().intValue()) == 0) {
            fileServer.setIsdefault(1);
        }
        this.saveOrUpdate(fileServer);
        return fileServer;
    }

    @Override
    public void setDefault(Integer serverId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(FileServer::getIsdefault, (Object)0);
        this.update((Wrapper)wrapper);
        wrapper.clear();
        wrapper.eq(FileServer::getId, (Object)serverId);
        wrapper.set(FileServer::getIsdefault, (Object)1);
        this.update((Wrapper)wrapper);
    }
}

