/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.service.impl;

import cn.hutool.core.util.StrUtil;
import com.geoway.ns.sys.domain.FileServer;
import com.geoway.ns.sys.dto.FileDownloadMeta;
import com.geoway.ns.sys.dto.FileStoreMeta;
import com.geoway.ns.sys.service.HuWeiObsFileService;
import com.geoway.ns.sys.utils.ObjectKeyUtil;
import com.obs.services.ObsClient;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsBucket;
import com.obs.services.model.ObsObject;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.TemporarySignatureRequest;
import com.obs.services.model.TemporarySignatureResponse;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class HuweiObsFileServiceImpl
implements HuWeiObsFileService {
    private static final Logger log = LoggerFactory.getLogger(HuweiObsFileServiceImpl.class);
    @Value(value="${project.workDir:cache}")
    protected String workDir;
    @Autowired
    private RedisTemplate redisTemplate;
    private ObsClient _obsClient;
    private int _currentServerId = 0;

    @Override
    public ObsClient getOssClient(FileServer fileServer) throws Exception {
        if (fileServer == null) {
            return null;
        }
        String preKey = "fileServer-";
        boolean hasExist = this.redisTemplate.hasKey((Object)(preKey + fileServer.getId()));
        if (this._obsClient == null || !hasExist || fileServer.getId() != this._currentServerId) {
            this._currentServerId = fileServer.getId();
            this.redisTemplate.opsForValue().set((Object)(preKey + this._currentServerId), (Object)(this._currentServerId + ""), 10L, TimeUnit.MINUTES);
            this._obsClient = new ObsClient(fileServer.getEndpoint(), fileServer.getAppkey(), fileServer.getAppsecret());
        }
        return this._obsClient;
    }

    @Override
    public FileStoreMeta sendFile(FileServer fileServer, MultipartFile file, String objectName) throws Exception {
        ObsClient obsClient;
        boolean isExists;
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        String fileName = file.getOriginalFilename();
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        String bucket = fileServer.getBucket();
        if (StrUtil.isBlank((CharSequence)objectName)) {
            objectName = ObjectKeyUtil.formatObjectName(fileName);
        }
        if (!(isExists = (obsClient = this.getOssClient(fileServer)).headBucket(bucket))) {
            this.createBucket(obsClient, bucket, null);
        }
        obsClient.putObject(bucket, objectName, file.getInputStream());
        String url = fileServer.getEndpoint() + "/" + bucket + "/" + objectName;
        ObjectMetadata objMeta = obsClient.getObjectMetadata(bucket, objectName);
        fileStoreMeta.setAbsolutePath(url);
        fileStoreMeta.setRelPath(objectName);
        fileStoreMeta.setName(fileName);
        fileStoreMeta.setFileType(fileType);
        fileStoreMeta.setFileSize(objMeta.getContentLength());
        obsClient.close();
        return fileStoreMeta;
    }

    @Override
    public FileStoreMeta sendFile(FileServer fileServer, String fileName, String objectName) throws Exception {
        ObsClient obsClient;
        boolean isExists;
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        File file = new File(fileName);
        String shortName = file.getName();
        String fileType = shortName.substring(shortName.lastIndexOf(".") + 1);
        String bucket = fileServer.getBucket();
        if (StrUtil.isBlank((CharSequence)objectName)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String foldName = simpleDateFormat.format(new Date());
            objectName = foldName + "/" + System.currentTimeMillis() + "/" + shortName;
        }
        if (!(isExists = (obsClient = this.getOssClient(fileServer)).headBucket(bucket))) {
            this.createBucket(obsClient, bucket, null);
        }
        obsClient.putObject(bucket, objectName, file);
        obsClient.close();
        String url = fileServer.getEndpoint() + "/" + bucket + "/" + objectName;
        fileStoreMeta.setAbsolutePath(url);
        fileStoreMeta.setRelPath(objectName);
        fileStoreMeta.setName(shortName);
        fileStoreMeta.setFileType(fileType);
        fileStoreMeta.setFileSize(file.length());
        return fileStoreMeta;
    }

    @Override
    public FileStoreMeta buildThumbnailFile(FileServer fileServer, String objectName) throws Exception {
        String[] videoTypes;
        boolean videoFlag;
        String[] officeTypes;
        boolean officeFlag;
        boolean pdfFlag;
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        String fileType = objectName.substring(objectName.lastIndexOf(".") + 1).toLowerCase();
        String minObjectName = objectName.replace("." + fileType, "-min." + fileType);
        String fileName = minObjectName.substring(minObjectName.lastIndexOf("/") + 1);
        String thuamailFilePath = this.workDir + "/" + minObjectName;
        File thuamailFile = new File(thuamailFilePath);
        File pFile = thuamailFile.getParentFile();
        if (!pFile.exists()) {
            pFile.mkdirs();
        }
        String bucket = fileServer.getBucket();
        ObsClient obsClient = this.getOssClient(fileServer);
        ObsObject obsObject = obsClient.getObject(bucket, objectName);
        InputStream inputStream = obsObject.getObjectContent();
        inputStream.mark(0);
        String[] photoTypes = new String[]{"png", "jpg", "jpeg", "bmp"};
        boolean photoflag = Arrays.stream(photoTypes).anyMatch(type -> type.equalsIgnoreCase(fileType));
        if (photoflag) {
            int height;
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            int width = bufferedImage.getWidth();
            int max = width > (height = bufferedImage.getHeight()) ? width : height;
            int w = 0;
            int h = 0;
            if (max <= 100) {
                w = width;
                h = height;
            } else {
                double scale = 100.0 / (double)max;
                w = (int)((double)width * scale);
                h = (int)((double)height * scale);
            }
            inputStream.reset();
            Thumbnails.of((InputStream[])new InputStream[]{inputStream}).size(w, h).toFile(thuamailFile);
            obsObject.getObjectContent().close();
            obsClient.putObject(bucket, minObjectName, thuamailFile);
            inputStream.close();
            String url = fileServer.getEndpoint() + "/" + bucket + "/" + minObjectName;
            fileStoreMeta.setAbsolutePath(url);
            fileStoreMeta.setRelPath(objectName);
            fileStoreMeta.setName(thuamailFile.getName());
            fileStoreMeta.setFileSize(thuamailFile.length());
            fileStoreMeta.setFileType(fileType);
        }
        if (pdfFlag = "pdf".equalsIgnoreCase(fileType)) {
            // empty if block
        }
        if (officeFlag = Arrays.stream(officeTypes = new String[]{"doc", "docx", "xls", "xlsx", "ppt", "pptx"}).anyMatch(type -> type.equalsIgnoreCase(fileType))) {
            // empty if block
        }
        if (videoFlag = Arrays.stream(videoTypes = new String[]{"mp4", "avi"}).anyMatch(type -> type.equalsIgnoreCase(fileType))) {
            // empty if block
        }
        return fileStoreMeta;
    }

    @Override
    public void deleteFile(FileServer fileServer, String bucket, String path) throws Exception {
        ObsClient obsClient = this.getOssClient(fileServer);
        obsClient.deleteObject(bucket, path);
    }

    @Override
    public String buildPreviewURL(FileServer fileServer, String objectName, Integer expires) throws Exception {
        ObsClient obsClient = this.getOssClient(fileServer);
        TemporarySignatureRequest request = new TemporarySignatureRequest();
        request.setBucketName(fileServer.getBucket());
        request.setObjectKey(objectName);
        request.setRequestDate(new Date());
        request.setExpires((long)expires.intValue());
        TemporarySignatureResponse signature = obsClient.createTemporarySignature(request);
        String url = signature.getSignedUrl();
        return url;
    }

    @Override
    public byte[] createThumbnail(FileServer fileServer, String objectName) throws Exception {
        String bucket = fileServer.getBucket();
        ObsClient obsClient = this.getOssClient(fileServer);
        ObsObject obsObject = obsClient.getObject(bucket, objectName);
        InputStream inputStream = obsObject.getObjectContent();
        inputStream.mark(0);
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        int max = width > height ? width : height;
        int w = 0;
        int h = 0;
        if (max <= 100) {
            w = width;
            h = height;
        } else {
            double scale = 100.0 / (double)max;
            w = (int)((double)width * scale);
            h = (int)((double)height * scale);
        }
        inputStream.reset();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Thumbnails.of((InputStream[])new InputStream[]{inputStream}).size(w, h).toOutputStream((OutputStream)out);
        inputStream.close();
        byte[] thumnailBytes = out.toByteArray();
        out.close();
        return thumnailBytes;
    }

    @Override
    public FileDownloadMeta downLoadFile(FileServer fileServer, String objectName) throws Exception {
        FileDownloadMeta fileDownloadMeta = new FileDownloadMeta();
        ObsClient obsClient = this.getOssClient(fileServer);
        ObjectMetadata objectMetadata = obsClient.getObjectMetadata(fileServer.getBucket(), objectName);
        fileDownloadMeta.setFileSize(objectMetadata.getContentLength());
        ObsObject obsObject = obsClient.getObject(fileServer.getBucket(), objectName);
        fileDownloadMeta.setInputStream(obsObject.getObjectContent());
        return fileDownloadMeta;
    }

    private void createBucket(ObsClient obsClient, String bucketName, String location) {
        ObsBucket obsBucket = new ObsBucket();
        obsBucket.setBucketName(bucketName);
        obsBucket.setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
        obsBucket.setBucketStorageClass(StorageClassEnum.STANDARD);
        if (StrUtil.isNotBlank((CharSequence)location)) {
            obsBucket.setLocation(location);
        }
        obsClient.createBucket(obsBucket);
        String json = "{\"Statement\":[{\"Sid\":\"\u4e3a\u6388\u6743\u7528\u6237\u521b\u5efaOBS\u4f7f\u7528\u7684\u6876\u7b56\u7565\",\"Principal\":{\"ID\" : \"*\"},\"Effect\":\"Allow\",\"Action\":[\"GetObject\",\"GetObjectVersion\"],\"Resource\": [\"" + bucketName + "/*\"]}]}";
        obsClient.setBucketPolicy(bucketName, json);
    }
}

