/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.service.impl;

import cn.hutool.core.util.StrUtil;
import com.geoway.ns.sys.domain.FileServer;
import com.geoway.ns.sys.dto.FileDownloadMeta;
import com.geoway.ns.sys.dto.FileStoreMeta;
import com.geoway.ns.sys.service.MinIOFileService;
import com.geoway.ns.sys.utils.ObjectKeyUtil;
import io.minio.MinioClient;
import io.minio.ObjectStat;
import io.minio.policy.PolicyType;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.coobird.thumbnailator.Thumbnails;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MinIOFileServiceImpl
implements MinIOFileService {
    private static final Logger log = LoggerFactory.getLogger(MinIOFileServiceImpl.class);
    @Value(value="${project.workDir:cache}")
    protected String workDir;
    @Autowired
    private RedisTemplate redisTemplate;
    private MinioClient _minioClient;
    private int _currentServerId = 0;

    @Override
    public MinioClient getOssClient(FileServer fileServer) throws Exception {
        boolean secure = fileServer.getEndpoint() != null && fileServer.getEndpoint().startsWith("https://");
        MinioClient minioClient = new MinioClient(fileServer.getEndpoint(), 0, fileServer.getAppkey(), fileServer.getAppsecret(), null, secure, this.getUnsafeOkHttpClent());
        return minioClient;
    }

    @Override
    public FileStoreMeta sendFile(FileServer fileServer, MultipartFile file, String objectName) throws Exception {
        MinioClient minioClient;
        boolean isExists;
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        String fileName = file.getOriginalFilename();
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        String bucket = fileServer.getBucket();
        if (StrUtil.isBlank((CharSequence)objectName)) {
            objectName = ObjectKeyUtil.formatObjectName(fileName);
        }
        if (!(isExists = (minioClient = this.getOssClient(fileServer)).bucketExists(bucket))) {
            minioClient.makeBucket(bucket);
            minioClient.setBucketPolicy(bucket, "*", PolicyType.READ_WRITE);
        }
        minioClient.putObject(bucket, objectName, file.getInputStream(), file.getContentType());
        String url = minioClient.getObjectUrl(bucket, objectName);
        ObjectStat objMeta = minioClient.statObject(bucket, objectName);
        fileStoreMeta.setAbsolutePath(url);
        fileStoreMeta.setRelPath(objectName);
        fileStoreMeta.setName(fileName);
        fileStoreMeta.setFileSize(objMeta.length());
        fileStoreMeta.setFileType(fileType);
        fileStoreMeta.setPreviewURL(this.buildPreviewURL(fileServer, objectName, 30));
        return fileStoreMeta;
    }

    @Override
    public FileStoreMeta sendFile(FileServer fileServer, String fileName, String objectName) throws Exception {
        MinioClient minioClient;
        boolean isExists;
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        File file = new File(fileName);
        String shortName = file.getName();
        String fileType = shortName.substring(shortName.lastIndexOf(".") + 1);
        String bucket = fileServer.getBucket();
        if (StrUtil.isBlank((CharSequence)objectName)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String foldName = simpleDateFormat.format(new Date());
            objectName = foldName + "/" + System.currentTimeMillis() + "/" + fileName;
        }
        if (!(isExists = (minioClient = this.getOssClient(fileServer)).bucketExists(bucket))) {
            minioClient.makeBucket(bucket);
            minioClient.setBucketPolicy(bucket, "*", PolicyType.READ_WRITE);
        }
        minioClient.putObject(bucket, objectName, fileName);
        String url = minioClient.getObjectUrl(bucket, objectName);
        fileStoreMeta.setAbsolutePath(url);
        fileStoreMeta.setRelPath(objectName);
        fileStoreMeta.setName(shortName);
        fileStoreMeta.setFileSize(file.length());
        fileStoreMeta.setFileType(fileType);
        return fileStoreMeta;
    }

    @Override
    public FileStoreMeta buildThumbnailFile(FileServer fileServer, String objectName) throws Exception {
        String[] videoTypes;
        boolean videoFlag;
        String[] officeTypes;
        boolean officeFlag;
        boolean pdfFlag;
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        String fileType = objectName.substring(objectName.lastIndexOf(".") + 1).toLowerCase();
        String minObjectName = objectName.replace("." + fileType, "-min." + fileType);
        String fileName = minObjectName.substring(minObjectName.lastIndexOf("/") + 1);
        String bucket = fileServer.getBucket();
        MinioClient minioClient = this.getOssClient(fileServer);
        InputStream inputStream = minioClient.getObject(bucket, objectName);
        String[] photoTypes = new String[]{"png", "jpg", "jpeg", "bmp"};
        boolean photoflag = Arrays.stream(photoTypes).anyMatch(type -> type.equalsIgnoreCase(fileType));
        if (photoflag) {
            int height;
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            int width = bufferedImage.getWidth();
            int max = width > (height = bufferedImage.getHeight()) ? width : height;
            int w = 0;
            int h = 0;
            if (max <= 360) {
                w = width;
                h = height;
            } else {
                double scale = 360.0 / (double)max;
                w = (int)((double)width * scale);
                h = (int)((double)height * scale);
            }
            inputStream.close();
            inputStream = minioClient.getObject(bucket, objectName);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Thumbnails.of((InputStream[])new InputStream[]{inputStream}).size(w, h).toOutputStream((OutputStream)out);
            inputStream.close();
            byte[] thumbBytes = out.toByteArray();
            long fileSize = thumbBytes.length;
            ByteArrayInputStream byteStream = new ByteArrayInputStream(thumbBytes);
            minioClient.putObject(bucket, minObjectName, (InputStream)byteStream, null);
            ((InputStream)byteStream).close();
            out.close();
            String url = minioClient.getObjectUrl(bucket, objectName);
            fileStoreMeta.setAbsolutePath(url);
            fileStoreMeta.setRelPath(minObjectName);
            fileStoreMeta.setName(fileName);
            fileStoreMeta.setFileType(fileType);
        }
        if (pdfFlag = "pdf".equalsIgnoreCase(fileType)) {
            // empty if block
        }
        if (officeFlag = Arrays.stream(officeTypes = new String[]{"doc", "docx", "xls", "xlsx", "ppt", "pptx"}).anyMatch(type -> type.equalsIgnoreCase(fileType))) {
            // empty if block
        }
        if (videoFlag = Arrays.stream(videoTypes = new String[]{"mp4", "avi"}).anyMatch(type -> type.equalsIgnoreCase(fileType))) {
            // empty if block
        }
        return fileStoreMeta;
    }

    @Override
    public void deleteFile(FileServer fileServer, String bucket, String path) throws Exception {
        MinioClient minioClient = this.getOssClient(fileServer);
        minioClient.removeObject(bucket, path);
    }

    @Override
    public String buildPreviewURL(FileServer fileServer, String objectName, Integer expires) throws Exception {
        MinioClient minioClient = this.getOssClient(fileServer);
        ObjectStat objectStat = minioClient.statObject(fileServer.getBucket(), objectName);
        String url = minioClient.presignedGetObject(fileServer.getBucket(), objectName, expires);
        String contentType = objectStat.contentType();
        if (StrUtil.isNotBlank((CharSequence)contentType) && contentType.toLowerCase().contains("image")) {
            minioClient = new MinioClient(fileServer.getUrl(), fileServer.getAppkey(), fileServer.getAppsecret());
            url = minioClient.presignedGetObject(fileServer.getBucket(), objectName, expires);
        }
        return url;
    }

    @Override
    public byte[] createThumbnail(FileServer fileServer, String objectName) throws Exception {
        int height;
        String bucket = fileServer.getBucket();
        MinioClient minioClient = this.getOssClient(fileServer);
        InputStream inputStream = minioClient.getObject(bucket, objectName);
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        int width = bufferedImage.getWidth();
        int max = width > (height = bufferedImage.getHeight()) ? width : height;
        int w = 0;
        int h = 0;
        if (max <= 300) {
            w = width;
            h = height;
        } else {
            double scale = 300.0 / (double)max;
            w = (int)((double)width * scale);
            h = (int)((double)height * scale);
        }
        inputStream.close();
        inputStream = minioClient.getObject(bucket, objectName);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Thumbnails.of((InputStream[])new InputStream[]{inputStream}).size(w, h).toOutputStream((OutputStream)out);
        inputStream.close();
        byte[] thumnailBytes = out.toByteArray();
        out.close();
        return thumnailBytes;
    }

    @Override
    public FileDownloadMeta downLoadFile(FileServer fileServer, String objectName) throws Exception {
        FileDownloadMeta fileDownloadMeta = new FileDownloadMeta();
        MinioClient minioClient = this.getOssClient(fileServer);
        ObjectStat objStat = minioClient.statObject(fileServer.getBucket(), objectName);
        fileDownloadMeta.setFileSize(objStat.length());
        InputStream inputStream = minioClient.getObject(fileServer.getBucket(), objectName);
        fileDownloadMeta.setInputStream(inputStream);
        return fileDownloadMeta;
    }

    private OkHttpClient getUnsafeOkHttpClent() throws KeyManagementException {
        try {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.sslSocketFactory(SSLSocketClient.getSSLSocketFactory(), SSLSocketClient.getX509TrustManager());
            builder.hostnameVerifier(SSLSocketClient.getHostnameVerifier());
            return builder.build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class SSLSocketClient {
        public static SSLSocketFactory getSSLSocketFactory() {
            try {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, SSLSocketClient.getTrustManager(), new SecureRandom());
                return sslContext.getSocketFactory();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private static TrustManager[] getTrustManager() {
            return new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
        }

        public static HostnameVerifier getHostnameVerifier() {
            return (s, sslSession) -> true;
        }

        public static X509TrustManager getX509TrustManager() {
            X509TrustManager trustManager = null;
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
                Object[] trustManagers = trustManagerFactory.getTrustManagers();
                if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                    throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
                }
                trustManager = (X509TrustManager)trustManagers[0];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return trustManager;
        }
    }
}

