/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.ns.sys.domain.FileServer;
import com.geoway.ns.sys.dto.FileDownloadMeta;
import com.geoway.ns.sys.dto.FileStoreMeta;
import com.geoway.ns.sys.service.ShareFileService;
import com.geoway.ns.sys.utils.ObjectKeyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ShareFileServiceImpl
implements ShareFileService {
    private static final Logger log = LoggerFactory.getLogger(ShareFileServiceImpl.class);
    @Value(value="${project.workDir:cache}")
    protected String workDir;

    @Override
    public FileStoreMeta sendFile(FileServer fileServer, MultipartFile file, String objectName) throws IOException {
        String storeFilePath;
        File storeFile;
        File dir;
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        String fileName = file.getOriginalFilename();
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        String storePath = fileServer.getEndpoint();
        String bucket = fileServer.getBucket();
        if (StrUtil.isBlank((CharSequence)objectName)) {
            objectName = ObjectKeyUtil.formatObjectName(fileName);
        }
        if (!(dir = (storeFile = new File(storeFilePath = storePath + File.separator + bucket + File.separator + objectName)).getParentFile()).exists()) {
            if (dir.mkdirs()) {
                log.info("----\u521b\u5efa\u5171\u4eab\u6587\u4ef6\u5939\u76ee\u5f55\u6210\u529f----");
            } else {
                log.error("----\u521b\u5efa\u5171\u4eab\u6587\u4ef6\u5939\u76ee\u5f55\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01----");
            }
        }
        file.transferTo(storeFile);
        fileStoreMeta.setAbsolutePath(fileServer.getUrl() + "/" + objectName);
        fileStoreMeta.setRelPath(objectName);
        fileStoreMeta.setName(fileName);
        fileStoreMeta.setFileSize(storeFile.length());
        fileStoreMeta.setFileType(fileType);
        return fileStoreMeta;
    }

    @Override
    public FileStoreMeta buildThumbnailFile(FileServer fileServer, String objectName) throws IOException {
        String[] videoTypes;
        boolean videoFlag;
        String[] officeTypes;
        boolean officeFlag;
        boolean pdfFlag;
        FileStoreMeta fileStoreMeta = new FileStoreMeta();
        String storePath = fileServer.getEndpoint();
        String bucket = fileServer.getBucket();
        String storeFilePath = storePath + File.separator + bucket + File.separator + objectName;
        File file = new File(storeFilePath);
        String fileType = objectName.substring(objectName.lastIndexOf(".") + 1).toLowerCase();
        String[] photoTypes = new String[]{"png", "jpg", "jpeg", "bmp"};
        boolean photoflag = Arrays.stream(photoTypes).anyMatch(type -> type.equalsIgnoreCase(fileType));
        if (photoflag) {
            String minObjectName = objectName.replace("." + fileType, "-min." + fileType);
            String minFilePath = storePath + File.separator + bucket + File.separator + minObjectName;
            File thunmailFile = new File(minFilePath);
            Thumbnails.of((File[])new File[]{file}).scale(0.1).toFile(thunmailFile);
            fileStoreMeta.setAbsolutePath(fileServer.getUrl() + "/" + minObjectName);
            fileStoreMeta.setName(thunmailFile.getName());
            fileStoreMeta.setFileSize(thunmailFile.length());
            fileStoreMeta.setFileType(fileType);
            fileStoreMeta.setRelPath(minObjectName);
        }
        if (pdfFlag = "pdf".equalsIgnoreCase(fileType)) {
            // empty if block
        }
        if (officeFlag = Arrays.stream(officeTypes = new String[]{"doc", "docx", "xls", "xlsx", "ppt", "pptx"}).anyMatch(type -> type.equalsIgnoreCase(fileType))) {
            // empty if block
        }
        if (videoFlag = Arrays.stream(videoTypes = new String[]{"mp4", "avi"}).anyMatch(type -> type.equalsIgnoreCase(fileType))) {
            // empty if block
        }
        return fileStoreMeta;
    }

    @Override
    public void deleteFile(FileServer fileServer, String objectName) throws IOException {
        String storePath = fileServer.getEndpoint();
        String bucket = fileServer.getBucket();
        String storeFilePath = storePath + File.separator + bucket + File.separator + objectName;
        File file = new File(storeFilePath);
        file.delete();
    }

    @Override
    public String buildPreviewURL(FileServer fileServer, String objectName, Integer expires) throws Exception {
        String url = fileServer.getUrl() + "/" + objectName;
        return url;
    }

    @Override
    public byte[] createThumbnail(FileServer fileServer, String objectName) throws Exception {
        String storePath = fileServer.getEndpoint();
        String bucket = fileServer.getBucket();
        String storeFilePath = storePath + File.separator + bucket + File.separator + objectName;
        File file = new File(storeFilePath);
        String minFilePath = this.workDir + File.separator + objectName;
        File thunmailFile = new File(minFilePath);
        File pParentFile = thunmailFile.getParentFile();
        if (!pParentFile.exists()) {
            pParentFile.mkdirs();
        }
        Thumbnails.of((File[])new File[]{file}).scale(0.1).toFile(thunmailFile);
        byte[] thumnailBytes = FileUtil.readBytes((File)thunmailFile);
        thunmailFile.delete();
        return thumnailBytes;
    }

    @Override
    public FileDownloadMeta downLoadFile(FileServer fileServer, String objectName) throws Exception {
        FileDownloadMeta fileDownloadMeta = new FileDownloadMeta();
        String storePath = fileServer.getEndpoint();
        String bucket = fileServer.getBucket();
        String storeFilePath = storePath + File.separator + bucket + File.separator + objectName;
        File file = new File(storeFilePath);
        FileInputStream inputStream = new FileInputStream(file);
        fileDownloadMeta.setFileSize(file.length());
        fileDownloadMeta.setInputStream(inputStream);
        return fileDownloadMeta;
    }
}

