/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.sys.dto.SimpleRole;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.exception.TokenInvalidException;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.service.IUISConfigService;
import com.geoway.ns.sys.service.IUISRestAPIService;
import com.geoway.ns.sys.support.ServletUtils;
import com.geoway.ns.sys.utils.MyRequestUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
@Transactional
public class TokenServiceImpl
implements ITokenService {
    @Autowired
    IUISConfigService uisConfigService;
    @Qualifier(value="uisRestAPIServiceImpl")
    @Autowired
    IUISRestAPIService uisRestAPIService;

    @Override
    public SysUserDTO queryCurrentSysUser() throws Exception {
        String token = ServletUtils.getHeaderValues("access_token");
        if (StrUtil.isBlank((CharSequence)token)) {
            token = ServletUtils.getHeaderValues("access-token");
        }
        if (StrUtil.isBlank((CharSequence)token)) {
            token = ServletUtils.getParameter("token");
        }
        return this.querySysUserByToken(token);
    }

    @Override
    public String queryCurrentSysUserId() throws Exception {
        SysUserDTO userDTO = this.queryCurrentSysUser();
        return userDTO == null ? null : userDTO.getId();
    }

    @Override
    public SysUserDTO querySysUserByUserId(String token, String userId) throws Exception {
        if (token == null) {
            throw new TokenInvalidException();
        }
        SysUserDTO sysUser = this.queryUISSysUserByUserId(token, userId);
        return sysUser;
    }

    @Override
    public SysUserDTO querySysUserByToken(String token) throws Exception {
        if (token == null) {
            throw new TokenInvalidException();
        }
        SysUserDTO sysUser = this.queryUISSysUserByToken(token);
        return sysUser;
    }

    @Override
    public List<String> queryPermissionRoleId(String token) throws Exception {
        SysUserDTO sysUser = this.queryUISSysUserByToken(token);
        String roleIds = sysUser.getRoles().stream().map(SimpleRole::getId).collect(Collectors.joining(","));
        List<String> permissons = this.queryPermissionId(token, roleIds);
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        String menuId = request.getHeader("menuId");
        if (StrUtil.isNotEmpty((CharSequence)menuId)) {
            permissons = permissons.stream().map(f -> f + ";" + menuId).collect(Collectors.toList());
        }
        return permissons;
    }

    @Override
    public String getRoleIdsByToken(String token) throws Exception {
        String roleIds = "";
        if (StrUtil.isNotBlank((CharSequence)token)) {
            SysUserDTO sysUser = this.queryUISSysUserByToken(token);
            if (ObjectUtil.isEmpty((Object)sysUser) && StrUtil.isBlank((CharSequence)sysUser.getId())) {
                throw new Exception("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
            if ("admin".equals(sysUser.getUsername()) || "sysadmin".equals(sysUser.getUsername())) {
                return "all";
            }
            if (CollectionUtil.isEmpty(sysUser.getRoles())) {
                throw new Exception("\u7528\u6237\u65e0\u5bf9\u5e94\u7684\u89d2\u8272\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
            ArrayList<SimpleRole> simpleRoles = new ArrayList<SimpleRole>(sysUser.getRoles());
            long count = simpleRoles.stream().filter(simpleRole -> simpleRole.getLevel() == 0).count();
            if (count > 0L) {
                return "all";
            }
            roleIds = simpleRoles.stream().map(SimpleRole::getId).collect(Collectors.joining(","));
        }
        return roleIds;
    }

    @Override
    public List<SysUserDTO> getUserList(String token) throws Exception {
        ArrayList<SysUserDTO> lstUser = new ArrayList<SysUserDTO>();
        JSONObject resultObj = this.uisRestAPIService.getUserList(token);
        if (!"OK".equals(resultObj.getString("status"))) {
            throw new TokenInvalidException();
        }
        Object dataObject = resultObj.get((Object)"data");
        JSONArray userArray = null;
        userArray = dataObject instanceof JSONArray ? (JSONArray)dataObject : ((JSONObject)dataObject).getJSONArray("data");
        for (int i = 0; i < userArray.size(); ++i) {
            JSONObject userObj = userArray.getJSONObject(i);
            SysUserDTO simpleUser = new SysUserDTO();
            simpleUser.setId(userObj.getString("id"));
            simpleUser.setAlisname(userObj.getString("rname"));
            simpleUser.setEmail(userObj.getString("email"));
            simpleUser.setTel(userObj.getString("phone"));
            simpleUser.setUsername(userObj.getString("name"));
            lstUser.add(simpleUser);
        }
        return lstUser;
    }

    @Override
    public List<String> queryPermissionId(String token, String roleIds) throws Exception {
        ArrayList<String> permissionIds = new ArrayList<String>();
        JSONObject permissionObj = this.uisRestAPIService.getPermission(token, roleIds);
        JSONArray permissionArray = permissionObj.getJSONArray("data");
        for (int i = 0; i < permissionArray.size(); ++i) {
            JSONObject permissionJsonObj = permissionArray.getJSONObject(i);
            String permissionId = permissionJsonObj.getString("id");
            permissionIds.add(permissionId);
        }
        return permissionIds;
    }

    @Override
    public boolean isAdminRole(String role) {
        return role.equals("all");
    }

    @Override
    public String queryUserIdByRequest(HttpServletRequest request) throws Exception {
        SysUserDTO sysUser;
        String token = MyRequestUtil.queryAccessTokenInHeader(request);
        String userId = null;
        if (StrUtil.isNotBlank((CharSequence)token) && !"gtest".equals(token) && (sysUser = this.querySysUserByToken(token)) != null) {
            userId = sysUser.getId();
        }
        return userId;
    }

    private SysUserDTO queryUISSysUserByToken(String token) throws Exception {
        JSONObject userJSON = this.uisRestAPIService.getUserInfo(token);
        SysUserDTO user = this.parseUserJson(userJSON);
        return user;
    }

    private SysUserDTO queryUISSysUserByUserId(String token, String userId) throws Exception {
        JSONObject userJSON = this.uisRestAPIService.getUserById(token, userId);
        SysUserDTO user = this.parseUserJson(userJSON);
        return user;
    }

    private SysUserDTO parseUserJson(JSONObject userJSON) {
        SysUserDTO sysUser = new SysUserDTO();
        if (!"OK".equalsIgnoreCase(userJSON.getString("status"))) {
            System.out.println(userJSON);
        }
        JSONObject userObj = null;
        String version = this.uisConfigService.getVersion();
        String username = "";
        if (version.equals("2.0")) {
            userObj = userJSON.getJSONObject("data");
            username = userObj.getString("name");
        } else {
            userObj = userJSON.getJSONArray("data").getJSONObject(0);
            username = userObj.getString("username");
        }
        String rname = userObj.getString("rname");
        String userId = userObj.getString("id");
        String userXZQH = userObj.getString("regioncode");
        if (userObj.containsKey((Object)"regions")) {
            JSONArray dataArray = userObj.getJSONArray("regions");
            userXZQH = dataArray.stream().map(i -> ((JSONObject)i).getString("code")).collect(Collectors.joining(","));
        }
        String tel = userObj.getString("telphone");
        String email = userObj.getString("email");
        String orgCodes = userObj.getString("orgIds");
        sysUser.setId(userId);
        sysUser.setUsername(username);
        sysUser.setAlisname(rname);
        sysUser.setXzqdm(userXZQH);
        sysUser.setDeptId(orgCodes);
        sysUser.setTel(tel);
        sysUser.setEmail(email);
        HashSet<SimpleRole> roles = new HashSet<SimpleRole>();
        JSONArray roleArray = new JSONArray();
        roleArray = userObj.containsKey((Object)"roles") ? userObj.getJSONArray("roles") : this.getLeafOrg(userObj.getJSONArray("organizations"), 4);
        if (userObj.containsKey((Object)"organizations")) {
            JSONArray orgArray = userObj.getJSONArray("organizations");
            String deptName = orgArray.stream().map(f -> ((JSONObject)f).getString("name")).collect(Collectors.joining(","));
            sysUser.setDeptName(deptName);
        }
        for (int i2 = 0; i2 < roleArray.size(); ++i2) {
            JSONObject roleJsonObj = roleArray.getJSONObject(i2);
            String id = roleJsonObj.getString("id");
            String name = roleJsonObj.getString("name");
            if (StringUtils.isBlank((CharSequence)name)) {
                name = roleJsonObj.getString("rolename");
            }
            SimpleRole simpleRole = new SimpleRole();
            simpleRole.setId(id);
            simpleRole.setRolename(name);
            simpleRole.setLevel(1);
            simpleRole.setState(1);
            roles.add(simpleRole);
        }
        sysUser.setRoles(roles);
        return sysUser;
    }

    private JSONArray getLeafOrg(JSONArray data, int mLevel) {
        JSONArray result = new JSONArray();
        if (mLevel < 1) {
            return result;
        }
        for (int i = 0; i < data.size(); ++i) {
            JSONObject item = data.getJSONObject(i);
            if (item.getInteger("level") != mLevel) continue;
            result.add((Object)data.getJSONObject(i));
        }
        if (result.size() == 0) {
            return this.getLeafOrg(data, mLevel - 1);
        }
        return result;
    }
}

