/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.service.impl;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.sys.service.IUISConfigService;
import com.geoway.ns.sys.service.IUISRestAPIService;
import com.geoway.ns.sys.support.AESECB;
import com.geoway.ns.sys.utils.Md5Utils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uisRestAPIServiceImpl")
public class UISRestAPIServiceImpl
implements IUISRestAPIService {
    @Autowired
    IUISConfigService uisConfigService;

    @Override
    public JSONObject getUserInfo(String token) throws Exception {
        String api = "/rest/user/getUserInfo";
        JSONObject postParam = new JSONObject();
        postParam.put("token", (Object)token);
        return this.postUISApi(api, postParam, token);
    }

    @Override
    public JSONObject getUserById(String token, String userId) throws Exception {
        String api = "/rest/user/getUserInfo";
        JSONObject postParam = new JSONObject();
        postParam.put("token", (Object)token);
        postParam.put("userId", (Object)userId);
        return this.postUISApi(api, postParam, token);
    }

    @Override
    public JSONObject getSimpleUserInfo(String token, String username) throws Exception {
        String api = "/rest/user/getSimpleUserInfo";
        JSONObject postParam = new JSONObject();
        postParam.put("token", (Object)token);
        postParam.put("username", (Object)username);
        return this.postUISApi(api, postParam, token);
    }

    @Override
    public JSONObject getUserList(String token) throws Exception {
        String api = "/rest/user/getUserList";
        JSONObject postParam = new JSONObject();
        postParam.put("token", (Object)token);
        postParam.put("pageIndex", (Object)1);
        postParam.put("pageSize", (Object)Integer.MAX_VALUE);
        return this.postUISApi(api, postParam, token);
    }

    @Override
    public JSONObject getOrgTree(String pid, String recursive, String token) throws Exception {
        String api = "/rest/org/getOrgTree";
        JSONObject postParam = new JSONObject();
        postParam.put("pid", (Object)pid);
        postParam.put("recursive", (Object)recursive);
        postParam.put("token", (Object)token);
        return this.postUISApi(api, postParam, token);
    }

    @Override
    public JSONObject getOrgInfo(String id, String recursive, String username, String token) throws Exception {
        String api = "/rest/org/getOrgInfo";
        JSONObject postParam = new JSONObject();
        postParam.put("id", (Object)id);
        postParam.put("recursive", (Object)recursive);
        postParam.put("token", (Object)token);
        postParam.put("username", (Object)username);
        return this.postUISApi(api, postParam, token);
    }

    @Override
    public JSONObject modifyUserPwd(String username, String id, String password, String token) throws Exception {
        String api = "/rest/user/modify";
        JSONObject postParam = new JSONObject();
        JSONObject userJson = new JSONObject();
        userJson.put("id", (Object)id);
        userJson.put("username", (Object)username);
        userJson.put("password", (Object)password);
        postParam.put("user", (Object)userJson);
        postParam.put("token", (Object)token);
        return this.postUISApi(api, postParam, token);
    }

    @Override
    public JSONObject getRoleTree(String token, String filterParam) throws Exception {
        String api = "/rest/role/queryTree";
        JSONObject postParam = new JSONObject();
        postParam.put("filterParam", (Object)filterParam);
        postParam.put("token", (Object)token);
        return this.postUISApi(api, postParam, token);
    }

    @Override
    public JSONObject getPermission(String token, String roleIds) throws Exception {
        String api = "/rest/role/permissions";
        JSONObject postParam = new JSONObject();
        postParam.put("roleIds", (Object)roleIds);
        postParam.put("token", (Object)token);
        return this.postUISApi(api, postParam, token);
    }

    private JSONObject postUISApi(String api, JSONObject postParam, String token) throws Exception {
        String url = this.uisConfigService.getUISURL() + api;
        String appkey = this.uisConfigService.getAppkey();
        String appsecret = this.uisConfigService.getAppsecret();
        String timestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        url = String.format("%s?appkey=%s&timestamp=%s&token=%s", url, appkey, timestamp, token);
        String appsecretMd5 = Md5Utils.getMD5Str16(appsecret, "utf-8");
        String sign = null;
        try {
            sign = AESECB.encrypt(appsecretMd5, url);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        url = String.format("%s&sign=%s", url, sign);
        JSONObject realPostParam = new JSONObject();
        realPostParam.put("appkey", (Object)appkey);
        realPostParam.put("timestamp", (Object)timestamp);
        realPostParam.put("sign", (Object)sign);
        if (postParam != null) {
            for (String key : postParam.keySet()) {
                realPostParam.put(key, postParam.get((Object)key));
            }
        }
        String result = ((HttpRequest)((HttpRequest)HttpRequest.post((String)url).header("access_token", token)).body(realPostParam.toJSONString()).contentType("application/json").charset(CharsetUtil.CHARSET_UTF_8)).execute().body();
        return JSONObject.parseObject((String)result);
    }
}

