/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.support.query;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Configuration;
import org.springframework.format.annotation.DateTimeFormat;

@Configuration
public class MPJQueryMapperUtil<T> {
    public MPJLambdaWrapper<T> queryMapper(String filterParams, String sortParams, Class entityClass) throws Exception {
        MPJLambdaWrapper<T> queryWrapper = this.queryMapper(filterParams, entityClass);
        if (StrUtil.isNotEmpty((CharSequence)sortParams)) {
            String[] sortParamArr;
            for (String sortParam : sortParamArr = sortParams.split(";")) {
                String[] sortCondition = sortParam.split("_");
                String sortFieldName = sortCondition[1];
                String sortType = sortCondition[2];
                Field field = entityClass.getDeclaredField(sortFieldName);
                String fieldName = this.findTableFiled(field);
                String column = queryWrapper.getAlias() + "." + fieldName;
                if ("desc".equalsIgnoreCase(sortType)) {
                    queryWrapper.orderByDesc((Object)column);
                    continue;
                }
                queryWrapper.orderByAsc((Object)column);
            }
        }
        return queryWrapper;
    }

    public MPJLambdaWrapper<T> queryMapper(String filterParams, Class entityClass) throws Exception {
        MPJLambdaWrapper queryWrapper = new MPJLambdaWrapper();
        if (StrUtil.isEmpty((CharSequence)filterParams)) {
            return queryWrapper;
        }
        try {
            String[] filtersSplit;
            for (String filterParam : filtersSplit = filterParams.split(";")) {
                boolean isOldFilter;
                boolean bl = isOldFilter = filterParam.startsWith("Q_") || filterParam.startsWith("QOR_");
                if (isOldFilter) {
                    this.buildMybatisQuery2(filterParam, queryWrapper, entityClass);
                    continue;
                }
                this.buildMybatisQuery(filterParam, queryWrapper, entityClass);
            }
            return queryWrapper;
        }
        catch (Exception e) {
            e.printStackTrace();
            return queryWrapper;
        }
    }

    private void buildMybatisQuery(String filterParam, MPJLambdaWrapper<T> queryWrapper, Class entityClass) throws Exception {
        if ("OR".equalsIgnoreCase(filterParam)) {
            queryWrapper.or();
            return;
        }
        String[] filters = filterParam.split("_");
        if (filters.length < 3) {
            return;
        }
        Field field = entityClass.getDeclaredField(filters[0]);
        String fieldName = this.findTableFiled(field);
        String column = queryWrapper.getAlias() + "." + fieldName;
        String type = filters[1];
        String value1 = null;
        String value2 = null;
        if (filters.length >= 3) {
            value1 = filters[2];
        }
        if (filters.length >= 4) {
            value2 = filters[3];
        }
        List result1 = value1;
        Object result2 = value2;
        if (!type.contains("IN")) {
            result1 = this.valueOfType(field, value1);
            result2 = this.valueOfType(field, value2);
        } else {
            result1 = Arrays.stream(value1.split(",")).map(f -> this.valueOfType(field, (String)f)).collect(Collectors.toList());
        }
        this.buildQueryWrapper(queryWrapper, column, type, result1, result2);
    }

    private void buildMybatisQuery2(String filterParam, MPJLambdaWrapper<T> queryWrapper, Class entityClass) throws Exception {
        if ("OR".equalsIgnoreCase(filterParam)) {
            queryWrapper.or();
            return;
        }
        String[] paramValPair = filterParam.split("=");
        if (paramValPair.length < 2) {
            return;
        }
        String parseParam = paramValPair[0];
        String parseValue = paramValPair[1];
        String[] filters = parseParam.split("_");
        if (filters.length < 4) {
            return;
        }
        Field field = entityClass.getDeclaredField(filters[1]);
        String fieldName = this.findTableFiled(field);
        String column = queryWrapper.getAlias() + "." + fieldName;
        String type = filters[3];
        String[] values = parseValue.split("_");
        String value1 = null;
        String value2 = null;
        if (values.length >= 1) {
            value1 = values[0];
        }
        if (values.length >= 2) {
            value2 = values[1];
        }
        List result1 = value1;
        Object result2 = value2;
        if (!type.contains("IN")) {
            result1 = this.valueOfType(field, value1);
            result2 = this.valueOfType(field, value2);
        } else {
            result1 = Arrays.stream(value1.split(",")).map(f -> this.valueOfType(field, (String)f)).collect(Collectors.toList());
        }
        this.buildQueryWrapper(queryWrapper, column, type, result1, result2);
        if ("QOR".equalsIgnoreCase(filters[0])) {
            queryWrapper.or();
        }
    }

    private MPJLambdaWrapper<T> buildQueryWrapper(MPJLambdaWrapper<T> queryWrapper, String column, String type, Object result1, Object result2) {
        switch (type) {
            case "EQ": {
                queryWrapper.eq((Object)column, result1);
                break;
            }
            case "NE": {
                queryWrapper.ne((Object)column, result1);
                break;
            }
            case "GT": {
                queryWrapper.gt((Object)column, result1);
                break;
            }
            case "GE": {
                queryWrapper.ge((Object)column, result1);
                break;
            }
            case "LT": {
                queryWrapper.lt((Object)column, result1);
                break;
            }
            case "LE": {
                queryWrapper.le((Object)column, result1);
                break;
            }
            case "BTW": 
            case "BETWEEN": {
                queryWrapper.between((Object)column, result1, result2);
                break;
            }
            case "NOTBETWEEN": {
                queryWrapper.notBetween((Object)column, result1, result2);
                break;
            }
            case "LK": 
            case "LIKE": {
                queryWrapper.like((Object)column, result1);
                break;
            }
            case "NLK": 
            case "NOTLIKE": {
                queryWrapper.notLike((Object)column, result1);
                break;
            }
            case "LFK": 
            case "LIKELEFT": {
                queryWrapper.likeLeft((Object)column, result1);
                break;
            }
            case "RHK": 
            case "LIKERIGHT": {
                queryWrapper.likeRight((Object)column, result1);
                break;
            }
            case "ISNULL": {
                queryWrapper.isNull((Object)column);
                break;
            }
            case "ISNOTNULL": {
                queryWrapper.isNotNull((Object)column);
                break;
            }
            case "IN": {
                queryWrapper.in((Object)column, ((List)result1).toArray());
                break;
            }
            case "NOTIN": {
                queryWrapper.notIn((Object)column, ((List)result1).toArray());
                break;
            }
        }
        return queryWrapper;
    }

    private Object valueOfType(Field field, String value) {
        try {
            String valueType = field.getType().getName();
            Object result = value;
            if (value != null) {
                block19 : switch (valueType) {
                    case "java.lang.String": {
                        return result;
                    }
                    case "java.lang.int": 
                    case "java.lang.Integer": {
                        result = Integer.parseInt(value);
                        break;
                    }
                    case "java.lang.long": 
                    case "java.lang.Long": {
                        result = Long.parseLong(value);
                        break;
                    }
                    case "java.lang.short": 
                    case "java.lang.Short": {
                        result = Short.parseShort(value);
                        break;
                    }
                    case "java.lang.double": 
                    case "java.lang.Double": {
                        result = Double.parseDouble(value);
                        break;
                    }
                    case "java.lang.float": 
                    case "java.lang.Float": {
                        result = Float.valueOf(Float.parseFloat(value));
                        break;
                    }
                    case "java.lang.byte": 
                    case "java.lang.Byte": {
                        result = Byte.parseByte(value);
                        break;
                    }
                    case "java.lang.Boolean": 
                    case "java.lang.boolean": {
                        result = Boolean.parseBoolean(value);
                        break;
                    }
                    case "java.util.Date": {
                        String dateType = "yyyy-MM-dd HH:mm:ss";
                        boolean isTableField = field.isAnnotationPresent(DateTimeFormat.class);
                        if (isTableField) {
                            DateTimeFormat tableField = field.getAnnotation(DateTimeFormat.class);
                            dateType = tableField.pattern();
                        }
                        switch (dateType) {
                            case "yyyy-MM-dd HH:mm:ss": {
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                result = sdf.parse(value);
                                break block19;
                            }
                            case "yyyy-MM-dd": {
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                                result = sdf.parse(value);
                                break block19;
                            }
                            case "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2": {
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2");
                                result = sdf.parse(value);
                                break block19;
                            }
                            case "yyyy\u5e74MM\u6708dd\u65e5": {
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
                                result = sdf.parse(value);
                                break block19;
                            }
                        }
                        break;
                    }
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String findTableFiled(Field field) {
        String fieldValue = null;
        boolean isTableField = field.isAnnotationPresent(TableField.class);
        boolean isTableId = field.isAnnotationPresent(TableId.class);
        if (isTableField) {
            TableField tableField = field.getAnnotation(TableField.class);
            fieldValue = tableField.value();
        }
        if (isTableId) {
            TableId tableId = field.getAnnotation(TableId.class);
            fieldValue = tableId.value();
        }
        return fieldValue;
    }

    public Class<T> getTClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }
}

