/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.utils;

import com.alibaba.fastjson.JSON;
import com.geoway.ns.sys.dto.EsEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EsUtil {
    private static final Logger log = LoggerFactory.getLogger(EsUtil.class);
    @Value(value="${es.host:}")
    public String host;
    @Value(value="${es.port:}")
    public String port;
    @Value(value="${es.scheme:}")
    public String scheme;
    @Value(value="${es.enable:false}")
    public Boolean enabled;
    @Value(value="${es.username:}")
    public String USERNAME;
    @Value(value="${es.password:}")
    public String PASSWORD;
    public static final String INDEX_NAME = "book-index";
    public static final String CREATE_INDEX = "{\n    \"properties\": {\n      \"id\":{\n        \"type\":\"integer\"\n      },\n      \"userId\":{\n        \"type\":\"integer\"\n      },\n      \"name\":{\n        \"type\":\"text\",\n        \"analyzer\": \"ik_max_word\",\n        \"search_analyzer\": \"ik_smart\"\n      },\n      \"url\":{\n        \"type\":\"text\",\n        \"index\": true,\n        \"analyzer\": \"ik_max_word\",\n        \"search_analyzer\": \"ik_smart\"\n      }\n    }\n  }";
    protected RestHighLevelClient client = null;

    @PostConstruct
    public void initClient() {
        try {
            if (this.enabled.booleanValue()) {
                if (this.client != null) {
                    this.client.close();
                }
                String[] ports = this.port.split(",");
                HttpHost[] httpHosts = new HttpHost[ports.length];
                for (int i = 0; i < ports.length; ++i) {
                    httpHosts[i] = new HttpHost(this.host, Integer.parseInt(ports[i]), this.scheme);
                }
                RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts);
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.USERNAME, this.PASSWORD));
                builder.setHttpClientConfigCallback(arg_0 -> EsUtil.lambda$initClient$0((CredentialsProvider)credentialsProvider, arg_0));
                this.client = new RestHighLevelClient(builder);
                log.info(this.cilentExist() ? "{}:ElasticSearch\u7ec4\u4ef6\u52a0\u8f7d\u6210\u529f\uff01" : "{}:ElasticSearch\u7ec4\u4ef6\u52a0\u8f7d\u5931\u8d25\uff01", (Object)new Date());
            } else {
                log.info("{}:ElasticSearch\u7ec4\u4ef6\u672a\u542f\u7528\uff01", (Object)new Date());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insertOrUpdateOne(String index, EsEntity entity) {
        IndexRequest request = new IndexRequest(index);
        request.id(entity.getId());
        request.source(JSON.toJSONString(entity.getData()), XContentType.JSON);
        try {
            this.client.index(request, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void insertBatch(String index, List<EsEntity> list) {
        BulkRequest request = new BulkRequest();
        list.forEach(item -> request.add(new IndexRequest(index).id(item.getId()).source(JSON.toJSONString(item.getData()), XContentType.JSON)));
        try {
            this.client.bulk(request, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void deleteBatch(String index, Collection<T> idList) {
        BulkRequest request = new BulkRequest();
        idList.forEach(item -> request.add(new DeleteRequest(index, item.toString())));
        try {
            this.client.bulk(request, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> List<T> search(String index, SearchSourceBuilder builder, Class<T> c) {
        SearchRequest request = new SearchRequest(new String[]{index});
        request.source(builder);
        try {
            SearchResponse response = this.client.search(request, RequestOptions.DEFAULT);
            SearchHit[] hits = response.getHits().getHits();
            ArrayList<Object> res = new ArrayList<Object>(hits.length);
            for (SearchHit hit : hits) {
                res.add(JSON.parseObject((String)hit.getSourceAsString(), c));
            }
            return res;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteIndex(String index) {
        try {
            this.client.indices().delete(new DeleteIndexRequest(index), RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteByQuery(String index, QueryBuilder builder) {
        DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{index});
        request.setQuery(builder);
        request.setBatchSize(10000);
        request.setConflicts("proceed");
        try {
            this.client.deleteByQuery(request, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void initIndex() {
        try {
            if (this.indexExist(INDEX_NAME)) {
                return;
            }
            CreateIndexRequest request = new CreateIndexRequest(INDEX_NAME);
            request.settings(Settings.builder().put("index.number_of_shards", 3).put("index.number_of_replicas", 2));
            request.mapping(CREATE_INDEX, XContentType.JSON);
            CreateIndexResponse res = this.client.indices().create(request, RequestOptions.DEFAULT);
            if (!res.isAcknowledged()) {
                throw new RuntimeException("\u521d\u59cb\u5316\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public boolean indexExist(String index) throws Exception {
        GetIndexRequest request = new GetIndexRequest(new String[]{index});
        request.local(false);
        request.humanReadable(true);
        request.includeDefaults(false);
        return this.client.indices().exists(request, RequestOptions.DEFAULT);
    }

    public boolean cilentExist() {
        return this.client != null;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$initClient$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder f) {
        return f.setDefaultCredentialsProvider(credentialsProvider);
    }
}

