/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;

public class UpAndDownloadUtil {
    public static void dowmloadDirectory(HttpServletResponse response, String directoryPath) throws Exception {
        try {
            File fileDirectory = new File(directoryPath);
            if (!fileDirectory.exists()) {
                throw new Exception("\u4e0b\u8f7d\u76ee\u5f55\u4e0d\u5b58\u5728");
            }
            File zipFile = new File(fileDirectory.getParentFile().getAbsolutePath(), fileDirectory.getName() + ".zip");
            if (zipFile.exists()) {
                zipFile.delete();
            }
            UpAndDownloadUtil.zipFile(directoryPath, zipFile.getAbsolutePath());
            UpAndDownloadUtil.downloadFile(response, zipFile.getAbsolutePath());
            zipFile.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(HttpServletResponse response, String filePath) throws Exception {
        block24: {
            try {
                if (!StringUtils.isEmpty((Object)filePath)) {
                    File file = new File(filePath);
                    if (file.exists()) {
                        String fileName = file.getName();
                        String encodeFileName = URLEncoder.encode(fileName, "UTF-8");
                        response.setContentType("application/octet-stream");
                        response.setHeader("content-type", "application/octet-stream");
                        String contentDisposition = "attachment;fileName=" + encodeFileName;
                        response.setHeader("Content-Disposition", contentDisposition);
                        response.setCharacterEncoding("UTF-8");
                        response.setHeader("Pragma", "No-cache");
                        response.setHeader("Cache-Control", "No-cache");
                        response.setDateHeader("Expires", 0L);
                        byte[] buffer = new byte[1024];
                        FileInputStream fis = null;
                        BufferedInputStream bis = null;
                        try {
                            fis = new FileInputStream(file);
                            bis = new BufferedInputStream(fis);
                            ServletOutputStream os = response.getOutputStream();
                            int i = bis.read(buffer);
                            while (i != -1) {
                                os.write(buffer, 0, i);
                                i = bis.read(buffer);
                            }
                            break block24;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            break block24;
                        }
                        finally {
                            if (bis != null) {
                                try {
                                    bis.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    throw new Exception("\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728");
                }
                throw new Exception("\u4e0b\u8f7d\u6587\u4ef6\u4e3a\u7a7a");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    public static void zipFile(String directoryPath, String zipPath) throws IOException {
        FileOutputStream fos = new FileOutputStream(zipPath);
        ZipOutputStream zipOut = new ZipOutputStream(fos);
        File fileToZip = new File(directoryPath);
        UpAndDownloadUtil.zipFile(fileToZip, fileToZip.getName(), zipOut);
        zipOut.close();
        fos.close();
    }

    public static void zipFile(List<File> files, ZipOutputStream outputStream) throws IOException {
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            File file = files.get(i);
            UpAndDownloadUtil.zipFile(file, file.getName(), outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes4File(String filePath) throws IOException {
        FileInputStream in = null;
        BufferedInputStream buffer = null;
        FilterInputStream dataIn = null;
        ByteArrayOutputStream bos = null;
        FilterOutputStream dos = null;
        byte[] bArray = null;
        try {
            int len;
            in = new FileInputStream(filePath);
            buffer = new BufferedInputStream(in);
            dataIn = new DataInputStream(buffer);
            bos = new ByteArrayOutputStream();
            dos = new DataOutputStream(bos);
            byte[] buf = new byte[1024];
            while ((len = ((DataInputStream)dataIn).read(buf)) >= 0) {
                ((DataOutputStream)dos).write(buf, 0, len);
            }
            bArray = bos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (dataIn != null) {
                dataIn.close();
            }
            if (buffer != null) {
                buffer.close();
            }
            if (bos != null) {
                bos.close();
            }
            if (dos != null) {
                dos.close();
            }
        }
        return bArray;
    }

    private static void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        int length;
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            File[] children;
            if (fileName.endsWith("/")) {
                zipOut.putNextEntry(new ZipEntry(fileName));
                zipOut.closeEntry();
            } else {
                zipOut.putNextEntry(new ZipEntry(fileName + "/"));
                zipOut.closeEntry();
            }
            for (File childFile : children = fileToZip.listFiles()) {
                UpAndDownloadUtil.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut);
            }
            return;
        }
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }
}

