/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.controller;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.ns.sys.dto.RestResult;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.support.ServletUtils;
import com.geoway.ns.sys.support.query.MyQueryMapperUtil;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public class BaseController<T, S extends IService<T>> {
    protected final S service;
    protected final MyQueryMapperUtil<T> qmu;
    @Autowired
    protected ITokenService tokenService;

    public BaseController(S s, T t) {
        this.service = s;
        this.qmu = new MyQueryMapperUtil<T>(t);
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u5185\u5bb9")
    @GetMapping(value={"/{id}"})
    public RestResult<T> queryById(@PathVariable String id) throws Exception {
        return RestResult.success(this.service.getById((Serializable)((Object)id)));
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u83b7\u53d6\u5355\u4e2a\u5185\u5bb9")
    @GetMapping(value={"/filter"})
    public RestResult<T> queryByFilter(String filterParam) throws Exception {
        QueryWrapper<T> wrapper = this.getWrapper(filterParam);
        wrapper.last("limit 1");
        return RestResult.success(this.service.getOne(wrapper));
    }

    @ApiOperation(value="\u83b7\u53d6\u5217\u8868")
    @GetMapping(value={"/list"})
    public RestResult<List<T>> queryList(String filterParam, String sortParam) throws Exception {
        QueryWrapper<T> wrapper = this.getWrapper(filterParam, sortParam);
        return RestResult.success(this.service.list(wrapper));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/page"})
    public RestResult<IPage<T>> queryList(String filterParam, String sortParam, Integer page, Integer size) throws Exception {
        QueryWrapper<T> wrapper = this.getWrapper(filterParam, sortParam);
        Page pages = new Page((long)page.intValue(), (long)size.intValue());
        return RestResult.success(this.service.page((IPage)pages, wrapper));
    }

    @ApiOperation(value="\u6839\u636eid\u4fdd\u5b58\u6216\u66f4\u65b0")
    @PostMapping(value={"/saveOrUpdate"})
    @Transactional(rollbackFor={Exception.class})
    public RestResult<String> saveOrUpdate(@RequestBody T t) throws Exception {
        this.service.saveOrUpdate(t);
        Map map = BeanUtil.beanToMap(t, (String[])new String[0]);
        return RestResult.success(map.get("id").toString());
    }

    @ApiOperation(value="\u6839\u636eid\u6279\u91cf\u4fdd\u5b58\u6216\u66f4\u65b0")
    @PostMapping(value={"/saveOrUpdateBatch"})
    public RestResult<String> saveOrUpdateBatch(@RequestParam(name="keepUp", defaultValue="true") Boolean keepUp, @RequestBody List<T> ts) throws Exception {
        StringBuilder sbr = new StringBuilder();
        for (T t : ts) {
            try {
                this.service.saveOrUpdate(t);
            }
            catch (Exception e) {
                if (!keepUp.booleanValue()) {
                    throw e;
                }
                sbr.append(e.getMessage() + "; ");
            }
        }
        return sbr.length() > 1 ? RestResult.error(sbr.toString()) : RestResult.success("\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE, RequestMethod.POST})
    @Transactional(rollbackFor={Exception.class})
    public RestResult<String> delete(@PathVariable String id) throws Exception {
        this.service.removeById((Serializable)((Object)id));
        return RestResult.success("\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6839\u636eids\u6279\u91cf\u5220\u9664")
    @RequestMapping(value={"/deleteByIds"}, method={RequestMethod.DELETE, RequestMethod.POST})
    @Transactional(rollbackFor={Exception.class})
    public RestResult<String> deleteBatch(@RequestParam String ids) throws Exception {
        this.service.removeBatchByIds(Arrays.asList(ids.split(",")));
        return RestResult.success("\u5220\u9664\u6210\u529f\uff01");
    }

    private QueryWrapper<T> getWrapper(String filterParam, String sortParam) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)filterParam) && StringUtils.isNotBlank((CharSequence)sortParam)) {
            return this.qmu.queryMapper(filterParam, sortParam);
        }
        if (StringUtils.isNotBlank((CharSequence)filterParam)) {
            return this.qmu.queryMapper(filterParam);
        }
        if (StringUtils.isNotBlank((CharSequence)sortParam)) {
            return this.qmu.queryMapperSort(sortParam);
        }
        return new QueryWrapper();
    }

    private QueryWrapper<T> getWrapper(String filterParam) throws Exception {
        return this.qmu.queryMapper(filterParam);
    }

    protected String getUserId() throws Exception {
        String userId = this.tokenService.queryCurrentSysUserId();
        String token = ServletUtils.getHeaderValues("access_token");
        if (StringUtils.isNotEmpty((CharSequence)token) && token.equalsIgnoreCase("Geoway")) {
            return "sys_user";
        }
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)userId), (String)"\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u767b\u5f55\u4fe1\u606f\uff01");
        return userId;
    }
}

