/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConfigurationProperties(prefix="cors.allowed")
public class CorsProperties {
    private List<String> origins;
    private String methods;
    private String headers;
    private boolean credentials;
    private long maxAge;

    public CorsProperties() {
        try {
            PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
            Resource[] resources = pathMatchingResourcePatternResolver.getResources("classpath*:cors.yml");
            this.setOrigins(this.getPropertiesList("cors.allowed.origins", resources));
            this.setMethods(this.getPropertiesString("cors.allowed.methods", resources));
            this.setCredentials(this.getPropertiesString("cors.allowed.credentials", resources) == "true");
            this.setHeaders(this.getPropertiesString("cors.allowed.headers", resources));
            this.setMaxAge(Integer.parseInt(this.getPropertiesString("cors.allowed.max-age", resources)));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private String getPropertiesString(String key, Resource ... resources) {
        for (Resource resource : resources) {
            Properties properties = this.loadYamlProperties(resource);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String tmpKey = StringUtils.substringBefore((String)entry.getKey().toString(), (String)"[");
                if (!tmpKey.equalsIgnoreCase(key)) continue;
                return entry.getValue().toString();
            }
        }
        return null;
    }

    private List<String> getPropertiesList(String key, Resource ... resources) {
        ArrayList<String> list = new ArrayList<String>();
        for (Resource resource : resources) {
            Properties properties = this.loadYamlProperties(resource);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String tmpKey = StringUtils.substringBefore((String)entry.getKey().toString(), (String)"[");
                if (!tmpKey.equalsIgnoreCase(key)) continue;
                list.add(entry.getValue().toString());
            }
        }
        return list;
    }

    private Properties loadYamlProperties(Resource ... resources) {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(resources);
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    public List<String> getOrigins() {
        return this.origins;
    }

    public void setOrigins(List<String> origins) {
        this.origins = origins;
    }

    public String getMethods() {
        return this.methods;
    }

    public void setMethods(String methods) {
        this.methods = methods;
    }

    public String getHeaders() {
        return this.headers;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public boolean isCredentials() {
        return this.credentials;
    }

    public void setCredentials(boolean credentials) {
        this.credentials = credentials;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }
}

