/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.config;

import cn.hutool.core.util.StrUtil;
import com.geoway.adf.dms.common.util.HttpServletUtil;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.service.LoginUserService;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.utils.MyRequestUtil;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
@ConditionalOnProperty(name={"right.catalog-enable"}, havingValue="true")
public class LoginUserConfig
implements LoginUserService {
    @Value(value="${right.tenant-enabled:false}")
    private Boolean tenantEnabled;
    @Value(value="${security.guest-visit:false}")
    private Boolean guestVisit;
    @Value(value="${security.token-prefix:'Geoway'}")
    private String guestTokenPrefix;
    @Autowired
    private ITokenService tokenService;

    public LoginUserInfo getUserInfo(HttpServletRequest request) {
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader(request);
            if (StrUtil.isEmpty((CharSequence)token)) {
                if (this.tenantEnabled.booleanValue()) {
                    return null;
                }
                throw new RuntimeException("\u672a\u83b7\u53d6\u5230token!");
            }
            SysUserDTO sysUserDTO = null;
            if (token.startsWith(this.guestTokenPrefix)) {
                if (!this.guestVisit.booleanValue()) {
                    throw new RuntimeException("\u672a\u83b7\u53d6\u5230token!");
                }
                sysUserDTO = this.tokenService.queryGuestUserByGuestToken(token, this.tenantEnabled == false);
            } else {
                sysUserDTO = this.tokenService.querySysUserByToken(token, this.tenantEnabled == false);
            }
            if (sysUserDTO == null) {
                if (this.tenantEnabled.booleanValue()) {
                    return null;
                }
                throw new RuntimeException("token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5165!");
            }
            LoginUserInfo loginUserInfo = new LoginUserInfo();
            if (sysUserDTO.getUserLevel() == 1) {
                loginUserInfo.setRoleId(sysUserDTO.getRoles().stream().map(m -> m.getId()).collect(Collectors.joining(",")) + ",1");
            } else {
                loginUserInfo.setRoleId(sysUserDTO.getRoles().stream().map(m -> m.getId()).collect(Collectors.joining(",")));
            }
            loginUserInfo.setUserId(sysUserDTO.getId());
            loginUserInfo.setUserName(sysUserDTO.getUsername());
            loginUserInfo.setXzqdm(sysUserDTO.getXzqdm());
            loginUserInfo.setRequestRemoteAddr(HttpServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
            loginUserInfo.setRequestUserAgent(request.getHeader("User-Agent"));
            String tenantid = MyRequestUtil.queryAccessAppTENANTIDInHeader(request);
            String tenantisolate = MyRequestUtil.queryAccessAppTENANTISOLATEInHeader(request);
            String tenantkey = MyRequestUtil.queryAccessAppTENANTKEYInHeader(request);
            loginUserInfo.setTenantAdmin(Boolean.valueOf(false));
            if (!(StrUtil.isEmpty((CharSequence)tenantid) || StrUtil.isEmpty((CharSequence)tenantkey) || StrUtil.isEmpty((CharSequence)tenantisolate) || "0".equalsIgnoreCase(tenantisolate.trim()) || "0".equalsIgnoreCase(tenantid.trim()))) {
                loginUserInfo.setTenantId(tenantkey);
                loginUserInfo.setTenantAdmin(Boolean.valueOf(sysUserDTO.getUserLevel() == 2));
            }
            return loginUserInfo;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

