/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.controller;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.sys.dto.AppMenuDTO;
import com.geoway.ns.sys.dto.BaseObjectResponse;
import com.geoway.ns.sys.dto.RowsResponse;
import com.geoway.ns.sys.service.IUISConfigService;
import com.geoway.ns.sys.utils.MyRequestUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u83dc\u5355\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/menu"})
public class MenuController {
    private static final Logger log = LoggerFactory.getLogger(MenuController.class);
    @Autowired
    IUISConfigService uisConfigService;

    @ApiOperation(value="1-\u67e5\u8be2\u7cfb\u7edf\u83dc\u5355\u6811")
    @RequestMapping(value={"/queryMenuTree"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public RowsResponse<AppMenuDTO> menuTrees(HttpServletRequest request, @RequestParam(value="systemId") String systemId) {
        RowsResponse<AppMenuDTO> response = new RowsResponse<AppMenuDTO>();
        try {
            String url = this.uisConfigService.getUISURL() + "/function/queryAppMenuTree";
            HashMap<String, String> paramMap = new HashMap<String, String>();
            if ("2.0".equalsIgnoreCase(this.uisConfigService.getVersion())) {
                url = this.uisConfigService.getUISURL() + "/system/queryInfoByKey";
                paramMap.put("systemKey", systemId);
                String tenantkey = MyRequestUtil.queryAccessAppTENANTKEYInHeader(request);
                if (StringUtils.isNotEmpty((CharSequence)tenantkey)) {
                    paramMap.put("tenantKey", tenantkey);
                }
            } else {
                paramMap.put("systemId", systemId);
            }
            paramMap.put("appKey", this.uisConfigService.getAppkey());
            paramMap.put("appsecret", this.uisConfigService.getAppsecret());
            HashMap<String, String> mapHeader = new HashMap<String, String>();
            mapHeader.put("access_token", request.getHeader("access_token"));
            String result = null;
            result = "2.0".equalsIgnoreCase(this.uisConfigService.getVersion()) ? ((HttpRequest)HttpUtil.createRequest((Method)Method.GET, (String)url).addHeaders(mapHeader)).form(paramMap).execute().body() : ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).addHeaders(mapHeader)).form(paramMap).execute().body();
            BaseObjectResponse baseObjectResponse = (BaseObjectResponse)JSON.parseObject((String)result, BaseObjectResponse.class);
            if (baseObjectResponse.getStatus().equalsIgnoreCase("OK")) {
                Object data = baseObjectResponse.getData();
                if (data instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)data;
                    List menuTrees = jsonArray.toJavaList(AppMenuDTO.class);
                    response.setRows(menuTrees);
                } else if (data instanceof JSONObject && "2.0".equalsIgnoreCase(this.uisConfigService.getVersion())) {
                    JSONObject jsonObject = (JSONObject)data;
                    if (jsonObject != null && jsonObject.containsKey((Object)"menu")) {
                        JSONArray jsonArray = jsonObject.getJSONArray("menu");
                        List<AppMenuDTO> menuTrees = this.convertMenuTree(jsonArray);
                        response.setRows(menuTrees);
                    }
                } else {
                    System.out.println("\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff1a" + data.getClass());
                }
            } else {
                response.markFailure("\u67e5\u8be2\u7cfb\u7edf\u83dc\u5355\u6811\u5f02\u5e38:" + baseObjectResponse.getMessage());
            }
        }
        catch (Exception ex) {
            log.error("\u67e5\u8be2\u7cfb\u7edf\u83dc\u5355\u6811\u5f02\u5e38", (Throwable)ex);
            response.markFailure("\u67e5\u8be2\u7cfb\u7edf\u83dc\u5355\u6811\u5f02\u5e38:" + ex.getMessage());
        }
        return response;
    }

    private List<AppMenuDTO> convertMenuTree(JSONArray jsonArray) {
        return jsonArray.stream().map(item -> this.convertSingleNode((JSONObject)item)).collect(Collectors.toList());
    }

    private AppMenuDTO convertSingleNode(JSONObject json) {
        Object children;
        AppMenuDTO dto = (AppMenuDTO)JSON.parseObject((String)json.toJSONString(), AppMenuDTO.class);
        dto.setNewPage(3 == json.getInteger("openMode") ? 1 : 0);
        if (StringUtils.isNotEmpty((CharSequence)json.getString("pathType")) || json.getJSONObject("menuPath") != null) {
            dto.setLink(2 == (StringUtils.isEmpty((CharSequence)json.getString("pathType")) ? json.getJSONObject("menuPath").getInteger("pathType") : json.getInteger("pathType")) ? 1 : 0);
        } else {
            dto.setLink(0);
        }
        if (json.containsKey((Object)"children") && (children = json.get((Object)"children")) instanceof JSONArray) {
            dto.setChildren(this.convertMenuTree((JSONArray)children));
        }
        return dto;
    }
}

