/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.geoway.ns.sys.enums.ResultCodeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ApiModel(value="\u7edf\u4e00\u8fd4\u56de\u7ed3\u6784")
public class RestResult<T>
implements Serializable {
    @ApiModelProperty(value="\u8bf7\u6c42\u72b6\u6001\u7801", example="200")
    private Integer code;
    @ApiModelProperty(value="\u8fd4\u56de\u6570\u636e")
    private T data;
    @ApiModelProperty(value="\u9519\u8bef\u63d0\u793a\uff0c\u7528\u6237\u53ef\u9605\u8bfb")
    private String msg;
    protected String status;
    protected String message;
    protected Long total;

    public void markFailure(String message) {
        this.code = 1000;
        this.msg = message;
    }

    public static <T> RestResult<T> error(RestResult<?> result) {
        return RestResult.error(result.getCode(), result.getMsg());
    }

    public static <T> RestResult<T> error(Integer code, String message) {
        Assert.isTrue((200 != code ? 1 : 0) != 0, (String)"code \u5fc5\u987b\u662f\u9519\u8bef\u7684\uff01");
        RestResult<T> result = new RestResult<T>();
        result.code = code;
        result.msg = message;
        return result;
    }

    public static <T> RestResult<T> error(ResultCodeEnum resultCodeEnum) {
        return RestResult.error(resultCodeEnum.getCode(), resultCodeEnum.getMessage());
    }

    public static <T> RestResult<T> error(String msg) {
        return RestResult.error(ResultCodeEnum.UNKNOWN_ERROR.getCode(), msg);
    }

    public static <T> RestResult<T> success(T data) {
        RestResult<T> result = new RestResult<T>();
        result.code = ResultCodeEnum.SUCCESS.getCode();
        result.data = data;
        result.msg = "\u64cd\u4f5c\u6210\u529f\uff01";
        return result;
    }

    public static <T> RestResult<T> success(T data, String msg) {
        RestResult<T> result = new RestResult<T>();
        result.code = ResultCodeEnum.SUCCESS.getCode();
        result.data = data;
        result.msg = msg;
        return result;
    }

    public static boolean isSuccess(Integer code) {
        return Objects.equals(code, ResultCodeEnum.SUCCESS.getCode());
    }

    @JsonIgnore
    public boolean isSuccess() {
        return RestResult.isSuccess(this.code);
    }

    @JsonIgnore
    public boolean isError() {
        return !this.isSuccess();
    }

    public Integer getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public Long getTotal() {
        return this.total;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestResult)) {
            return false;
        }
        RestResult other = (RestResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "RestResult(code=" + this.getCode() + ", data=" + this.getData() + ", msg=" + this.getMsg() + ", status=" + this.getStatus() + ", message=" + this.getMessage() + ", total=" + this.getTotal() + ")";
    }
}

