/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.sys.domain.BaseSysPower;
import com.geoway.ns.sys.domain.SysPower;
import com.geoway.ns.sys.enums.SysPowerMandateType;
import com.geoway.ns.sys.vo.SysPowerCountVO;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSysPower<M extends BaseMapper<T>, T extends BaseSysPower>
extends ServiceImpl<M, T> {
    public boolean saveOrUpdate(T entity) {
        if (StringUtils.isBlank((CharSequence)((BaseSysPower)entity).getId())) {
            T info;
            String powerTypeEnum = null;
            if (entity.getClass() == SysPower.class) {
                powerTypeEnum = ((SysPower)entity).getPowerTypeEnum().value;
            }
            if ((info = this.getInfo(((BaseSysPower)entity).getMandateId(), ((BaseSysPower)entity).getRelationId(), powerTypeEnum)) != null) {
                throw new RuntimeException("\u3010" + ((BaseSysPower)entity).getMandateId() + "\u3011\u6570\u636e\u5df2\u7ecf\u6388\u6743\uff01");
            }
            ((BaseSysPower)entity).setMandateTime(new Date());
            return super.save(entity);
        }
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.eq((Object)"f_id", (Object)((BaseSysPower)entity).getId());
        wrapper.set((Object)"f_mandate_type", (Object)((BaseSysPower)entity).getMandateType());
        wrapper.set((Object)"f_mandate_limit_start", (Object)((BaseSysPower)entity).getMandateLimitStart());
        wrapper.set((Object)"f_mandate_limit_end", (Object)((BaseSysPower)entity).getMandateLimitEnd());
        wrapper.set((Object)"f_param", (Object)((BaseSysPower)entity).getParam());
        return this.update((Wrapper)wrapper);
    }

    public void verify(String mandateId, String relationId) {
        String[] split = relationId.split(",");
        if (split.length == 1) {
            T info = this.getInfo(mandateId, relationId);
            if (info == null) {
                throw new RuntimeException("\u672a\u6388\u6743\uff01");
            }
            this.validateMandate(info);
        } else {
            List<T> infos = this.getInfos(mandateId, relationId);
            if (infos.isEmpty()) {
                throw new RuntimeException("\u672a\u6388\u6743\uff01");
            }
            boolean isValid = infos.stream().anyMatch(this::isMandateValid);
            if (!isValid) {
                throw new RuntimeException("\u672a\u5230\u4f7f\u7528\u671f\u9650\u6216\u5df2\u8fc7\u671f\uff01");
            }
        }
    }

    private void validateMandate(T info) {
        Date currentDate;
        if (SysPowerMandateType.limited.value.equals(((BaseSysPower)info).getMandateType()) && ((currentDate = new Date()).before(((BaseSysPower)info).getMandateLimitStart()) || currentDate.after(((BaseSysPower)info).getMandateLimitEnd()))) {
            throw new RuntimeException("\u672a\u5230\u4f7f\u7528\u671f\u9650\u6216\u5df2\u8fc7\u671f\uff01");
        }
    }

    private boolean isMandateValid(T info) {
        if (Objects.equals(((BaseSysPower)info).getMandateType(), SysPowerMandateType.unlimited.value)) {
            return true;
        }
        if (Objects.equals(((BaseSysPower)info).getMandateType(), SysPowerMandateType.limited.value)) {
            Date currentDate = new Date();
            return currentDate.after(((BaseSysPower)info).getMandateLimitStart()) && currentDate.before(((BaseSysPower)info).getMandateLimitEnd());
        }
        return false;
    }

    public SysPowerCountVO counts(String relationId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"f_relation_id", (Object)relationId);
        wrapper.select(new String[]{"count(1) as total,count(f_mandate_type = 1 or null) as unlimited,count(f_mandate_type = 2 or null) as valid,count(f_mandate_limit_start < now() and  f_mandate_limit_end > now()  or null) as invalid"});
        Map map = this.getMap((Wrapper)wrapper);
        return !map.isEmpty() ? (SysPowerCountVO)BeanUtil.mapToBean((Map)map, SysPowerCountVO.class, (boolean)false) : new SysPowerCountVO();
    }

    private T getInfo(String mandateId, String relationId) {
        return this.getInfo(mandateId, relationId, null);
    }

    private T getInfo(String mandateId, String relationId, String powerTypeEnum) {
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)powerTypeEnum)) {
            wrapper.eq((Object)"f_power_type", (Object)powerTypeEnum);
        }
        wrapper.eq((Object)"f_mandate_id", (Object)mandateId);
        wrapper.eq((Object)"f_relation_id", (Object)relationId);
        return (T)((BaseSysPower)this.getOne((Wrapper)wrapper));
    }

    private List<T> getInfos(String mandateId, String relationIds) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"f_mandate_id", (Object)mandateId);
        wrapper.in((Object)"f_relation_id", (Object[])relationIds.split(","));
        return this.list((Wrapper)wrapper);
    }
}

