/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.service.impl;

import cn.hutool.core.util.StrUtil;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.ns.sys.domain.FileServer;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.FileDownloadMeta;
import com.geoway.ns.sys.dto.FilePart;
import com.geoway.ns.sys.dto.FileServerResponse;
import com.geoway.ns.sys.dto.FileStoreMeta;
import com.geoway.ns.sys.dto.FileUploadResponse;
import com.geoway.ns.sys.dto.FileUploadTask;
import com.geoway.ns.sys.dto.UploadingFileInfo;
import com.geoway.ns.sys.service.FileServerService;
import com.geoway.ns.sys.service.HuWeiObsFileService;
import com.geoway.ns.sys.service.MinIOFileService;
import com.geoway.ns.sys.service.ShareFileService;
import com.geoway.ns.sys.utils.ObjectKeyUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileServerServiceImpl
implements FileServerService {
    @Autowired
    ShareFileService shareFileService;
    @Autowired
    MinIOFileService minIOFileService;
    @Autowired
    HuWeiObsFileService huWeiObsFileService;
    @Resource
    DataSourceService dataSourceService;

    @Override
    public FileServerResponse sendFileToServer(MultipartFile file) throws Exception {
        return this.sendFileToServer(file, false);
    }

    @Override
    public FileServerResponse sendFileToServer(MultipartFile file, boolean buildThumbnail) throws Exception {
        FileServer fileServer = this.findDefault();
        if (fileServer == null) {
            throw new Exception("\u672a\u914d\u7f6e\u6587\u4ef6\u670d\u52a1");
        }
        return this.sendFileToServer(file, null, buildThumbnail);
    }

    @Override
    public FileServerResponse sendFileToServer(MultipartFile file, String objectName, boolean buildThumbnail) throws Exception {
        FileServer fileServer = this.findDefault();
        if (fileServer == null) {
            throw new Exception("\u672a\u914d\u7f6e\u6587\u4ef6\u670d\u52a1");
        }
        return this.saveFile(fileServer, file, objectName, buildThumbnail);
    }

    @Override
    public FileServerResponse sendFileToServer(File file, String objectName, boolean buildThumbnail) throws Exception {
        Assert.notNull((Object)file, (String)"\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a\uff01");
        String contentType = Files.probeContentType(file.toPath());
        MockMultipartFile mockMultipartFile = new MockMultipartFile(file.getName(), file.getName(), contentType, FileUtils.readFileToByteArray((File)file));
        return this.sendFileToServer((MultipartFile)mockMultipartFile, objectName, buildThumbnail);
    }

    @Override
    public FileServerResponse sendFileToServer(String serverId, MultipartFile file, String objectName, boolean buildThumbnail) throws Exception {
        FileServer fileServer = this.findById(serverId);
        if (fileServer == null) {
            throw new Exception("\u672a\u914d\u7f6e\u6587\u4ef6\u670d\u52a1");
        }
        return this.saveFile(fileServer, file, objectName, buildThumbnail);
    }

    @Override
    public FileServerResponse sendFileToServer(String serverId, File file, String objectName, boolean buildThumbnail) throws Exception {
        FileServer fileServer = this.findById(serverId);
        if (fileServer == null) {
            throw new Exception("\u672a\u914d\u7f6e\u6587\u4ef6\u670d\u52a1");
        }
        String contentType = Files.probeContentType(file.toPath());
        MockMultipartFile mockMultipartFile = new MockMultipartFile(file.getName(), file.getName(), contentType, FileUtils.readFileToByteArray((File)file));
        return this.saveFile(fileServer, (MultipartFile)mockMultipartFile, objectName, buildThumbnail);
    }

    @Override
    public FileServerResponse sendFileToServerOnSpeFolder(MultipartFile file, String foldName) throws Exception {
        return this.sendFileToServerOnSpeFolder(file, foldName, false);
    }

    @Override
    public FileServerResponse sendFileToServerOnSpeFolder(MultipartFile file, String foldName, boolean buildThumbnail) throws Exception {
        FileServer fileServer = this.findDefault();
        if (fileServer == null) {
            throw new Exception("\u672a\u914d\u7f6e\u6587\u4ef6\u670d\u52a1");
        }
        String fileName = file.getOriginalFilename();
        String objectName = ObjectKeyUtil.formatObjectName(fileName);
        if (StrUtil.isNotBlank((CharSequence)foldName)) {
            objectName = foldName + "/" + objectName;
        }
        return this.sendFileToServer(file, objectName, buildThumbnail);
    }

    @Override
    public FileServerResponse sendFileToServerByStream(InputStream stream, String objectName, String contentType) throws Exception {
        FileServer fileServer = this.findDefault();
        if (fileServer == null) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u6587\u4ef6\u670d\u52a1");
        }
        return this.saveFile(fileServer, stream, objectName, contentType);
    }

    @Override
    public FileServerResponse sendObject2OssByMultiPart(File file, String sendObjectName) {
        FileServer fileServer = this.findDefault();
        String type = fileServer.getType();
        FileStoreMeta fileStoreMeta = null;
        FileServerResponse fileServerResponse = new FileServerResponse();
        if ("share".equalsIgnoreCase(type)) {
            fileStoreMeta = this.shareFileService.sendObject2OssByMultiPart(fileServer, file, sendObjectName);
        } else if ("minio".equalsIgnoreCase(type)) {
            fileStoreMeta = this.minIOFileService.sendObject2OssByMultiPart(fileServer, file, sendObjectName);
        } else {
            try {
                fileStoreMeta = this.huWeiObsFileService.sendObject2OssByMultiPart(fileServer, file, sendObjectName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        fileServerResponse.setServerURL(fileServer.getUrl());
        fileServerResponse.setBucket(fileServer.getBucket());
        if (fileStoreMeta != null) {
            fileServerResponse.setPath(fileStoreMeta.getRelPath());
            fileServerResponse.setFileSize(fileStoreMeta.getFileSize());
            fileServerResponse.setFileType(fileStoreMeta.getFileType());
            fileServerResponse.setPreviewURL(fileStoreMeta.getPreviewURL());
            fileServerResponse.setViewURL(fileStoreMeta.getPreviewURL());
            fileServerResponse.setUploadId(fileStoreMeta.getUploadId());
        }
        return fileServerResponse;
    }

    private FileServerResponse saveFile(FileServer fileServer, InputStream stream, String objectName, String contentType) throws Exception {
        String type = fileServer.getType();
        FileStoreMeta fileStoreMeta = null;
        FileServerResponse fileServerResponse = new FileServerResponse();
        fileStoreMeta = "share".equalsIgnoreCase(type) ? this.shareFileService.sendFile(fileServer, stream, objectName, contentType) : ("minio".equalsIgnoreCase(type) ? this.minIOFileService.sendFile(fileServer, stream, objectName, contentType) : this.huWeiObsFileService.sendFile(fileServer, stream, objectName, contentType));
        fileServerResponse.setServerURL(fileServer.getUrl());
        fileServerResponse.setBucket(fileServer.getBucket());
        if (fileStoreMeta != null) {
            fileServerResponse.setPath(fileStoreMeta.getRelPath());
            fileServerResponse.setFileSize(fileStoreMeta.getFileSize());
            fileServerResponse.setFileType(fileStoreMeta.getFileType());
            fileServerResponse.setPreviewURL(fileStoreMeta.getPreviewURL());
            fileServerResponse.setViewURL(fileStoreMeta.getPreviewURL());
        }
        return fileServerResponse;
    }

    private FileServerResponse saveFile(FileServer fileServer, MultipartFile file, String objectName, boolean buildThumbnail) throws Exception {
        String type = fileServer.getType();
        FileStoreMeta fileStoreMeta = null;
        FileStoreMeta minFileStoreMeta = null;
        FileServerResponse fileServerResponse = new FileServerResponse();
        if ("share".equalsIgnoreCase(type)) {
            fileStoreMeta = this.shareFileService.sendFile(fileServer, file, objectName);
            if (buildThumbnail) {
                minFileStoreMeta = this.shareFileService.buildThumbnailFile(fileServer, fileStoreMeta.getRelPath());
            }
        } else if ("minio".equalsIgnoreCase(type)) {
            fileStoreMeta = this.minIOFileService.sendFile(fileServer, file, objectName);
            if (buildThumbnail) {
                minFileStoreMeta = this.minIOFileService.buildThumbnailFile(fileServer, fileStoreMeta.getRelPath());
            }
        } else {
            fileStoreMeta = this.huWeiObsFileService.sendFile(fileServer, file, objectName);
            if (buildThumbnail) {
                minFileStoreMeta = this.huWeiObsFileService.buildThumbnailFile(fileServer, fileStoreMeta.getRelPath());
            }
        }
        fileServerResponse.setServerId(fileServer.getId());
        fileServerResponse.setServerURL(fileServer.getUrl());
        fileServerResponse.setBucket(fileServer.getBucket());
        if (fileStoreMeta != null) {
            fileServerResponse.setPath(fileStoreMeta.getRelPath());
            fileServerResponse.setFileSize(fileStoreMeta.getFileSize());
            fileServerResponse.setFileType(fileStoreMeta.getFileType());
            fileServerResponse.setPreviewURL(fileStoreMeta.getPreviewURL());
            fileServerResponse.setViewURL(fileServer.getUrl() + "/" + fileServer.getBucket() + "/" + fileStoreMeta.getRelPath());
        }
        if (minFileStoreMeta != null) {
            fileServerResponse.setThumailPath(minFileStoreMeta.getRelPath());
        }
        return fileServerResponse;
    }

    @Override
    public void deleteFile(String objectName) throws Exception {
        FileServer fileServer = this.findDefault();
        this.deleteFileByFileServer(objectName, fileServer);
    }

    @Override
    public void deleteFile(String serverId, String objectName) throws Exception {
        FileServer fileServer = this.findById(serverId);
        this.deleteFileByFileServer(objectName, fileServer);
    }

    private void deleteFileByFileServer(String objectName, FileServer fileServer) throws Exception {
        String type;
        switch (type = fileServer.getType().toLowerCase()) {
            case "share": {
                this.shareFileService.deleteFile(fileServer, objectName);
                break;
            }
            case "minio": {
                this.minIOFileService.deleteFile(fileServer, fileServer.getBucket(), objectName);
                break;
            }
            case "obs": {
                this.huWeiObsFileService.deleteFile(fileServer, fileServer.getBucket(), objectName);
                break;
            }
        }
    }

    @Override
    @Cacheable(value={"FileServerCache#10"}, key="#root.methodName")
    public FileServer findDefault() {
        DataSourceDTO dataSourceDTO = this.dataSourceService.getDefaultDataSource(Integer.valueOf(DataStoreTypeEnum.FileStorageSystem.getValue()), null);
        FileServer fileServer = new FileServer();
        String[] pathParts = dataSourceDTO.getUrl().split("/");
        fileServer.setId(dataSourceDTO.getKey());
        fileServer.setBucket(pathParts[pathParts.length - 1]);
        String url = dataSourceDTO.getUrl().substring(0, dataSourceDTO.getUrl().length() - pathParts[pathParts.length - 1].length() - 1);
        fileServer.setEndpoint(url);
        fileServer.setUrl(url);
        fileServer.setType(dataSourceDTO.getDataSourceType() == 32 ? "share" : (dataSourceDTO.getDataSourceType() == 34 ? "minio" : "obs"));
        fileServer.setAppsecret(dataSourceDTO.getPassword());
        fileServer.setAppkey(dataSourceDTO.getUserName());
        return fileServer;
    }

    @Override
    @Cacheable(value={"FileServerCache#10"}, key="#root.methodName+ '-' + #id")
    public FileServer findById(String id) {
        DataSourceDTO dataSourceDTO = this.dataSourceService.getDataSourceDetail(id);
        FileServer fileServer = new FileServer();
        String[] pathParts = dataSourceDTO.getUrl().split("/");
        fileServer.setId(dataSourceDTO.getKey());
        fileServer.setBucket(pathParts[pathParts.length - 1]);
        String url = dataSourceDTO.getUrl().substring(0, dataSourceDTO.getUrl().length() - pathParts[pathParts.length - 1].length() - 1);
        fileServer.setEndpoint(url);
        fileServer.setUrl(url);
        fileServer.setType(dataSourceDTO.getDataSourceType() == 32 ? "share" : (dataSourceDTO.getDataSourceType() == 34 ? "minio" : "obs"));
        fileServer.setAppsecret(dataSourceDTO.getPassword());
        fileServer.setAppkey(dataSourceDTO.getUserName());
        return fileServer;
    }

    @Override
    public String buildPreviewURL(String serverId, String objectName, Integer expires) throws Exception {
        String type;
        String previewURL = "";
        FileServer fileServer = this.findById(serverId);
        if (fileServer == null) {
            return previewURL;
        }
        switch (type = fileServer.getType().toLowerCase()) {
            case "share": {
                previewURL = this.shareFileService.buildPreviewURL(fileServer, objectName, expires);
                break;
            }
            case "minio": {
                previewURL = this.minIOFileService.buildPreviewURL(fileServer, objectName, expires);
                break;
            }
            case "obs": {
                previewURL = this.huWeiObsFileService.buildPreviewURL(fileServer, objectName, expires);
                break;
            }
        }
        return previewURL;
    }

    @Override
    public byte[] createThumail(String serverId, String objectName) throws Exception {
        String type;
        FileServer fileServer = this.findById(serverId);
        if (fileServer == null) {
            return new byte[0];
        }
        byte[] thumnailBytes = new byte[]{};
        switch (type = fileServer.getType().toLowerCase()) {
            case "share": {
                thumnailBytes = this.shareFileService.createThumbnail(fileServer, objectName);
                break;
            }
            case "minio": {
                thumnailBytes = this.minIOFileService.createThumbnail(fileServer, objectName);
                break;
            }
            case "obs": {
                thumnailBytes = this.huWeiObsFileService.createThumbnail(fileServer, objectName);
                break;
            }
        }
        return thumnailBytes;
    }

    @Override
    public FileDownloadMeta queryDownLoadMeta(String serverId, String objectName) throws Exception {
        FileServer fileServer = this.findById(serverId);
        if (fileServer == null) {
            return null;
        }
        return this.getFileDownloadMeta(objectName, fileServer);
    }

    @Override
    public FileDownloadMeta queryDownLoadMeta(String objectName) throws Exception {
        FileServer fileServer = this.findDefault();
        if (fileServer == null) {
            return null;
        }
        if (!StringUtils.isEmpty((Object)objectName) && objectName.toLowerCase().startsWith("http") && objectName.indexOf(fileServer.getBucket()) > -1) {
            objectName = objectName.substring(objectName.indexOf(fileServer.getBucket()) + fileServer.getBucket().length() + 1);
        }
        return this.getFileDownloadMeta(objectName, fileServer);
    }

    private FileDownloadMeta getFileDownloadMeta(String objectName, FileServer fileServer) throws Exception {
        String type;
        FileDownloadMeta fileDownloadMeta = null;
        switch (type = fileServer.getType().toLowerCase()) {
            case "share": {
                fileDownloadMeta = this.shareFileService.downLoadFile(fileServer, objectName);
                break;
            }
            case "minio": {
                fileDownloadMeta = this.minIOFileService.downLoadFile(fileServer, objectName);
                break;
            }
            case "obs": {
                fileDownloadMeta = this.huWeiObsFileService.downLoadFile(fileServer, objectName);
                break;
            }
        }
        return fileDownloadMeta;
    }

    @Override
    @CacheEvict(value={"FileServerCache#10"}, allEntries=true)
    public void deleteCache() {
    }

    @Override
    public UploadingFileInfo upLoadFileByChunk(String code, String originalFileName, MultipartFile chunk, UploadingFileInfo uploadInfo, Boolean isParallel) throws Exception {
        String type;
        FileServer fileServer = this.findDefault();
        if (fileServer == null) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u6587\u4ef6\u670d\u52a1");
        }
        switch (type = fileServer.getType().toLowerCase()) {
            case "share": {
                return this.shareFileService.upLoadFileByChunk(fileServer, code, originalFileName, chunk, uploadInfo, isParallel);
            }
            case "minio": {
                return this.minIOFileService.upLoadFileByChunk(fileServer, code, originalFileName, chunk, uploadInfo, isParallel);
            }
            case "obs": {
                return this.huWeiObsFileService.upLoadFileByChunk(fileServer, code, originalFileName, chunk, uploadInfo, isParallel);
            }
        }
        return null;
    }

    @Override
    public FileUploadResponse upLoadFileCompleteWithMerge(UploadingFileInfo uploadInfo) throws Exception {
        String type;
        FileServer fileServer = this.findDefault();
        if (fileServer == null) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u6587\u4ef6\u670d\u52a1");
        }
        switch (type = fileServer.getType().toLowerCase()) {
            case "share": {
                return this.shareFileService.upLoadFileCompleteWithMerge(fileServer, uploadInfo);
            }
            case "minio": {
                return this.minIOFileService.upLoadFileCompleteWithMerge(fileServer, uploadInfo);
            }
            case "obs": {
                return this.huWeiObsFileService.upLoadFileCompleteWithMerge(fileServer, uploadInfo);
            }
        }
        return null;
    }

    @Override
    public List<FilePart> listUpLoadFileParts(UploadingFileInfo uploadInfo) throws Exception {
        String type;
        FileServer fileServer = this.findDefault();
        if (fileServer == null) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u6587\u4ef6\u670d\u52a1");
        }
        switch (type = fileServer.getType().toLowerCase()) {
            case "share": {
                return this.shareFileService.listUpLoadFileParts(fileServer, uploadInfo);
            }
            case "minio": {
                return this.minIOFileService.listUpLoadFileParts(fileServer, uploadInfo);
            }
            case "obs": {
                return this.huWeiObsFileService.listUpLoadFileParts(fileServer, uploadInfo);
            }
        }
        return null;
    }

    @Override
    public List<FileUploadTask> listUpLoadFileTasks() throws Exception {
        String type;
        FileServer fileServer = this.findDefault();
        if (fileServer == null) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u6587\u4ef6\u670d\u52a1");
        }
        switch (type = fileServer.getType().toLowerCase()) {
            case "share": {
                return this.shareFileService.listUpLoadFileTasks(fileServer);
            }
            case "minio": {
                return this.minIOFileService.listUpLoadFileTasks(fileServer);
            }
            case "obs": {
                return this.huWeiObsFileService.listUpLoadFileTasks(fileServer);
            }
        }
        return null;
    }

    @Override
    public BaseResponse abortMultipartUpload(UploadingFileInfo uploadInfo) {
        String type;
        FileServer fileServer = this.findDefault();
        if (fileServer == null) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u6587\u4ef6\u670d\u52a1");
        }
        switch (type = fileServer.getType().toLowerCase()) {
            case "share": {
                return this.shareFileService.abortMultipartUpload(fileServer, uploadInfo);
            }
            case "minio": {
                return this.minIOFileService.abortMultipartUpload(fileServer, uploadInfo);
            }
            case "obs": {
                return this.huWeiObsFileService.abortMultipartUpload(fileServer, uploadInfo);
            }
        }
        return null;
    }

    @Override
    public BaseResponse abortMultipartUpload(String objectKey, String uploadId) {
        String type;
        FileServer fileServer = this.findDefault();
        if (fileServer == null) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u6587\u4ef6\u670d\u52a1");
        }
        switch (type = fileServer.getType().toLowerCase()) {
            case "share": {
                return this.shareFileService.abortMultipartUpload(fileServer, objectKey, uploadId);
            }
            case "minio": {
                return this.minIOFileService.abortMultipartUpload(fileServer, objectKey, uploadId);
            }
            case "obs": {
                return this.huWeiObsFileService.abortMultipartUpload(fileServer, objectKey, uploadId);
            }
        }
        return null;
    }
}

