/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.sys.dto.SysUserOrigin;
import com.geoway.ns.sys.service.IUISConfigService;
import com.geoway.ns.sys.service.NsUserService;
import com.geoway.ns.sys.utils.MyRequestUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class NsUserServiceImpl
implements NsUserService {
    @Value(value="${sso.url:''}")
    private String url;
    @Value(value="${right.tenant-enabled:false}")
    private Boolean tenantEnabled;
    @Value(value="${project.system-id:''}")
    private String systemId;
    @Autowired
    IUISConfigService uisConfigService;

    private HttpRequest getHttp(String path, Method method) {
        String access_token = MyRequestUtil.queryAccessTokenInHeader();
        String tenantid = MyRequestUtil.queryAccessAppTENANTIDInHeader();
        String tenantisolate = MyRequestUtil.queryAccessAppTENANTISOLATEInHeader();
        String tenantkey = MyRequestUtil.queryAccessAppTENANTKEYInHeader();
        return (HttpRequest)((HttpRequest)((HttpRequest)HttpUtil.createRequest((Method)method, (String)(this.url + path)).header("access_token", access_token)).header("tenantId", tenantid)).header("tenantKey", tenantkey);
    }

    private <T> T getResult(HttpResponse execute, Class<T> tClass) {
        int status = execute.getStatus();
        if (status != 200) {
            throw new RuntimeException(execute.body());
        }
        JSONObject object = JSON.parseObject((String)execute.body());
        Integer code = object.getInteger("code");
        if (code != 200) {
            throw new RuntimeException(object.getString("message"));
        }
        return (T)object.getObject("data", tClass);
    }

    @Override
    public SysUserOrigin getUserBaseInfo(String userId) {
        HttpRequest http = null;
        if ("2.0".equalsIgnoreCase(this.uisConfigService.getVersion())) {
            http = this.getHttp("/user/queryUserInfo", Method.GET);
            http.form("filterParam", (Object)("Q_id_S_EQ=" + userId));
            HttpResponse resp = http.execute();
            int status = resp.getStatus();
            if (status != 200) {
                throw new RuntimeException(resp.body());
            }
            String jsonText = resp.body();
            JSONObject jsonObject = JSON.parseObject((String)jsonText);
            JSONObject jsonData = jsonObject.getJSONObject("data");
            return (SysUserOrigin)jsonData.toJavaObject(SysUserOrigin.class);
        }
        http = this.getHttp("/user/queryList", Method.GET);
        http.form("filterParam", (Object)("Q_id_S_EQ=" + userId));
        HttpResponse resp = http.execute();
        int status = resp.getStatus();
        if (status != 200) {
            throw new RuntimeException(resp.body());
        }
        String jsonText = resp.body();
        JSONObject jsonObject = JSON.parseObject((String)jsonText);
        JSONArray jsonArray = jsonObject.getJSONArray("data");
        List userOrigins = jsonArray.toJavaList(SysUserOrigin.class);
        if (userOrigins == null || userOrigins.size() == 0) {
            throw new RuntimeException("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u51fa\u9519");
        }
        return (SysUserOrigin)userOrigins.get(0);
    }

    @Override
    public JSONObject queryInfoByKey(String systemKey, String tenantKey) {
        HttpRequest http = this.getHttp("/system/queryInfoByKey", Method.GET);
        http.form("systemKey", (Object)systemKey);
        http.form("tenantKey", (Object)tenantKey);
        HttpResponse resp = http.execute();
        int status = resp.getStatus();
        if (status != 200) {
            throw new RuntimeException(resp.body());
        }
        String jsonText = resp.body();
        JSONObject jsonObject = JSON.parseObject((String)jsonText);
        JSONObject result = jsonObject.getJSONObject("data").getJSONObject("system");
        return result;
    }

    @Override
    public String getCurUserRealTel() {
        HttpRequest http = this.getHttp("/user/getCurUserRealTel", Method.GET);
        HttpResponse resp = http.execute();
        int status = resp.getStatus();
        if (status != 200) {
            throw new RuntimeException(resp.body());
        }
        String jsonText = resp.body();
        JSONObject jsonObject = JSON.parseObject((String)jsonText);
        String result = jsonObject.getString("data");
        return result;
    }

    @Override
    public void updateUserBaseInfo2(String userId, String systemTitle, String tenantKey) {
        JSONObject parseObject;
        SysUserOrigin sysUserOrigin = this.getUserBaseInfo(userId);
        JSONObject jSONObject = parseObject = StrUtil.isNotBlank((CharSequence)sysUserOrigin.getParams()) ? JSON.parseObject((String)sysUserOrigin.getParams()) : new JSONObject();
        if (StrUtil.isNotEmpty((CharSequence)tenantKey) && !tenantKey.equals("undefined") && !tenantKey.equals("null")) {
            parseObject.put(tenantKey, (Object)systemTitle);
        }
        parseObject.put("systemTitle", (Object)systemTitle);
        sysUserOrigin.setParams(parseObject.toJSONString());
        HttpRequest httpPost = null;
        if ("2.0".equalsIgnoreCase(this.uisConfigService.getVersion())) {
            Field[] fields;
            httpPost = this.getHttp("/user/update", Method.POST);
            for (Field field : fields = sysUserOrigin.getClass().getDeclaredFields()) {
                try {
                    field.setAccessible(true);
                    httpPost.form(field.getName(), field.get(sysUserOrigin));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        } else {
            String postJson = JSONArray.toJSONString(new ArrayList<SysUserOrigin>(Arrays.asList(sysUserOrigin)));
            httpPost = this.getHttp("/user/batchSave", Method.POST);
            httpPost.form("usersJson", (Object)postJson);
        }
        HttpResponse resp = httpPost.execute();
        int status = resp.getStatus();
        if (status != 200) {
            throw new RuntimeException(resp.body());
        }
        JSONObject jsonObject = JSON.parseObject((String)resp.body());
        if (!"OK".equalsIgnoreCase(jsonObject.getString("status"))) {
            throw new RuntimeException(jsonObject.getString("message"));
        }
    }

    @Override
    public void updateUserBaseInfo(String userId, String tel, String workTel, String email) {
        SysUserOrigin sysUserOrigin = this.getUserBaseInfo(userId);
        if (StrUtil.isNotBlank((CharSequence)tel)) {
            sysUserOrigin.setTel(tel);
        }
        if (StrUtil.isNotBlank((CharSequence)workTel)) {
            sysUserOrigin.setWorktel(workTel);
        }
        if (StrUtil.isNotBlank((CharSequence)email)) {
            sysUserOrigin.setEmail(email);
        }
        HttpRequest httpPost = null;
        if ("2.0".equalsIgnoreCase(this.uisConfigService.getVersion())) {
            Field[] fields;
            httpPost = this.getHttp("/user/update", Method.POST);
            for (Field field : fields = sysUserOrigin.getClass().getDeclaredFields()) {
                try {
                    field.setAccessible(true);
                    httpPost.form(field.getName(), field.get(sysUserOrigin));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        } else {
            String postJson = JSONArray.toJSONString(new ArrayList<SysUserOrigin>(Arrays.asList(sysUserOrigin)));
            httpPost = this.getHttp("/user/batchSave", Method.POST);
            httpPost.form("usersJson", (Object)postJson);
        }
        HttpResponse resp = httpPost.execute();
        int status = resp.getStatus();
        if (status != 200) {
            throw new RuntimeException(resp.body());
        }
        JSONObject jsonObject = JSON.parseObject((String)resp.body());
        if (!"OK".equalsIgnoreCase(jsonObject.getString("status"))) {
            throw new RuntimeException(jsonObject.getString("message"));
        }
    }

    @Override
    public void changePasswordByUserId(String oldPwd, String newPwd) throws Exception {
        HttpRequest httpPost = this.getHttp("/user/changePwd", Method.POST);
        httpPost.form("oldPwd", (Object)oldPwd);
        httpPost.form("newPwd", (Object)newPwd);
        HttpResponse resp = httpPost.execute();
        int status = resp.getStatus();
        if (status != 200) {
            throw new RuntimeException(resp.body());
        }
        JSONObject jsonObject = JSON.parseObject((String)resp.body());
        if (!"OK".equalsIgnoreCase(jsonObject.getString("status"))) {
            throw new RuntimeException(jsonObject.getString("message"));
        }
    }
}

