/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.ns.sys.mapper.AppCatalogRightMapper;
import com.geoway.ns.sys.service.RoleService;
import com.geoway.ns.sys.utils.MyRequestUtil;
import com.geoway.ns.sys.vo.RoleVO;
import com.geoway.ns.sys.vo.TenantRoleVO;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RoleServiceImpl
implements RoleService {
    @Value(value="${sso.url:''}")
    private String url;
    @Resource
    private AppCatalogRightMapper appCatalogRightMapper;

    @Override
    public IPage<RoleVO> queryPage(Integer page, Integer size, String key) {
        HttpRequest http = this.getHttp("/role/queryPage", Method.GET);
        http.form("page", (Object)page);
        http.form("size", (Object)size);
        http.form("filterParam", (Object)(key + ";type_EQ_1"));
        IPage result = this.getResult(http.execute(), IPage.class);
        List records = result.getRecords();
        List collect = records.stream().map(m -> RoleVO.builder().id(m.getString("id")).name(m.getString("name")).bz(m.getString("bz")).createTime(m.getString("createTime")).build()).collect(Collectors.toList());
        result.setRecords(collect);
        return result;
    }

    @Override
    public JSONObject queryTree(String filterParam) {
        HttpRequest http = this.getHttp("/role/queryTree", Method.GET);
        http.form("filterParam", (Object)filterParam);
        String result = http.execute().body();
        return JSONObject.parseObject((String)result);
    }

    @Override
    public IPage<RoleVO> queryByCatalogId(Integer page, Integer size, String catalogId, String filterParam) {
        List<String> roleIds = this.appCatalogRightMapper.selectRoleIdsByCatalogId(catalogId);
        String queryRoleIds = roleIds.stream().collect(Collectors.joining(","));
        filterParam = filterParam + ";id_IN_" + queryRoleIds;
        return this.queryPage(page, size, filterParam);
    }

    @Override
    public IPage<TenantRoleVO> queryTenantRolePage(Integer page, Integer size, String filterParam) {
        HttpRequest http = this.getHttp("/tenant/queryPage", Method.GET);
        http.form("page", (Object)page);
        http.form("size", (Object)size);
        http.form("filterParam", (Object)filterParam);
        IPage result = this.getResult(http.execute(), IPage.class);
        List records = result.getRecords();
        List collect = records.stream().map(m -> TenantRoleVO.builder().id(m.getString("id")).name(m.getString("name")).bz(m.getString("bz")).createTime(m.getString("createtime")).defaultRoleId(m.getString("defaultRoleId")).key(m.getString("key")).build()).collect(Collectors.toList());
        result.setRecords(collect);
        return result;
    }

    private HttpRequest getHttp(String path, Method method) {
        String access_token = MyRequestUtil.queryAccessTokenInHeader();
        String tenantid = MyRequestUtil.queryAccessAppTENANTIDInHeader();
        String tenantisolate = MyRequestUtil.queryAccessAppTENANTISOLATEInHeader();
        String tenantkey = MyRequestUtil.queryAccessAppTENANTKEYInHeader();
        return (HttpRequest)((HttpRequest)((HttpRequest)HttpUtil.createRequest((Method)method, (String)(this.url + path)).header("access_token", access_token)).header("tenantId", tenantid)).header("tenantKey", tenantkey);
    }

    private <T> T getResult(HttpResponse execute, Class<T> tClass) {
        int status = execute.getStatus();
        if (status != 200) {
            throw new RuntimeException(execute.body());
        }
        JSONObject object = JSON.parseObject((String)execute.body());
        Integer code = object.getInteger("code");
        if (code != 200) {
            throw new RuntimeException(object.getString("message"));
        }
        return (T)object.getObject("data", tClass);
    }
}

