/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.service.impl;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.sys.service.IUISConfigService;
import com.geoway.ns.sys.service.IUISRestAPIService;
import com.geoway.ns.sys.support.AESECB;
import com.geoway.ns.sys.utils.Md5Utils;
import com.geoway.ns.sys.utils.MyRequestUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uisRestAPIServiceImpl")
public class UISRestAPIServiceImpl
implements IUISRestAPIService {
    @Autowired
    IUISConfigService uisConfigService;

    @Override
    public JSONObject getUserInfo(String token) throws Exception {
        String api = "/rest/user/getUserInfo";
        JSONObject postParam = new JSONObject();
        postParam.put("token", (Object)token);
        return this.postUISApi(api, postParam, token);
    }

    @Override
    public JSONObject getUserById(String token, String userId) throws Exception {
        String api = "/rest/user/getUserInfo";
        JSONObject postParam = new JSONObject();
        api = api + "?userId=" + userId;
        return this.postUISApi(api, postParam, token);
    }

    @Override
    public JSONObject getUserById(String token, String userId, Integer userSys) throws Exception {
        String api = "/rest/user/getUserInfo";
        JSONObject postParam = new JSONObject();
        api = api + "?userId=" + userId + "&userSys=" + userSys;
        return this.postUISApi(api, postParam, token);
    }

    @Override
    public JSONObject getSimpleUserInfo(String token, String username) throws Exception {
        String api = "/rest/user/getSimpleUserInfo";
        JSONObject postParam = new JSONObject();
        postParam.put("token", (Object)token);
        postParam.put("username", (Object)username);
        return this.postUISApi(api, postParam, token);
    }

    @Override
    public JSONObject getUserList(String token, String filterParam) throws Exception {
        String api = "/rest/user/getUserList";
        JSONObject postParam = new JSONObject();
        postParam.put("token", (Object)token);
        postParam.put("pageIndex", (Object)1);
        postParam.put("pageSize", (Object)Integer.MAX_VALUE);
        if (StringUtils.isNotEmpty((CharSequence)filterParam)) {
            postParam.put("filterParam", (Object)filterParam);
        }
        return this.postFormUrlencodedUISApi(api, postParam, token);
    }

    @Override
    public JSONObject queryUserList(String token, String filterParam) throws Exception {
        String api = "/user/queryList";
        HttpRequest httpPost = this.getHttp(api, Method.GET);
        httpPost.form("filterParam", (Object)filterParam);
        httpPost.form("page", (Object)1);
        httpPost.form("size", (Object)Integer.MAX_VALUE);
        HttpResponse resp = httpPost.execute();
        return JSON.parseObject((String)resp.body());
    }

    @Override
    public JSONObject getOrgTree(String pid, String recursive, String token) throws Exception {
        String api = "/rest/org/getOrgTree";
        JSONObject postParam = new JSONObject();
        postParam.put("pid", (Object)pid);
        postParam.put("recursive", (Object)recursive);
        postParam.put("token", (Object)token);
        return this.postUISApi(api, postParam, token);
    }

    @Override
    public JSONObject getOrgInfo(String id, String recursive, String username, String token) throws Exception {
        String api = "/rest/org/getOrgInfo";
        JSONObject postParam = new JSONObject();
        postParam.put("id", (Object)id);
        postParam.put("recursive", (Object)recursive);
        postParam.put("token", (Object)token);
        postParam.put("username", (Object)username);
        return this.postUISApi(api, postParam, token);
    }

    @Override
    public JSONObject modifyUserPwd(String username, String id, String password, String token) throws Exception {
        String api = "/rest/user/modify";
        JSONObject postParam = new JSONObject();
        JSONObject userJson = new JSONObject();
        userJson.put("id", (Object)id);
        userJson.put("username", (Object)username);
        userJson.put("password", (Object)password);
        postParam.put("user", (Object)userJson);
        postParam.put("token", (Object)token);
        return this.postUISApi(api, postParam, token);
    }

    @Override
    public JSONObject getRoleTree(String token, String filterParam) throws Exception {
        String api = "/rest/role/queryTree";
        JSONObject postParam = new JSONObject();
        postParam.put("filterParam", (Object)filterParam);
        postParam.put("token", (Object)token);
        return this.postUISApi(api, postParam, token);
    }

    @Override
    public JSONObject getPermission(String token, String roleIds) throws Exception {
        String api = "/rest/role/permissions";
        JSONObject postParam = new JSONObject();
        postParam.put("roleIds", (Object)roleIds);
        postParam.put("token", (Object)token);
        return this.postUISApi(api, postParam, token);
    }

    @Override
    public JSONObject queryOrgListTree(String token, String filterParam) throws Exception {
        String api = "/organization/queryTree";
        String url = this.uisConfigService.getUISURL() + api;
        HashMap<String, String> formParam = new HashMap<String, String>();
        formParam.put("filterParam", filterParam);
        String tenantid = MyRequestUtil.queryAccessAppTENANTIDInHeader();
        String tenantkey = MyRequestUtil.queryAccessAppTENANTKEYInHeader();
        String result = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.get((String)url).header("access_token", token)).header("tenantId", tenantid)).header("tenantKey", tenantkey)).form(formParam).contentType("application/json").charset(CharsetUtil.CHARSET_UTF_8)).execute().body();
        return JSONObject.parseObject((String)result);
    }

    @Override
    public JSONObject queryOrgInfo(String token, String id, String filterParam) throws Exception {
        String api = "/organization/findOne";
        String url = this.uisConfigService.getUISURL() + api;
        HashMap<String, String> formParam = new HashMap<String, String>();
        formParam.put("id", id);
        formParam.put("filterParam", filterParam);
        String tenantid = MyRequestUtil.queryAccessAppTENANTIDInHeader();
        String tenantkey = MyRequestUtil.queryAccessAppTENANTKEYInHeader();
        String result = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.get((String)url).header("access_token", token)).header("tenantId", tenantid)).header("tenantKey", tenantkey)).form(formParam).contentType("application/json").charset(CharsetUtil.CHARSET_UTF_8)).execute().body();
        return JSONObject.parseObject((String)result);
    }

    @Override
    public JSONObject queryRelUsers(String token, String orgId) throws Exception {
        String api = "/organization/users?orgId=" + orgId;
        JSONObject postParam = new JSONObject();
        return this.postUISApi(api, postParam, token);
    }

    @Override
    public JSONObject queryUserCount(String token, String filterParam) {
        String api = "/user/queryCount";
        String url = this.uisConfigService.getUISURL() + api;
        HashMap<String, String> formParam = new HashMap<String, String>();
        formParam.put("filterParam", filterParam);
        String tenantid = MyRequestUtil.queryAccessAppTENANTIDInHeader();
        String tenantkey = MyRequestUtil.queryAccessAppTENANTKEYInHeader();
        String result = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.get((String)url).header("access_token", token)).header("tenantId", tenantid)).header("tenantKey", tenantkey)).form(formParam).contentType("application/json").charset(CharsetUtil.CHARSET_UTF_8)).execute().body();
        return JSONObject.parseObject((String)result);
    }

    @Override
    public String queryCodeByToken(String token) throws Exception {
        String api = "/oauth2/access_code?access_token=" + token;
        HttpRequest http = this.getHttp("/oauth2/access_code", Method.GET);
        http.form("appId", (Object)this.uisConfigService.getAppkey());
        http.form("appSecret", (Object)this.uisConfigService.getAppkey());
        http.form("access_token", (Object)token);
        HttpResponse execute = http.execute();
        JSONObject object = JSON.parseObject((String)execute.body());
        Integer code = object.getInteger("code");
        if (code != 200) {
            throw new RuntimeException("\u96c6\u6210\u6846\u67b6\u8c03\u7528\u5931\u8d25\uff1a" + object.getString("message"));
        }
        return object.getString("data");
    }

    private HttpRequest getHttp(String path, Method method) {
        String access_token = MyRequestUtil.queryAccessTokenInHeader();
        String tenantid = MyRequestUtil.queryAccessAppTENANTIDInHeader();
        String tenantisolate = MyRequestUtil.queryAccessAppTENANTISOLATEInHeader();
        String tenantkey = MyRequestUtil.queryAccessAppTENANTKEYInHeader();
        return (HttpRequest)((HttpRequest)((HttpRequest)HttpUtil.createRequest((Method)method, (String)(this.uisConfigService.getUISURL() + path)).header("access_token", access_token)).header("tenantId", tenantid)).header("tenantKey", tenantkey);
    }

    private JSONObject postUISApi(String api, JSONObject postParam, String token) throws Exception {
        String url = this.uisConfigService.getUISURL() + api;
        String appkey = this.uisConfigService.getAppkey();
        String appsecret = this.uisConfigService.getAppsecret();
        String timestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        url = url.indexOf("?") == -1 ? String.format("%s?appkey=%s&timestamp=%s&token=%s", url, appkey, timestamp, token) : String.format("%s&appkey=%s&timestamp=%s&token=%s", url, appkey, timestamp, token);
        String appsecretMd5 = Md5Utils.getMD5Str16(appsecret, "utf-8");
        String sign = null;
        try {
            sign = AESECB.encrypt(appsecretMd5, url);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        url = String.format("%s&sign=%s", url, sign);
        JSONObject realPostParam = new JSONObject();
        realPostParam.put("appkey", (Object)appkey);
        realPostParam.put("timestamp", (Object)timestamp);
        realPostParam.put("sign", (Object)sign);
        if (postParam != null) {
            for (String key : postParam.keySet()) {
                realPostParam.put(key, postParam.get((Object)key));
            }
        }
        String tenantid = MyRequestUtil.queryAccessAppTENANTIDInHeader();
        String tenantkey = MyRequestUtil.queryAccessAppTENANTKEYInHeader();
        String result = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)url).header("access_token", token)).header("tenantId", tenantid)).header("tenantKey", tenantkey)).body(realPostParam.toJSONString()).contentType("application/json").charset(CharsetUtil.CHARSET_UTF_8)).execute().body();
        return JSONObject.parseObject((String)result);
    }

    private JSONObject postFormUrlencodedUISApi(String api, JSONObject postParam, String token) throws Exception {
        String url = this.uisConfigService.getUISURL() + api;
        String appkey = this.uisConfigService.getAppkey();
        String appsecret = this.uisConfigService.getAppsecret();
        String timestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        url = String.format("%s?appkey=%s&timestamp=%s&token=%s", url, appkey, timestamp, token);
        String appsecretMd5 = Md5Utils.getMD5Str16(appsecret, "utf-8");
        String sign = null;
        try {
            sign = AESECB.encrypt(appsecretMd5, url);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        url = String.format("%s&sign=%s", url, sign);
        String postData = "";
        if (postParam != null) {
            for (String key : postParam.keySet()) {
                postData = postData + "&" + key + "=" + postParam.get((Object)key);
            }
        }
        if (postData.startsWith("&")) {
            postData = postData.substring(1);
        }
        String tenantid = MyRequestUtil.queryAccessAppTENANTIDInHeader();
        String tenantkey = MyRequestUtil.queryAccessAppTENANTKEYInHeader();
        String result = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)url).header("access_token", token)).header("tenantId", tenantid)).header("tenantKey", tenantkey)).body(postData).contentType("application/x-www-form-urlencoded").charset(CharsetUtil.CHARSET_UTF_8)).execute().body();
        return JSONObject.parseObject((String)result);
    }
}

