/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.sys.dto.BaseObjectResponse;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.service.NsUserService;
import com.geoway.ns.sys.utils.MyRequestUtil;
import com.geoway.sso.client.client.SystemClient;
import com.geoway.sso.client.client.UserClient;
import com.geoway.sso.client.rpc.RpcSysUser;
import com.geoway.sso.client.rpc.RpcSystemInfoDTO;
import com.geoway.sso.client.rpc.RpcUserOnlineStatDTO;
import com.geoway.sso.client.rpc.SsoUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/user"})
public class UserController {
    private final Logger logger = LoggerFactory.getLogger(UserController.class);
    @Autowired
    private ITokenService tokenService;
    @Autowired
    NsUserService userService;
    @Autowired
    UserClient userClient;
    @Autowired
    SystemClient systemClient;
    @Value(value="${security.token-prefix:'Geoway'}")
    private String guestTokenPrefix;
    @Value(value="${security.guest-visit:false}")
    private Boolean guestVisit;
    @Value(value="${project.system-id:''}")
    private String systemId;

    @ApiOperation(value="1-\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"userInfo"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse<SysUserDTO> queryUserInfo(HttpServletRequest request, @RequestParam(required=false, defaultValue="") String systemKey, @RequestParam(required=false, defaultValue="") String tenantKey) {
        DataResponse<SysUserDTO> response = new DataResponse<SysUserDTO>();
        try {
            JSONObject parseObject;
            String token = MyRequestUtil.queryAccessTokenInHeader(request);
            if (StringUtils.isEmpty((CharSequence)token) || this.guestVisit.booleanValue() && token.startsWith(this.guestTokenPrefix)) {
                return response;
            }
            SysUserDTO userDTO = this.tokenService.querySysUserByToken(token, true);
            RpcSysUser rpcSysUser = this.userClient.getCurrentUserInfo();
            JSONObject jSONObject = parseObject = rpcSysUser == null || rpcSysUser.getParams() == null ? new JSONObject() : JSON.parseObject((String)rpcSysUser.getParams());
            if (parseObject != null) {
                if (parseObject.containsKey((Object)tenantKey)) {
                    userDTO.setTitle(parseObject.getString(tenantKey));
                } else if (StrUtil.isNotEmpty((CharSequence)tenantKey) && !tenantKey.equals("undefined") && !tenantKey.equals("null")) {
                    RpcSystemInfoDTO rpcSystemInfoDTO = this.systemClient.querySystemInfoByKey(systemKey);
                    userDTO.setTitle(rpcSystemInfoDTO.getSystem().getName());
                } else if (parseObject.containsKey((Object)"systemTitle")) {
                    userDTO.setTitle(parseObject.getString("systemTitle"));
                }
            }
            try {
                userDTO.setTel(this.userClient.getCurrentUserRealTel());
            }
            catch (Exception exception) {
                // empty catch block
            }
            response.setResult(userDTO);
            response.setShowData(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="2-\u5206\u9875\u67e5\u8be2")
    @RequestMapping(value={"list"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public BaseResponse listUser(HttpServletRequest request, @RequestParam(defaultValue="1", required=false) int page, @RequestParam(defaultValue="1", required=false) int rows) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader(request);
            response.setData(this.tokenService.getUserList(token));
        }
        catch (Exception ex) {
            response.setMessage(ex.getMessage());
            response.setStatus("FAILURE");
        }
        return response;
    }

    @ApiOperation(value="3-\u4fee\u6539\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"modify"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public BaseResponse modifyUser(HttpServletRequest request, @RequestParam(required=false, defaultValue="") String title, @RequestParam(required=false, defaultValue="") String tel, @RequestParam(required=false, defaultValue="") String worktel, @RequestParam(required=false, defaultValue="") String email, @RequestParam(required=false, defaultValue="") String tenantKey) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader(request);
            SysUserDTO userDTO = this.tokenService.querySysUserByToken(token);
            if (userDTO == null) {
                throw new Exception("token\u5df2\u8fc7\u671f\u6216\u5931\u6548,\u8bf7\u91cd\u65b0\u767b\u5f55");
            }
            if (StrUtil.isNotBlank((CharSequence)tel)) {
                this.userService.updateUserBaseInfo(userDTO.getId(), tel, worktel, email);
            } else {
                this.userService.updateUserBaseInfo2(userDTO.getId(), title, tenantKey);
            }
        }
        catch (Exception ex) {
            response.setMessage(ex.getMessage());
            response.setStatus("FAILURE");
        }
        return response;
    }

    @ApiOperation(value="4-\u4fee\u6539\u5f53\u524d\u767b\u5f55\u7528\u6237\u5bc6\u7801")
    @RequestMapping(value={"/changePwd"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse changePwd(HttpServletRequest request, @RequestParam(value="oldPwd") String oldPwd, @RequestParam(value="newPwd") String newPwd) {
        BaseResponse response = new BaseResponse();
        try {
            this.userService.changePasswordByUserId(oldPwd, newPwd);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="5-\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u7528\u6236\u6570\u91cf")
    @RequestMapping(value={"/queryUserCount"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseObjectResponse queryUserCount(HttpServletRequest request, @RequestParam(value="filterParam", defaultValue="") String filterParam) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            RpcUserOnlineStatDTO rpcUserOnlineStatDTO = this.userClient.getUserOnlineStatInfo();
            if (rpcUserOnlineStatDTO != null && rpcUserOnlineStatDTO.getUsers() != null && rpcUserOnlineStatDTO.getUsers().size() > 0) {
                List userList;
                List users = rpcUserOnlineStatDTO.getUsers();
                ArrayList<String> userIds = new ArrayList<String>();
                String userFilterParam = "";
                JSONArray oUsers = new JSONArray();
                Integer maxSize = 20;
                for (int i = 0; i < users.size() && i < maxSize; ++i) {
                    userIds.add(((SsoUser)users.get(i)).getId());
                    oUsers.add((Object)JSONObject.parseObject((String)JSONObject.toJSONString(users.get(i))));
                }
                if (oUsers.size() > 0) {
                    userFilterParam = userFilterParam + "Q_id_S_IN=" + String.join((CharSequence)",", userIds);
                }
                if ((userList = this.userClient.getUserList(userFilterParam)) != null && userList.size() > 0) {
                    block3: for (int i = 0; i < userList.size(); ++i) {
                        for (int j = 0; j < users.size(); ++j) {
                            if (!((RpcSysUser)userList.get(i)).getId().equals(oUsers.getJSONObject(j).getString("id"))) continue;
                            oUsers.getJSONObject(j).put("info", userList.get(i));
                            continue block3;
                        }
                    }
                }
                JSONObject jsonObject = JSON.parseObject((String)JSONObject.toJSONString((Object)rpcUserOnlineStatDTO));
                jsonObject.put("users", (Object)oUsers);
                response.setData(jsonObject);
            } else {
                response.setData(rpcUserOnlineStatDTO);
            }
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
        }
        return response;
    }
}

