/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sys.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.ns.sys.dto.BaseResponse;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ActuatorCheckInterceptor
extends HandlerInterceptorAdapter {
    Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Value(value="${Actuator.check:false}")
    public Boolean checkEnable;
    @Value(value="${Actuator.authCode:gw123456789}")
    public String authCode;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String authCode = request.getParameter("authCode");
        if (this.checkEnable.booleanValue() && !authCode.equals(authCode)) {
            System.out.println("\u7cfb\u7edf\u672a\u6388\u6743,\u670d\u52a1\u4e0d\u53ef\u7528");
            this.markInValidResponse(response);
        }
        return super.preHandle(request, response, handler);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
    }

    private void markInValidResponse(HttpServletResponse response) throws IOException {
        response.setStatus(HttpStatus.OK.value());
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        BaseResponse baseResopnse = new BaseResponse();
        baseResopnse.markFailure();
        baseResopnse.setMessage("\u7cfb\u7edf\u672a\u6388\u6743\uff0c\u670d\u52a1\u4e0d\u53ef\u7528");
        String jsonResult = JSON.toJSONString((Object)baseResopnse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty});
        response.getWriter().write(jsonResult);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Boolean getCheckEnable() {
        return this.checkEnable;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setCheckEnable(Boolean checkEnable) {
        this.checkEnable = checkEnable;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActuatorCheckInterceptor)) {
            return false;
        }
        ActuatorCheckInterceptor other = (ActuatorCheckInterceptor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$checkEnable = this.getCheckEnable();
        Boolean other$checkEnable = other.getCheckEnable();
        if (this$checkEnable == null ? other$checkEnable != null : !((Object)this$checkEnable).equals(other$checkEnable)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        String this$authCode = this.getAuthCode();
        String other$authCode = other.getAuthCode();
        return !(this$authCode == null ? other$authCode != null : !this$authCode.equals(other$authCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActuatorCheckInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $checkEnable = this.getCheckEnable();
        result = result * 59 + ($checkEnable == null ? 43 : ((Object)$checkEnable).hashCode());
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        String $authCode = this.getAuthCode();
        result = result * 59 + ($authCode == null ? 43 : $authCode.hashCode());
        return result;
    }

    public String toString() {
        return "ActuatorCheckInterceptor(logger=" + this.getLogger() + ", checkEnable=" + this.getCheckEnable() + ", authCode=" + this.getAuthCode() + ")";
    }
}

